/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.util;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TreeNode;
import tools.jackson.core.Version;
import tools.jackson.core.io.CharacterEscapes;
import tools.jackson.core.util.JacksonFeatureSet;

public class JsonGeneratorDelegate
extends JsonGenerator {
    protected JsonGenerator delegate;
    protected boolean delegateCopyMethods;

    public JsonGeneratorDelegate(JsonGenerator d) {
        this(d, true);
    }

    public JsonGeneratorDelegate(JsonGenerator d, boolean delegateCopyMethods) {
        this.delegate = d;
        this.delegateCopyMethods = delegateCopyMethods;
    }

    @Override
    public Object currentValue() {
        return this.delegate.currentValue();
    }

    @Override
    public void assignCurrentValue(Object v) {
        this.delegate.assignCurrentValue(v);
    }

    @Override
    public FormatSchema getSchema() {
        return this.delegate.getSchema();
    }

    @Override
    public Version version() {
        return this.delegate.version();
    }

    @Override
    public Object streamWriteOutputTarget() {
        return this.delegate.streamWriteOutputTarget();
    }

    @Override
    public int streamWriteOutputBuffered() {
        return this.delegate.streamWriteOutputBuffered();
    }

    @Override
    public boolean canWriteTypeId() {
        return this.delegate.canWriteTypeId();
    }

    @Override
    public boolean canWriteObjectId() {
        return this.delegate.canWriteObjectId();
    }

    @Override
    public boolean canOmitProperties() {
        return this.delegate.canOmitProperties();
    }

    @Override
    public JacksonFeatureSet<StreamWriteCapability> streamWriteCapabilities() {
        return this.delegate.streamWriteCapabilities();
    }

    @Override
    public boolean isEnabled(StreamWriteFeature f) {
        return this.delegate.isEnabled(f);
    }

    @Override
    public int streamWriteFeatures() {
        return this.delegate.streamWriteFeatures();
    }

    @Override
    public JsonGenerator configure(StreamWriteFeature f, boolean state) {
        this.delegate.configure(f, state);
        return this;
    }

    @Override
    public int getHighestNonEscapedChar() {
        return this.delegate.getHighestNonEscapedChar();
    }

    @Override
    public CharacterEscapes getCharacterEscapes() {
        return this.delegate.getCharacterEscapes();
    }

    @Override
    public JsonGenerator writeStartArray() throws JacksonException {
        this.delegate.writeStartArray();
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(Object forValue) throws JacksonException {
        this.delegate.writeStartArray(forValue);
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(Object forValue, int size) throws JacksonException {
        this.delegate.writeStartArray(forValue, size);
        return this;
    }

    @Override
    public JsonGenerator writeEndArray() throws JacksonException {
        this.delegate.writeEndArray();
        return this;
    }

    @Override
    public JsonGenerator writeStartObject() throws JacksonException {
        this.delegate.writeStartObject();
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(Object forValue) throws JacksonException {
        this.delegate.writeStartObject(forValue);
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(Object forValue, int size) throws JacksonException {
        this.delegate.writeStartObject(forValue, size);
        return this;
    }

    @Override
    public JsonGenerator writeEndObject() throws JacksonException {
        this.delegate.writeEndObject();
        return this;
    }

    @Override
    public JsonGenerator writeName(String name) throws JacksonException {
        this.delegate.writeName(name);
        return this;
    }

    @Override
    public JsonGenerator writeName(SerializableString name) throws JacksonException {
        this.delegate.writeName(name);
        return this;
    }

    @Override
    public JsonGenerator writePropertyId(long id) throws JacksonException {
        this.delegate.writePropertyId(id);
        return this;
    }

    @Override
    public JsonGenerator writeArray(int[] array, int offset, int length) throws JacksonException {
        this.delegate.writeArray(array, offset, length);
        return this;
    }

    @Override
    public JsonGenerator writeArray(long[] array, int offset, int length) throws JacksonException {
        this.delegate.writeArray(array, offset, length);
        return this;
    }

    @Override
    public JsonGenerator writeArray(double[] array, int offset, int length) throws JacksonException {
        this.delegate.writeArray(array, offset, length);
        return this;
    }

    @Override
    public JsonGenerator writeArray(String[] array, int offset, int length) throws JacksonException {
        this.delegate.writeArray(array, offset, length);
        return this;
    }

    @Override
    public JsonGenerator writeString(String text) throws JacksonException {
        this.delegate.writeString(text);
        return this;
    }

    @Override
    public JsonGenerator writeString(Reader reader, int len) throws JacksonException {
        this.delegate.writeString(reader, len);
        return this;
    }

    @Override
    public JsonGenerator writeString(char[] text, int offset, int len) throws JacksonException {
        this.delegate.writeString(text, offset, len);
        return this;
    }

    @Override
    public JsonGenerator writeString(SerializableString text) throws JacksonException {
        this.delegate.writeString(text);
        return this;
    }

    @Override
    public JsonGenerator writeRawUTF8String(byte[] text, int offset, int length) throws JacksonException {
        this.delegate.writeRawUTF8String(text, offset, length);
        return this;
    }

    @Override
    public JsonGenerator writeUTF8String(byte[] text, int offset, int length) throws JacksonException {
        this.delegate.writeUTF8String(text, offset, length);
        return this;
    }

    @Override
    public JsonGenerator writeRaw(String text) throws JacksonException {
        this.delegate.writeRaw(text);
        return this;
    }

    @Override
    public JsonGenerator writeRaw(String text, int offset, int len) throws JacksonException {
        this.delegate.writeRaw(text, offset, len);
        return this;
    }

    @Override
    public JsonGenerator writeRaw(SerializableString raw) throws JacksonException {
        this.delegate.writeRaw(raw);
        return this;
    }

    @Override
    public JsonGenerator writeRaw(char[] text, int offset, int len) throws JacksonException {
        this.delegate.writeRaw(text, offset, len);
        return this;
    }

    @Override
    public JsonGenerator writeRaw(char c) throws JacksonException {
        this.delegate.writeRaw(c);
        return this;
    }

    @Override
    public JsonGenerator writeRawValue(String text) throws JacksonException {
        this.delegate.writeRawValue(text);
        return this;
    }

    @Override
    public JsonGenerator writeRawValue(String text, int offset, int len) throws JacksonException {
        this.delegate.writeRawValue(text, offset, len);
        return this;
    }

    @Override
    public JsonGenerator writeRawValue(char[] text, int offset, int len) throws JacksonException {
        this.delegate.writeRawValue(text, offset, len);
        return this;
    }

    @Override
    public JsonGenerator writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws JacksonException {
        this.delegate.writeBinary(b64variant, data, offset, len);
        return this;
    }

    @Override
    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) throws JacksonException {
        return this.delegate.writeBinary(b64variant, data, dataLength);
    }

    @Override
    public JsonGenerator writeNumber(short v) throws JacksonException {
        this.delegate.writeNumber(v);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(int v) throws JacksonException {
        this.delegate.writeNumber(v);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(long v) throws JacksonException {
        this.delegate.writeNumber(v);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(BigInteger v) throws JacksonException {
        this.delegate.writeNumber(v);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(double v) throws JacksonException {
        this.delegate.writeNumber(v);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(float v) throws JacksonException {
        this.delegate.writeNumber(v);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(BigDecimal v) throws JacksonException {
        this.delegate.writeNumber(v);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(String encodedValue) throws JacksonException {
        this.delegate.writeNumber(encodedValue);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(char[] encodedValueBuffer, int offset, int length) throws JacksonException {
        this.delegate.writeNumber(encodedValueBuffer, offset, length);
        return this;
    }

    @Override
    public JsonGenerator writeBoolean(boolean state) throws JacksonException {
        this.delegate.writeBoolean(state);
        return this;
    }

    @Override
    public JsonGenerator writeNull() throws JacksonException {
        this.delegate.writeNull();
        return this;
    }

    @Override
    public JsonGenerator writeOmittedProperty(String propName) throws JacksonException {
        this.delegate.writeOmittedProperty(propName);
        return this;
    }

    @Override
    public JsonGenerator writeObjectId(Object id) throws JacksonException {
        this.delegate.writeObjectId(id);
        return this;
    }

    @Override
    public JsonGenerator writeObjectRef(Object id) throws JacksonException {
        this.delegate.writeObjectRef(id);
        return this;
    }

    @Override
    public JsonGenerator writeTypeId(Object id) throws JacksonException {
        this.delegate.writeTypeId(id);
        return this;
    }

    @Override
    public JsonGenerator writeEmbeddedObject(Object object) throws JacksonException {
        this.delegate.writeEmbeddedObject(object);
        return this;
    }

    @Override
    public JsonGenerator writePOJO(Object pojo) throws JacksonException {
        if (this.delegateCopyMethods) {
            this.delegate.writePOJO(pojo);
            return this;
        }
        if (pojo == null) {
            this.writeNull();
        } else {
            this.objectWriteContext().writeValue(this, pojo);
        }
        return this;
    }

    @Override
    public JsonGenerator writeTree(TreeNode tree) throws JacksonException {
        if (this.delegateCopyMethods) {
            this.delegate.writeTree(tree);
            return this;
        }
        if (tree == null) {
            this.writeNull();
        } else {
            this.objectWriteContext().writeTree(this, tree);
        }
        return this;
    }

    @Override
    public void copyCurrentEvent(JsonParser p) throws JacksonException {
        if (this.delegateCopyMethods) {
            this.delegate.copyCurrentEvent(p);
        } else {
            super.copyCurrentEvent(p);
        }
    }

    @Override
    public void copyCurrentStructure(JsonParser p) throws JacksonException {
        if (this.delegateCopyMethods) {
            this.delegate.copyCurrentStructure(p);
        } else {
            super.copyCurrentStructure(p);
        }
    }

    @Override
    public TokenStreamContext streamWriteContext() {
        return this.delegate.streamWriteContext();
    }

    @Override
    public ObjectWriteContext objectWriteContext() {
        return this.delegate.objectWriteContext();
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public JsonGenerator delegate() {
        return this.delegate;
    }
}

