/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.io.CharTypes;
import tools.jackson.core.io.CharacterEscapes;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.io.NumberOutput;
import tools.jackson.core.json.JsonGeneratorBase;
import tools.jackson.core.json.JsonWriteContext;
import tools.jackson.core.json.JsonWriteFeature;

public class UTF8JsonGenerator
extends JsonGeneratorBase {
    private static final byte BYTE_u = 117;
    private static final byte BYTE_0 = 48;
    private static final byte BYTE_LBRACKET = 91;
    private static final byte BYTE_RBRACKET = 93;
    private static final byte BYTE_LCURLY = 123;
    private static final byte BYTE_RCURLY = 125;
    private static final byte BYTE_BACKSLASH = 92;
    private static final byte BYTE_COMMA = 44;
    private static final byte BYTE_COLON = 58;
    private static final int MAX_BYTES_TO_BUFFER = 512;
    private static final byte[] HEX_BYTES_UPPER = CharTypes.copyHexBytes(true);
    private static final byte[] HEX_BYTES_LOWER = CharTypes.copyHexBytes(false);
    private static final byte[] NULL_BYTES = new byte[]{110, 117, 108, 108};
    private static final byte[] TRUE_BYTES = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE_BYTES = new byte[]{102, 97, 108, 115, 101};
    protected final OutputStream _outputStream;
    protected final byte _quoteChar;
    protected byte[] _outputBuffer;
    protected int _outputTail;
    protected final int _outputEnd;
    protected final int _outputMaxContiguous;
    protected char[] _charBuffer;
    protected final int _charBufferLength;
    protected byte[] _entityBuffer;
    protected boolean _bufferRecyclable;

    public UTF8JsonGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, int streamWriteFeatures, int formatWriteFeatures, OutputStream out, SerializableString rootValueSep, CharacterEscapes charEsc, PrettyPrinter pp, int maxNonEscaped, char quoteChar) {
        super(writeCtxt, ioCtxt, streamWriteFeatures, formatWriteFeatures, rootValueSep, pp, charEsc, maxNonEscaped);
        this._outputStream = out;
        this._quoteChar = (byte)quoteChar;
        this._bufferRecyclable = true;
        this._outputBuffer = ioCtxt.allocWriteEncodingBuffer();
        this._outputEnd = this._outputBuffer.length;
        this._outputMaxContiguous = this._outputEnd >> 3;
        this._charBuffer = ioCtxt.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
        this.setCharacterEscapes(charEsc);
    }

    public UTF8JsonGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, int streamWriteFeatures, int formatWriteFeatures, OutputStream out, SerializableString rootValueSep, CharacterEscapes charEsc, PrettyPrinter pp, int maxNonEscaped, char quoteChar, byte[] outputBuffer, int outputOffset, boolean bufferRecyclable) {
        super(writeCtxt, ioCtxt, streamWriteFeatures, formatWriteFeatures, rootValueSep, pp, charEsc, maxNonEscaped);
        this._outputStream = out;
        this._quoteChar = (byte)quoteChar;
        this._bufferRecyclable = bufferRecyclable;
        this._outputTail = outputOffset;
        this._outputBuffer = outputBuffer;
        this._outputEnd = this._outputBuffer.length;
        this._outputMaxContiguous = this._outputEnd >> 3;
        this._charBuffer = ioCtxt.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
        this.setCharacterEscapes(charEsc);
    }

    @Override
    public JsonGenerator setCharacterEscapes(CharacterEscapes esc) {
        this._characterEscapes = esc;
        this._outputEscapes = esc == null ? CharTypes.get7BitOutputEscapes(this._quoteChar, JsonWriteFeature.ESCAPE_FORWARD_SLASHES.enabledIn(this._formatWriteFeatures)) : esc.getEscapeCodesForAscii();
        return this;
    }

    @Override
    public Object streamWriteOutputTarget() {
        return this._outputStream;
    }

    @Override
    public int streamWriteOutputBuffered() {
        return this._outputTail;
    }

    @Override
    public JsonGenerator writeName(String name) throws JacksonException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPName(name);
            return this;
        }
        int status = this._streamWriteContext.writeName(name);
        if (status == 4) {
            this._reportError("Cannot write a property name, expecting a value");
        }
        if (status == 1) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            this._writeStringSegments(name, false);
            return this;
        }
        int len = name.length();
        if (len > this._charBufferLength) {
            this._writeStringSegments(name, true);
            return this;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (len <= this._outputMaxContiguous) {
            if (this._outputTail + len > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(name, 0, len);
        } else {
            this._writeStringSegments(name, 0, len);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        return this;
    }

    @Override
    public JsonGenerator writeName(SerializableString name) throws JacksonException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPName(name);
            return this;
        }
        int status = this._streamWriteContext.writeName(name.getValue());
        if (status == 4) {
            this._reportError("Cannot write a property name, expecting a value");
        }
        if (status == 1) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            this._writeUnq(name);
            return this;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        int len = name.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (len < 0) {
            this._writeBytes(name.asQuotedUTF8());
        } else {
            this._outputTail += len;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        return this;
    }

    private final void _writeUnq(SerializableString name) throws JacksonException {
        int len = name.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (len < 0) {
            this._writeBytes(name.asQuotedUTF8());
        } else {
            this._outputTail += len;
        }
    }

    @Override
    public JsonGenerator writeStartArray() throws JacksonException {
        this._verifyValueWrite("start an array");
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(null);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 91;
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(Object forValue) throws JacksonException {
        this._verifyValueWrite("start an array");
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(forValue);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 91;
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(Object forValue, int len) throws JacksonException {
        this._verifyValueWrite("start an array");
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(forValue);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 91;
        }
        return this;
    }

    @Override
    public JsonGenerator writeEndArray() throws JacksonException {
        if (!this._streamWriteContext.inArray()) {
            this._reportError("Current context not Array but " + this._streamWriteContext.typeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndArray(this, this._streamWriteContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 93;
        }
        this._streamWriteContext = this._streamWriteContext.clearAndGetParent();
        return this;
    }

    @Override
    public JsonGenerator writeStartObject() throws JacksonException {
        this._verifyValueWrite("start an object");
        this._streamWriteContext = this._streamWriteContext.createChildObjectContext(null);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 123;
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(Object forValue) throws JacksonException {
        this._verifyValueWrite("start an object");
        JsonWriteContext ctxt = this._streamWriteContext.createChildObjectContext(forValue);
        this.streamWriteConstraints().validateNestingDepth(ctxt.getNestingDepth());
        this._streamWriteContext = ctxt;
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 123;
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(Object forValue, int size) throws JacksonException {
        this._verifyValueWrite("start an object");
        JsonWriteContext ctxt = this._streamWriteContext.createChildObjectContext(forValue);
        this.streamWriteConstraints().validateNestingDepth(ctxt.getNestingDepth());
        this._streamWriteContext = ctxt;
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 123;
        }
        return this;
    }

    @Override
    public JsonGenerator writeEndObject() throws JacksonException {
        if (!this._streamWriteContext.inObject()) {
            this._reportError("Current context not Object but " + this._streamWriteContext.typeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndObject(this, this._streamWriteContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 125;
        }
        this._streamWriteContext = this._streamWriteContext.clearAndGetParent();
        return this;
    }

    protected final void _writePPName(String name) throws JacksonException {
        int status = this._streamWriteContext.writeName(name);
        if (status == 4) {
            this._reportError("Cannot write a property name, expecting a value");
        }
        if (status == 1) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (this._cfgUnqNames) {
            this._writeStringSegments(name, false);
            return;
        }
        int len = name.length();
        if (len > this._charBufferLength) {
            this._writeStringSegments(name, true);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        name.getChars(0, len, this._charBuffer, 0);
        if (len <= this._outputMaxContiguous) {
            if (this._outputTail + len > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(this._charBuffer, 0, len);
        } else {
            this._writeStringSegments(this._charBuffer, 0, len);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    protected final void _writePPName(SerializableString name) throws JacksonException {
        int len;
        boolean addQuotes;
        int status = this._streamWriteContext.writeName(name.getValue());
        if (status == 4) {
            this._reportError("Cannot write a property name, expecting a value");
        }
        if (status == 1) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        boolean bl = addQuotes = !this._cfgUnqNames;
        if (addQuotes) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
        if ((len = name.appendQuotedUTF8(this._outputBuffer, this._outputTail)) < 0) {
            this._writeBytes(name.asQuotedUTF8());
        } else {
            this._outputTail += len;
        }
        if (addQuotes) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
    }

    @Override
    public JsonGenerator writeString(String text) throws JacksonException {
        this._verifyValueWrite("write a string");
        if (text == null) {
            this._writeNull();
            return this;
        }
        int len = text.length();
        if (len > this._outputMaxContiguous) {
            this._writeStringSegments(text, true);
            return this;
        }
        if (this._outputTail + len >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeStringSegment(text, 0, len);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        return this;
    }

    @Override
    public JsonGenerator writeString(Reader reader, int len) throws JacksonException {
        this._verifyValueWrite("write a string");
        if (reader == null) {
            return (JsonGenerator)this._reportError("null reader");
        }
        int toRead = len >= 0 ? len : Integer.MAX_VALUE;
        char[] buf = this._charBuffer;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        while (toRead > 0) {
            int numRead;
            int toReadNow = Math.min(toRead, buf.length);
            try {
                numRead = reader.read(buf, 0, toReadNow);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            if (numRead <= 0) break;
            if (this._outputTail + len >= this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegments(buf, 0, numRead);
            toRead -= numRead;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (toRead > 0 && len >= 0) {
            this._reportError("Didn't read enough from reader");
        }
        return this;
    }

    @Override
    public JsonGenerator writeString(char[] text, int offset, int len) throws JacksonException {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (len <= this._outputMaxContiguous) {
            if (this._outputTail + len > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(text, offset, len);
        } else {
            this._writeStringSegments(text, offset, len);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        return this;
    }

    @Override
    public JsonGenerator writeString(SerializableString text) throws JacksonException {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        int len = text.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (len < 0) {
            this._writeBytes(text.asQuotedUTF8());
        } else {
            this._outputTail += len;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        return this;
    }

    @Override
    public JsonGenerator writeRawUTF8String(byte[] text, int offset, int len) throws JacksonException {
        this._checkRangeBoundsForByteArray(text, offset, len);
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeBytes(text, offset, len);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        return this;
    }

    @Override
    public JsonGenerator writeUTF8String(byte[] text, int offset, int len) throws JacksonException {
        this._checkRangeBoundsForByteArray(text, offset, len);
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (len <= this._outputMaxContiguous) {
            this._writeUTF8Segment(text, offset, len);
        } else {
            this._writeUTF8Segments(text, offset, len);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        return this;
    }

    @Override
    public JsonGenerator writeRaw(String text) throws JacksonException {
        char[] buf;
        int len = text.length();
        if (len <= (buf = this._charBuffer).length) {
            text.getChars(0, len, buf, 0);
            this.writeRaw(buf, 0, len);
        } else {
            this.writeRaw(text, 0, len);
        }
        return this;
    }

    @Override
    public JsonGenerator writeRaw(String text, int offset, int len) throws JacksonException {
        this._checkRangeBoundsForString(text, offset, len);
        char[] buf = this._charBuffer;
        int cbufLen = buf.length;
        if (len <= cbufLen) {
            text.getChars(offset, offset + len, buf, 0);
            this.writeRaw(buf, 0, len);
            return this;
        }
        int maxChunk = Math.min(cbufLen, (this._outputEnd >> 2) + (this._outputEnd >> 4));
        int maxBytes = maxChunk * 3;
        while (len > 0) {
            char ch;
            int len2 = Math.min(maxChunk, len);
            text.getChars(offset, offset + len2, buf, 0);
            if (this._outputTail + maxBytes > this._outputEnd) {
                this._flushBuffer();
            }
            if (len2 > 1 && (ch = buf[len2 - 1]) >= '\ud800' && ch <= '\udbff') {
                --len2;
            }
            this._writeRawSegment(buf, 0, len2);
            offset += len2;
            len -= len2;
        }
        return this;
    }

    @Override
    public JsonGenerator writeRaw(SerializableString text) throws JacksonException {
        int len = text.appendUnquotedUTF8(this._outputBuffer, this._outputTail);
        if (len < 0) {
            this._writeBytes(text.asUnquotedUTF8());
        } else {
            this._outputTail += len;
        }
        return this;
    }

    @Override
    public JsonGenerator writeRawValue(SerializableString text) throws JacksonException {
        this._verifyValueWrite("write a raw (unencoded) value");
        int len = text.appendUnquotedUTF8(this._outputBuffer, this._outputTail);
        if (len < 0) {
            this._writeBytes(text.asUnquotedUTF8());
        } else {
            this._outputTail += len;
        }
        return this;
    }

    @Override
    public JsonGenerator writeRaw(char[] cbuf, int offset, int len) throws JacksonException {
        this._checkRangeBoundsForCharArray(cbuf, offset, len);
        int len3 = len + len + len;
        if (this._outputTail + len3 > this._outputEnd) {
            if (this._outputEnd < len3) {
                this._writeSegmentedRaw(cbuf, offset, len);
                return this;
            }
            this._flushBuffer();
        }
        len += offset;
        block0: while (offset < len) {
            char ch;
            while ((ch = cbuf[offset]) <= '\u007f') {
                this._outputBuffer[this._outputTail++] = (byte)ch;
                if (++offset < len) continue;
                break block0;
            }
            ch = cbuf[offset++];
            if (ch < '\u0800') {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | ch >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            offset = this._outputRawMultiByteChar(ch, cbuf, offset, len);
        }
        return this;
    }

    @Override
    public JsonGenerator writeRaw(char ch) throws JacksonException {
        if (this._outputTail + 3 >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] bbuf = this._outputBuffer;
        if (ch <= '\u007f') {
            bbuf[this._outputTail++] = (byte)ch;
        } else if (ch < '\u0800') {
            bbuf[this._outputTail++] = (byte)(0xC0 | ch >> 6);
            bbuf[this._outputTail++] = (byte)(0x80 | ch & 0x3F);
        } else {
            this._outputRawMultiByteChar(ch, null, 0, 0);
        }
        return this;
    }

    private final void _writeSegmentedRaw(char[] cbuf, int offset, int len) throws JacksonException {
        int end = this._outputEnd;
        byte[] bbuf = this._outputBuffer;
        int inputEnd = offset + len;
        block0: while (offset < inputEnd) {
            char ch;
            while ((ch = cbuf[offset]) <= '\u007f') {
                if (this._outputTail >= end) {
                    this._flushBuffer();
                }
                bbuf[this._outputTail++] = (byte)ch;
                if (++offset < inputEnd) continue;
                break block0;
            }
            if (this._outputTail + 3 >= this._outputEnd) {
                this._flushBuffer();
            }
            if ((ch = cbuf[offset++]) < '\u0800') {
                bbuf[this._outputTail++] = (byte)(0xC0 | ch >> 6);
                bbuf[this._outputTail++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            offset = this._outputRawMultiByteChar(ch, cbuf, offset, inputEnd);
        }
    }

    private void _writeRawSegment(char[] cbuf, int offset, int end) throws JacksonException {
        block0: while (offset < end) {
            char ch;
            while ((ch = cbuf[offset]) <= '\u007f') {
                this._outputBuffer[this._outputTail++] = (byte)ch;
                if (++offset < end) continue;
                break block0;
            }
            ch = cbuf[offset++];
            if (ch < '\u0800') {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | ch >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            offset = this._outputRawMultiByteChar(ch, cbuf, offset, end);
        }
    }

    @Override
    public JsonGenerator writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws JacksonException {
        this._checkRangeBoundsForByteArray(data, offset, len);
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeBinary(b64variant, data, offset, offset + len);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) throws JacksonException {
        int bytes;
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        byte[] encodingBuffer = this._ioContext.allocBase64Buffer();
        try {
            if (dataLength < 0) {
                bytes = this._writeBinary(b64variant, data, encodingBuffer);
            } else {
                int missing = this._writeBinary(b64variant, data, encodingBuffer, dataLength);
                if (missing > 0) {
                    this._reportError("Too few bytes available: missing " + missing + " bytes (out of " + dataLength + ")");
                }
                bytes = dataLength;
            }
        }
        finally {
            this._ioContext.releaseBase64Buffer(encodingBuffer);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        return bytes;
    }

    @Override
    public JsonGenerator writeNumber(short s) throws JacksonException {
        this._verifyValueWrite("write a number");
        if (this._outputTail + 6 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedShort(s);
            return this;
        }
        this._outputTail = NumberOutput.outputInt((int)s, this._outputBuffer, this._outputTail);
        return this;
    }

    private final void _writeQuotedShort(short s) throws JacksonException {
        if (this._outputTail + 8 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputInt((int)s, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public JsonGenerator writeNumber(int i) throws JacksonException {
        this._verifyValueWrite("write a number");
        if (this._outputTail + 11 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedInt(i);
            return this;
        }
        this._outputTail = NumberOutput.outputInt(i, this._outputBuffer, this._outputTail);
        return this;
    }

    private final void _writeQuotedInt(int i) throws JacksonException {
        if (this._outputTail + 13 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputInt(i, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public JsonGenerator writeNumber(long l) throws JacksonException {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedLong(l);
            return this;
        }
        if (this._outputTail + 21 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
        return this;
    }

    private final void _writeQuotedLong(long l) throws JacksonException {
        if (this._outputTail + 23 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public JsonGenerator writeNumber(BigInteger value) throws JacksonException {
        this._verifyValueWrite("write a number");
        if (value == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(value.toString());
        } else {
            this.writeRaw(value.toString());
        }
        return this;
    }

    @Override
    public JsonGenerator writeNumber(double d) throws JacksonException {
        boolean useFast = this.isEnabled(StreamWriteFeature.USE_FAST_DOUBLE_WRITER);
        if (this._cfgNumbersAsStrings || NumberOutput.notFinite(d) && JsonWriteFeature.WRITE_NAN_AS_STRINGS.enabledIn(this._formatWriteFeatures)) {
            this.writeString(NumberOutput.toString(d, useFast));
            return this;
        }
        this._verifyValueWrite("write a number");
        return this.writeRaw(NumberOutput.toString(d, useFast));
    }

    @Override
    public JsonGenerator writeNumber(float f) throws JacksonException {
        boolean useFast = this.isEnabled(StreamWriteFeature.USE_FAST_DOUBLE_WRITER);
        if (this._cfgNumbersAsStrings || NumberOutput.notFinite(f) && JsonWriteFeature.WRITE_NAN_AS_STRINGS.enabledIn(this._formatWriteFeatures)) {
            this.writeString(NumberOutput.toString(f, useFast));
            return this;
        }
        this._verifyValueWrite("write a number");
        return this.writeRaw(NumberOutput.toString(f, useFast));
    }

    @Override
    public JsonGenerator writeNumber(BigDecimal value) throws JacksonException {
        this._verifyValueWrite("write a number");
        if (value == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(this._asString(value));
        } else {
            this.writeRaw(this._asString(value));
        }
        return this;
    }

    @Override
    public JsonGenerator writeNumber(String encodedValue) throws JacksonException {
        this._verifyValueWrite("write a number");
        if (encodedValue == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(encodedValue);
        } else {
            this.writeRaw(encodedValue);
        }
        return this;
    }

    @Override
    public JsonGenerator writeNumber(char[] encodedValueBuffer, int offset, int length) throws JacksonException {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(encodedValueBuffer, offset, length);
        } else {
            this.writeRaw(encodedValueBuffer, offset, length);
        }
        return this;
    }

    private final void _writeQuotedRaw(String value) throws JacksonException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this.writeRaw(value);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    private void _writeQuotedRaw(char[] text, int offset, int length) throws JacksonException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this.writeRaw(text, offset, length);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public JsonGenerator writeBoolean(boolean state) throws JacksonException {
        this._verifyValueWrite("write a boolean value");
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] keyword = state ? TRUE_BYTES : FALSE_BYTES;
        int len = keyword.length;
        System.arraycopy(keyword, 0, this._outputBuffer, this._outputTail, len);
        this._outputTail += len;
        return this;
    }

    @Override
    public JsonGenerator writeNull() throws JacksonException {
        this._verifyValueWrite("write a null");
        this._writeNull();
        return this;
    }

    @Override
    protected final void _verifyValueWrite(String typeMsg) throws JacksonException {
        int b;
        int status = this._streamWriteContext.writeValue();
        if (this._cfgPrettyPrinter != null) {
            this._verifyPrettyValueWrite(typeMsg, status);
            return;
        }
        switch (status) {
            default: {
                return;
            }
            case 1: {
                b = 44;
                break;
            }
            case 2: {
                b = 58;
                break;
            }
            case 3: {
                byte[] raw;
                if (this._rootValueSeparator != null && (raw = this._rootValueSeparator.asUnquotedUTF8()).length > 0) {
                    this._writeBytes(raw);
                }
                return;
            }
            case 5: {
                this._reportCantWriteValueExpectName(typeMsg);
                return;
            }
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = b;
    }

    @Override
    public void flush() throws JacksonException {
        this._flushBuffer();
        if (this._outputStream != null && this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
            try {
                this._outputStream.flush();
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
    }

    @Override
    protected void _closeInput() throws JacksonException {
        RuntimeException flushFail = null;
        try {
            if (this._outputBuffer != null && this.isEnabled(StreamWriteFeature.AUTO_CLOSE_CONTENT)) {
                while (true) {
                    TokenStreamContext ctxt;
                    if ((ctxt = this.streamWriteContext()).inArray()) {
                        this.writeEndArray();
                        continue;
                    }
                    if (!ctxt.inObject()) break;
                    this.writeEndObject();
                }
            }
            this._flushBuffer();
        }
        catch (RuntimeException e) {
            flushFail = e;
        }
        this._outputTail = 0;
        if (this._outputStream != null) {
            try {
                if (this._ioContext.isResourceManaged() || this.isEnabled(StreamWriteFeature.AUTO_CLOSE_TARGET)) {
                    this._outputStream.close();
                } else if (this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
                    this._outputStream.flush();
                }
            }
            catch (IOException e) {
                JacksonException je = this._wrapIOFailure(e);
                if (flushFail != null) {
                    je.addSuppressed(flushFail);
                }
                throw je;
            }
        }
        if (flushFail != null) {
            throw flushFail;
        }
    }

    @Override
    protected void _releaseBuffers() {
        char[] cbuf;
        byte[] buf = this._outputBuffer;
        if (buf != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseWriteEncodingBuffer(buf);
        }
        if ((cbuf = this._charBuffer) != null) {
            this._charBuffer = null;
            this._ioContext.releaseConcatBuffer(cbuf);
        }
    }

    private final void _writeBytes(byte[] bytes) throws JacksonException {
        int len = bytes.length;
        if (this._outputTail + len > this._outputEnd) {
            this._flushBuffer();
            if (len > 512) {
                try {
                    this._outputStream.write(bytes, 0, len);
                }
                catch (IOException e) {
                    throw this._wrapIOFailure(e);
                }
                return;
            }
        }
        System.arraycopy(bytes, 0, this._outputBuffer, this._outputTail, len);
        this._outputTail += len;
    }

    private final void _writeBytes(byte[] bytes, int offset, int len) throws JacksonException {
        if (this._outputTail + len > this._outputEnd) {
            this._flushBuffer();
            if (len > 512) {
                try {
                    this._outputStream.write(bytes, offset, len);
                }
                catch (IOException e) {
                    throw this._wrapIOFailure(e);
                }
                return;
            }
        }
        System.arraycopy(bytes, offset, this._outputBuffer, this._outputTail, len);
        this._outputTail += len;
    }

    private final void _writeStringSegments(String text, boolean addQuotes) throws JacksonException {
        int len;
        if (addQuotes) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
        int offset = 0;
        for (int left = text.length(); left > 0; left -= len) {
            len = Math.min(this._outputMaxContiguous, left);
            if (this._outputTail + len > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(text, offset, len);
            offset += len;
        }
        if (addQuotes) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
    }

    private final void _writeStringSegments(char[] cbuf, int offset, int totalLen) throws JacksonException {
        int len;
        do {
            if (this._outputTail + (len = Math.min(this._outputMaxContiguous, totalLen)) > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(cbuf, offset, len);
            offset += len;
        } while ((totalLen -= len) > 0);
    }

    private final void _writeStringSegments(String text, int offset, int totalLen) throws JacksonException {
        int len;
        do {
            if (this._outputTail + (len = Math.min(this._outputMaxContiguous, totalLen)) > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(text, offset, len);
            offset += len;
        } while ((totalLen -= len) > 0);
    }

    private final void _writeStringSegment(char[] cbuf, int offset, int len) throws JacksonException {
        char ch;
        len += offset;
        int outputPtr = this._outputTail;
        byte[] outputBuffer = this._outputBuffer;
        int[] escCodes = this._outputEscapes;
        while (offset < len && (ch = cbuf[offset]) <= '\u007f' && escCodes[ch] == 0) {
            outputBuffer[outputPtr++] = (byte)ch;
            ++offset;
        }
        this._outputTail = outputPtr;
        if (offset < len) {
            if (this._characterEscapes != null) {
                this._writeCustomStringSegment2(cbuf, offset, len);
            } else if (this._maximumNonEscapedChar == 0) {
                this._writeStringSegment2(cbuf, offset, len);
            } else {
                this._writeStringSegmentASCII2(cbuf, offset, len);
            }
        }
    }

    private final void _writeStringSegment(String text, int offset, int len) throws JacksonException {
        char ch;
        len += offset;
        int outputPtr = this._outputTail;
        byte[] outputBuffer = this._outputBuffer;
        int[] escCodes = this._outputEscapes;
        while (offset < len && (ch = text.charAt(offset)) <= '\u007f' && escCodes[ch] == 0) {
            outputBuffer[outputPtr++] = (byte)ch;
            ++offset;
        }
        this._outputTail = outputPtr;
        if (offset < len) {
            if (this._characterEscapes != null) {
                this._writeCustomStringSegment2(text, offset, len);
            } else if (this._maximumNonEscapedChar == 0) {
                this._writeStringSegment2(text, offset, len);
            } else {
                this._writeStringSegmentASCII2(text, offset, len);
            }
        }
    }

    private final void _writeStringSegment2(char[] cbuf, int offset, int end) throws JacksonException {
        if (this._outputTail + 6 * (end - offset) > this._outputEnd) {
            this._flushBuffer();
        }
        int outputPtr = this._outputTail;
        byte[] outputBuffer = this._outputBuffer;
        int[] escCodes = this._outputEscapes;
        while (offset < end) {
            boolean combineSurrogates;
            char ch;
            if ((ch = cbuf[offset++]) <= '\u007f') {
                if (escCodes[ch] == 0) {
                    outputBuffer[outputPtr++] = (byte)ch;
                    continue;
                }
                int escape = escCodes[ch];
                if (escape > 0) {
                    outputBuffer[outputPtr++] = 92;
                    outputBuffer[outputPtr++] = (byte)escape;
                    continue;
                }
                outputPtr = this._writeGenericEscape(ch, outputPtr);
                continue;
            }
            if (ch <= '\u07ff') {
                outputBuffer[outputPtr++] = (byte)(0xC0 | ch >> 6);
                outputBuffer[outputPtr++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            if (UTF8JsonGenerator._isStartOfSurrogatePair(ch) && (combineSurrogates = JsonWriteFeature.COMBINE_UNICODE_SURROGATES_IN_UTF8.enabledIn(this._formatWriteFeatures)) && offset < end) {
                char highSurrogate = ch;
                char lowSurrogate = cbuf[offset++];
                outputPtr = this._outputSurrogatePair(highSurrogate, lowSurrogate, outputPtr);
                continue;
            }
            outputPtr = this._outputMultiByteChar(ch, outputPtr);
        }
        this._outputTail = outputPtr;
    }

    private final void _writeStringSegment2(String text, int offset, int end) throws JacksonException {
        if (this._outputTail + 6 * (end - offset) > this._outputEnd) {
            this._flushBuffer();
        }
        int outputPtr = this._outputTail;
        byte[] outputBuffer = this._outputBuffer;
        int[] escCodes = this._outputEscapes;
        while (offset < end) {
            boolean combineSurrogates;
            char ch;
            if ((ch = text.charAt(offset++)) <= '\u007f') {
                if (escCodes[ch] == 0) {
                    outputBuffer[outputPtr++] = (byte)ch;
                    continue;
                }
                int escape = escCodes[ch];
                if (escape > 0) {
                    outputBuffer[outputPtr++] = 92;
                    outputBuffer[outputPtr++] = (byte)escape;
                    continue;
                }
                outputPtr = this._writeGenericEscape(ch, outputPtr);
                continue;
            }
            if (ch <= '\u07ff') {
                outputBuffer[outputPtr++] = (byte)(0xC0 | ch >> 6);
                outputBuffer[outputPtr++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            if (UTF8JsonGenerator._isStartOfSurrogatePair(ch) && (combineSurrogates = JsonWriteFeature.COMBINE_UNICODE_SURROGATES_IN_UTF8.enabledIn(this._formatWriteFeatures)) && offset < end) {
                char highSurrogate = ch;
                char lowSurrogate = text.charAt(offset++);
                outputPtr = this._outputSurrogatePair(highSurrogate, lowSurrogate, outputPtr);
                continue;
            }
            outputPtr = this._outputMultiByteChar(ch, outputPtr);
        }
        this._outputTail = outputPtr;
    }

    private final void _writeStringSegmentASCII2(char[] cbuf, int offset, int end) throws JacksonException {
        if (this._outputTail + 6 * (end - offset) > this._outputEnd) {
            this._flushBuffer();
        }
        int outputPtr = this._outputTail;
        byte[] outputBuffer = this._outputBuffer;
        int[] escCodes = this._outputEscapes;
        int maxUnescaped = this._maximumNonEscapedChar;
        while (offset < end) {
            char ch;
            if ((ch = cbuf[offset++]) <= '\u007f') {
                if (escCodes[ch] == 0) {
                    outputBuffer[outputPtr++] = (byte)ch;
                    continue;
                }
                int escape = escCodes[ch];
                if (escape > 0) {
                    outputBuffer[outputPtr++] = 92;
                    outputBuffer[outputPtr++] = (byte)escape;
                    continue;
                }
                outputPtr = this._writeGenericEscape(ch, outputPtr);
                continue;
            }
            if (ch > maxUnescaped) {
                outputPtr = this._writeGenericEscape(ch, outputPtr);
                continue;
            }
            if (ch <= '\u07ff') {
                outputBuffer[outputPtr++] = (byte)(0xC0 | ch >> 6);
                outputBuffer[outputPtr++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            outputPtr = this._outputMultiByteChar(ch, outputPtr);
        }
        this._outputTail = outputPtr;
    }

    private final void _writeStringSegmentASCII2(String text, int offset, int end) throws JacksonException {
        if (this._outputTail + 6 * (end - offset) > this._outputEnd) {
            this._flushBuffer();
        }
        int outputPtr = this._outputTail;
        byte[] outputBuffer = this._outputBuffer;
        int[] escCodes = this._outputEscapes;
        int maxUnescaped = this._maximumNonEscapedChar;
        while (offset < end) {
            char ch;
            if ((ch = text.charAt(offset++)) <= '\u007f') {
                if (escCodes[ch] == 0) {
                    outputBuffer[outputPtr++] = (byte)ch;
                    continue;
                }
                int escape = escCodes[ch];
                if (escape > 0) {
                    outputBuffer[outputPtr++] = 92;
                    outputBuffer[outputPtr++] = (byte)escape;
                    continue;
                }
                outputPtr = this._writeGenericEscape(ch, outputPtr);
                continue;
            }
            if (ch > maxUnescaped) {
                outputPtr = this._writeGenericEscape(ch, outputPtr);
                continue;
            }
            if (ch <= '\u07ff') {
                outputBuffer[outputPtr++] = (byte)(0xC0 | ch >> 6);
                outputBuffer[outputPtr++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            outputPtr = this._outputMultiByteChar(ch, outputPtr);
        }
        this._outputTail = outputPtr;
    }

    private final void _writeCustomStringSegment2(char[] cbuf, int offset, int end) throws JacksonException {
        if (this._outputTail + 6 * (end - offset) > this._outputEnd) {
            this._flushBuffer();
        }
        int outputPtr = this._outputTail;
        byte[] outputBuffer = this._outputBuffer;
        int[] escCodes = this._outputEscapes;
        int maxUnescaped = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        CharacterEscapes customEscapes = this._characterEscapes;
        while (offset < end) {
            boolean combineSurrogates;
            int ch;
            if ((ch = cbuf[offset++]) <= 127) {
                if (escCodes[ch] == 0) {
                    outputBuffer[outputPtr++] = (byte)ch;
                    continue;
                }
                int escape = escCodes[ch];
                if (escape > 0) {
                    outputBuffer[outputPtr++] = 92;
                    outputBuffer[outputPtr++] = (byte)escape;
                    continue;
                }
                if (escape == -2) {
                    SerializableString esc = customEscapes.getEscapeSequence(ch);
                    if (esc == null) {
                        this._reportError("Invalid custom escape definitions; custom escape not found for character code 0x" + Integer.toHexString(ch) + ", although was supposed to have one");
                    }
                    outputPtr = this._writeCustomEscape(outputBuffer, outputPtr, esc, end - offset);
                    continue;
                }
                outputPtr = this._writeGenericEscape(ch, outputPtr);
                continue;
            }
            if (ch > maxUnescaped) {
                outputPtr = this._writeGenericEscape(ch, outputPtr);
                continue;
            }
            SerializableString esc = customEscapes.getEscapeSequence(ch);
            if (esc != null) {
                outputPtr = this._writeCustomEscape(outputBuffer, outputPtr, esc, end - offset);
                continue;
            }
            if (ch <= 2047) {
                outputBuffer[outputPtr++] = (byte)(0xC0 | ch >> 6);
                outputBuffer[outputPtr++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            if (UTF8JsonGenerator._isStartOfSurrogatePair(ch) && (combineSurrogates = JsonWriteFeature.COMBINE_UNICODE_SURROGATES_IN_UTF8.enabledIn(this._formatWriteFeatures)) && offset < end) {
                char highSurrogate = (char)ch;
                char lowSurrogate = cbuf[offset++];
                outputPtr = this._outputSurrogatePair(highSurrogate, lowSurrogate, outputPtr);
                continue;
            }
            outputPtr = this._outputMultiByteChar(ch, outputPtr);
        }
        this._outputTail = outputPtr;
    }

    private final void _writeCustomStringSegment2(String text, int offset, int end) throws JacksonException {
        if (this._outputTail + 6 * (end - offset) > this._outputEnd) {
            this._flushBuffer();
        }
        int outputPtr = this._outputTail;
        byte[] outputBuffer = this._outputBuffer;
        int[] escCodes = this._outputEscapes;
        int maxUnescaped = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        CharacterEscapes customEscapes = this._characterEscapes;
        while (offset < end) {
            boolean combineSurrogates;
            int ch;
            if ((ch = text.charAt(offset++)) <= 127) {
                if (escCodes[ch] == 0) {
                    outputBuffer[outputPtr++] = (byte)ch;
                    continue;
                }
                int escape = escCodes[ch];
                if (escape > 0) {
                    outputBuffer[outputPtr++] = 92;
                    outputBuffer[outputPtr++] = (byte)escape;
                    continue;
                }
                if (escape == -2) {
                    SerializableString esc = customEscapes.getEscapeSequence(ch);
                    if (esc == null) {
                        this._reportError("Invalid custom escape definitions; custom escape not found for character code 0x" + Integer.toHexString(ch) + ", although was supposed to have one");
                    }
                    outputPtr = this._writeCustomEscape(outputBuffer, outputPtr, esc, end - offset);
                    continue;
                }
                outputPtr = this._writeGenericEscape(ch, outputPtr);
                continue;
            }
            if (ch > maxUnescaped) {
                outputPtr = this._writeGenericEscape(ch, outputPtr);
                continue;
            }
            SerializableString esc = customEscapes.getEscapeSequence(ch);
            if (esc != null) {
                outputPtr = this._writeCustomEscape(outputBuffer, outputPtr, esc, end - offset);
                continue;
            }
            if (ch <= 2047) {
                outputBuffer[outputPtr++] = (byte)(0xC0 | ch >> 6);
                outputBuffer[outputPtr++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            if (UTF8JsonGenerator._isStartOfSurrogatePair(ch) && (combineSurrogates = JsonWriteFeature.COMBINE_UNICODE_SURROGATES_IN_UTF8.enabledIn(this._formatWriteFeatures)) && offset < end) {
                char highSurrogate = (char)ch;
                char lowSurrogate = text.charAt(offset++);
                outputPtr = this._outputSurrogatePair(highSurrogate, lowSurrogate, outputPtr);
                continue;
            }
            outputPtr = this._outputMultiByteChar(ch, outputPtr);
        }
        this._outputTail = outputPtr;
    }

    private final int _writeCustomEscape(byte[] outputBuffer, int outputPtr, SerializableString esc, int remainingChars) throws JacksonException {
        byte[] raw = esc.asUnquotedUTF8();
        int len = raw.length;
        if (len > 6) {
            return this._handleLongCustomEscape(outputBuffer, outputPtr, this._outputEnd, raw, remainingChars);
        }
        System.arraycopy(raw, 0, outputBuffer, outputPtr, len);
        return outputPtr + len;
    }

    private final int _handleLongCustomEscape(byte[] outputBuffer, int outputPtr, int outputEnd, byte[] raw, int remainingChars) throws JacksonException {
        int len = raw.length;
        if (outputPtr + len > outputEnd) {
            this._outputTail = outputPtr;
            this._flushBuffer();
            outputPtr = this._outputTail;
            if (len > outputBuffer.length) {
                try {
                    this._outputStream.write(raw, 0, len);
                }
                catch (IOException e) {
                    throw this._wrapIOFailure(e);
                }
                return outputPtr;
            }
        }
        System.arraycopy(raw, 0, outputBuffer, outputPtr, len);
        if ((outputPtr += len) + 6 * remainingChars > outputEnd) {
            this._outputTail = outputPtr;
            this._flushBuffer();
            return this._outputTail;
        }
        return outputPtr;
    }

    private final void _writeUTF8Segments(byte[] utf8, int offset, int totalLen) throws JacksonException {
        int len;
        do {
            len = Math.min(this._outputMaxContiguous, totalLen);
            this._writeUTF8Segment(utf8, offset, len);
            offset += len;
        } while ((totalLen -= len) > 0);
    }

    private final void _writeUTF8Segment(byte[] utf8, int offset, int len) throws JacksonException {
        int[] escCodes = this._outputEscapes;
        int ptr = offset;
        int end = offset + len;
        while (ptr < end) {
            byte ch;
            if ((ch = utf8[ptr++]) < 0 || escCodes[ch] == 0) continue;
            this._writeUTF8Segment2(utf8, offset, len);
            return;
        }
        if (this._outputTail + len > this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(utf8, offset, this._outputBuffer, this._outputTail, len);
        this._outputTail += len;
    }

    private final void _writeUTF8Segment2(byte[] utf8, int offset, int len) throws JacksonException {
        int outputPtr = this._outputTail;
        if (outputPtr + len * 6 > this._outputEnd) {
            this._flushBuffer();
            outputPtr = this._outputTail;
        }
        byte[] outputBuffer = this._outputBuffer;
        int[] escCodes = this._outputEscapes;
        len += offset;
        while (offset < len) {
            byte b;
            byte ch;
            if ((ch = (b = utf8[offset++])) < 0 || escCodes[ch] == 0) {
                outputBuffer[outputPtr++] = b;
                continue;
            }
            int escape = escCodes[ch];
            if (escape > 0) {
                outputBuffer[outputPtr++] = 92;
                outputBuffer[outputPtr++] = (byte)escape;
                continue;
            }
            outputPtr = this._writeGenericEscape(ch, outputPtr);
        }
        this._outputTail = outputPtr;
    }

    protected final void _writeBinary(Base64Variant b64variant, byte[] input, int inputPtr, int inputEnd) throws JacksonException {
        int safeInputEnd = inputEnd - 3;
        int safeOutputEnd = this._outputEnd - 6;
        int chunksBeforeLF = b64variant.getMaxLineLength() >> 2;
        while (inputPtr <= safeInputEnd) {
            if (this._outputTail > safeOutputEnd) {
                this._flushBuffer();
            }
            int b24 = input[inputPtr++] << 8;
            b24 |= input[inputPtr++] & 0xFF;
            b24 = b24 << 8 | input[inputPtr++] & 0xFF;
            this._outputTail = b64variant.encodeBase64Chunk(b24, this._outputBuffer, this._outputTail);
            if (--chunksBeforeLF > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            chunksBeforeLF = b64variant.getMaxLineLength() >> 2;
        }
        int inputLeft = inputEnd - inputPtr;
        if (inputLeft > 0) {
            if (this._outputTail > safeOutputEnd) {
                this._flushBuffer();
            }
            int b24 = input[inputPtr++] << 16;
            if (inputLeft == 2) {
                b24 |= (input[inputPtr++] & 0xFF) << 8;
            }
            this._outputTail = b64variant.encodeBase64Partial(b24, inputLeft, this._outputBuffer, this._outputTail);
        }
    }

    protected final int _writeBinary(Base64Variant b64variant, InputStream data, byte[] readBuffer, int bytesLeft) throws JacksonException {
        int b24;
        int inputPtr = 0;
        int inputEnd = 0;
        int lastFullOffset = -3;
        int safeOutputEnd = this._outputEnd - 6;
        int chunksBeforeLF = b64variant.getMaxLineLength() >> 2;
        while (bytesLeft > 2) {
            if (inputPtr > lastFullOffset) {
                inputEnd = this._readMore(data, readBuffer, inputPtr, inputEnd, bytesLeft);
                inputPtr = 0;
                if (inputEnd < 3) break;
                lastFullOffset = inputEnd - 3;
            }
            if (this._outputTail > safeOutputEnd) {
                this._flushBuffer();
            }
            b24 = readBuffer[inputPtr++] << 8;
            b24 |= readBuffer[inputPtr++] & 0xFF;
            b24 = b24 << 8 | readBuffer[inputPtr++] & 0xFF;
            bytesLeft -= 3;
            this._outputTail = b64variant.encodeBase64Chunk(b24, this._outputBuffer, this._outputTail);
            if (--chunksBeforeLF > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            chunksBeforeLF = b64variant.getMaxLineLength() >> 2;
        }
        if (bytesLeft > 0) {
            inputEnd = this._readMore(data, readBuffer, inputPtr, inputEnd, bytesLeft);
            inputPtr = 0;
            if (inputEnd > 0) {
                int amount;
                if (this._outputTail > safeOutputEnd) {
                    this._flushBuffer();
                }
                b24 = readBuffer[inputPtr++] << 16;
                if (inputPtr < inputEnd) {
                    b24 |= (readBuffer[inputPtr] & 0xFF) << 8;
                    amount = 2;
                } else {
                    amount = 1;
                }
                this._outputTail = b64variant.encodeBase64Partial(b24, amount, this._outputBuffer, this._outputTail);
                bytesLeft -= amount;
            }
        }
        return bytesLeft;
    }

    protected final int _writeBinary(Base64Variant b64variant, InputStream data, byte[] readBuffer) throws JacksonException {
        int b24;
        int inputPtr = 0;
        int inputEnd = 0;
        int lastFullOffset = -3;
        int bytesDone = 0;
        int safeOutputEnd = this._outputEnd - 6;
        int chunksBeforeLF = b64variant.getMaxLineLength() >> 2;
        while (true) {
            if (inputPtr > lastFullOffset) {
                inputEnd = this._readMore(data, readBuffer, inputPtr, inputEnd, readBuffer.length);
                inputPtr = 0;
                if (inputEnd < 3) break;
                lastFullOffset = inputEnd - 3;
            }
            if (this._outputTail > safeOutputEnd) {
                this._flushBuffer();
            }
            b24 = readBuffer[inputPtr++] << 8;
            b24 |= readBuffer[inputPtr++] & 0xFF;
            b24 = b24 << 8 | readBuffer[inputPtr++] & 0xFF;
            bytesDone += 3;
            this._outputTail = b64variant.encodeBase64Chunk(b24, this._outputBuffer, this._outputTail);
            if (--chunksBeforeLF > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            chunksBeforeLF = b64variant.getMaxLineLength() >> 2;
        }
        if (inputPtr < inputEnd) {
            if (this._outputTail > safeOutputEnd) {
                this._flushBuffer();
            }
            b24 = readBuffer[inputPtr++] << 16;
            int amount = 1;
            if (inputPtr < inputEnd) {
                b24 |= (readBuffer[inputPtr] & 0xFF) << 8;
                amount = 2;
            }
            bytesDone += amount;
            this._outputTail = b64variant.encodeBase64Partial(b24, amount, this._outputBuffer, this._outputTail);
        }
        return bytesDone;
    }

    private final int _readMore(InputStream in, byte[] readBuffer, int inputPtr, int inputEnd, int maxRead) throws JacksonException {
        int length;
        int i = 0;
        while (inputPtr < inputEnd) {
            readBuffer[i++] = readBuffer[inputPtr++];
        }
        inputPtr = 0;
        inputEnd = i;
        maxRead = Math.min(maxRead, readBuffer.length);
        while ((length = maxRead - inputEnd) != 0) {
            int count;
            try {
                count = in.read(readBuffer, inputEnd, length);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            if (count < 0) {
                return inputEnd;
            }
            if ((inputEnd += count) < 3) continue;
        }
        return inputEnd;
    }

    private final int _outputRawMultiByteChar(int ch, char[] cbuf, int inputOffset, int inputEnd) throws JacksonException {
        if (ch >= 55296 && ch <= 57343) {
            if (inputOffset >= inputEnd || cbuf == null) {
                this._reportError(String.format("Split surrogate on writeRaw() input (last character): first character 0x%4x", ch));
            } else {
                this._outputSurrogates(ch, cbuf[inputOffset]);
            }
            return inputOffset + 1;
        }
        byte[] bbuf = this._outputBuffer;
        bbuf[this._outputTail++] = (byte)(0xE0 | ch >> 12);
        bbuf[this._outputTail++] = (byte)(0x80 | ch >> 6 & 0x3F);
        bbuf[this._outputTail++] = (byte)(0x80 | ch & 0x3F);
        return inputOffset;
    }

    protected final void _outputSurrogates(int surr1, int surr2) throws JacksonException {
        int c = this._decodeSurrogate(surr1, surr2);
        if (this._outputTail + 4 > this._outputEnd) {
            this._flushBuffer();
        }
        byte[] bbuf = this._outputBuffer;
        bbuf[this._outputTail++] = (byte)(0xF0 | c >> 18);
        bbuf[this._outputTail++] = (byte)(0x80 | c >> 12 & 0x3F);
        bbuf[this._outputTail++] = (byte)(0x80 | c >> 6 & 0x3F);
        bbuf[this._outputTail++] = (byte)(0x80 | c & 0x3F);
    }

    private int _outputSurrogatePair(char highSurrogate, char lowSurrogate, int outputPtr) {
        int unicode = 65536 + ((highSurrogate & 0x3FF) << 10) + (lowSurrogate & 0x3FF);
        this._outputBuffer[outputPtr++] = (byte)(240 + (unicode >> 18 & 7));
        this._outputBuffer[outputPtr++] = (byte)(128 + (unicode >> 12 & 0x3F));
        this._outputBuffer[outputPtr++] = (byte)(128 + (unicode >> 6 & 0x3F));
        this._outputBuffer[outputPtr++] = (byte)(128 + (unicode & 0x3F));
        return outputPtr;
    }

    private final int _outputMultiByteChar(int ch, int outputPtr) throws JacksonException {
        byte[] HEX_CHARS = this.getHexBytes();
        byte[] bbuf = this._outputBuffer;
        if (ch >= 55296 && ch <= 57343) {
            bbuf[outputPtr++] = 92;
            bbuf[outputPtr++] = 117;
            bbuf[outputPtr++] = HEX_CHARS[ch >> 12 & 0xF];
            bbuf[outputPtr++] = HEX_CHARS[ch >> 8 & 0xF];
            bbuf[outputPtr++] = HEX_CHARS[ch >> 4 & 0xF];
            bbuf[outputPtr++] = HEX_CHARS[ch & 0xF];
        } else {
            bbuf[outputPtr++] = (byte)(0xE0 | ch >> 12);
            bbuf[outputPtr++] = (byte)(0x80 | ch >> 6 & 0x3F);
            bbuf[outputPtr++] = (byte)(0x80 | ch & 0x3F);
        }
        return outputPtr;
    }

    private final void _writeNull() throws JacksonException {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(NULL_BYTES, 0, this._outputBuffer, this._outputTail, 4);
        this._outputTail += 4;
    }

    private int _writeGenericEscape(int charToEscape, int outputPtr) throws JacksonException {
        byte[] bbuf = this._outputBuffer;
        byte[] HEX_CHARS = this.getHexBytes();
        bbuf[outputPtr++] = 92;
        bbuf[outputPtr++] = 117;
        if (charToEscape > 255) {
            int hi = charToEscape >> 8 & 0xFF;
            bbuf[outputPtr++] = HEX_CHARS[hi >> 4];
            bbuf[outputPtr++] = HEX_CHARS[hi & 0xF];
            charToEscape &= 0xFF;
        } else {
            bbuf[outputPtr++] = 48;
            bbuf[outputPtr++] = 48;
        }
        bbuf[outputPtr++] = HEX_CHARS[charToEscape >> 4];
        bbuf[outputPtr++] = HEX_CHARS[charToEscape & 0xF];
        return outputPtr;
    }

    protected final void _flushBuffer() throws JacksonException {
        int len = this._outputTail;
        if (len > 0) {
            this._outputTail = 0;
            try {
                this._outputStream.write(this._outputBuffer, 0, len);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
    }

    private byte[] getHexBytes() {
        return this._cfgWriteHexUppercase ? HEX_BYTES_UPPER : HEX_BYTES_LOWER;
    }

    private static boolean _isStartOfSurrogatePair(int ch) {
        return (ch & 0xFC00) == 55296;
    }
}

