/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.json;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.Version;
import tools.jackson.core.base.GeneratorBase;
import tools.jackson.core.io.CharTypes;
import tools.jackson.core.io.CharacterEscapes;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.json.DupDetector;
import tools.jackson.core.json.JsonWriteContext;
import tools.jackson.core.json.JsonWriteFeature;
import tools.jackson.core.json.PackageVersion;
import tools.jackson.core.util.JacksonFeatureSet;

public abstract class JsonGeneratorBase
extends GeneratorBase {
    protected static final int[] DEFAULT_OUTPUT_ESCAPES = CharTypes.get7BitOutputEscapes();
    protected final int _formatWriteFeatures;
    protected int[] _outputEscapes = DEFAULT_OUTPUT_ESCAPES;
    protected CharacterEscapes _characterEscapes;
    protected final int _maximumNonEscapedChar;
    protected final PrettyPrinter _cfgPrettyPrinter;
    protected final SerializableString _rootValueSeparator;
    protected final boolean _cfgUnqNames;
    protected final boolean _cfgNumbersAsStrings;
    protected boolean _cfgWriteHexUppercase;
    protected JsonWriteContext _streamWriteContext;

    protected JsonGeneratorBase(ObjectWriteContext writeCtxt, IOContext ioCtxt, int streamWriteFeatures, int formatWriteFeatures, SerializableString rootValueSeparator, PrettyPrinter pp, CharacterEscapes charEsc, int maxNonEscaped) {
        super(writeCtxt, ioCtxt, streamWriteFeatures);
        this._formatWriteFeatures = formatWriteFeatures;
        if (JsonWriteFeature.ESCAPE_NON_ASCII.enabledIn(formatWriteFeatures)) {
            maxNonEscaped = 127;
        }
        this._maximumNonEscapedChar = maxNonEscaped;
        this._cfgUnqNames = !JsonWriteFeature.QUOTE_PROPERTY_NAMES.enabledIn(formatWriteFeatures);
        this._cfgNumbersAsStrings = JsonWriteFeature.WRITE_NUMBERS_AS_STRINGS.enabledIn(formatWriteFeatures);
        this._cfgWriteHexUppercase = JsonWriteFeature.WRITE_HEX_UPPER_CASE.enabledIn(formatWriteFeatures);
        this._rootValueSeparator = rootValueSeparator;
        this._cfgPrettyPrinter = pp;
        DupDetector dups = StreamWriteFeature.STRICT_DUPLICATE_DETECTION.enabledIn(streamWriteFeatures) ? DupDetector.rootDetector(this) : null;
        this._streamWriteContext = JsonWriteContext.createRootContext(dups);
        this.setCharacterEscapes(charEsc);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean isEnabled(JsonWriteFeature f) {
        return f.enabledIn(this._formatWriteFeatures);
    }

    @Override
    public JacksonFeatureSet<StreamWriteCapability> streamWriteCapabilities() {
        return DEFAULT_WRITE_CAPABILITIES;
    }

    @Override
    public int getHighestNonEscapedChar() {
        return this._maximumNonEscapedChar;
    }

    @Override
    public abstract JsonGenerator setCharacterEscapes(CharacterEscapes var1);

    @Override
    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    @Override
    public final TokenStreamContext streamWriteContext() {
        return this._streamWriteContext;
    }

    @Override
    public final Object currentValue() {
        return this._streamWriteContext.currentValue();
    }

    @Override
    public final void assignCurrentValue(Object v) {
        this._streamWriteContext.assignCurrentValue(v);
    }

    @Override
    public JsonGenerator writeStartArray(Object currentValue, int size) throws JacksonException {
        this.writeStartArray(currentValue);
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(Object currentValue, int size) throws JacksonException {
        this.writeStartObject(currentValue);
        return this;
    }

    @Override
    public JsonGenerator writePropertyId(long id) throws JacksonException {
        this.writeName(Long.toString(id));
        return this;
    }

    protected void _verifyPrettyValueWrite(String typeMsg, int status) throws JacksonException {
        switch (status) {
            case 1: {
                this._cfgPrettyPrinter.writeArrayValueSeparator(this);
                break;
            }
            case 2: {
                this._cfgPrettyPrinter.writeObjectNameValueSeparator(this);
                break;
            }
            case 3: {
                this._cfgPrettyPrinter.writeRootValueSeparator(this);
                break;
            }
            case 0: {
                if (this._streamWriteContext.inArray()) {
                    this._cfgPrettyPrinter.beforeArrayValues(this);
                    break;
                }
                if (!this._streamWriteContext.inObject()) break;
                this._cfgPrettyPrinter.beforeObjectEntries(this);
                break;
            }
            case 5: {
                this._reportCantWriteValueExpectName(typeMsg);
                break;
            }
            default: {
                this._throwInternal();
            }
        }
    }

    protected void _reportCantWriteValueExpectName(String typeMsg) throws JacksonException {
        throw this._constructWriteException("Cannot %s, expecting a property name (context: %s)", typeMsg, this._streamWriteContext.typeDesc());
    }
}

