/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TreeNode;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.util.DefaultPrettyPrinter;
import tools.jackson.core.util.JacksonFeature;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.core.util.VersionUtil;

public abstract class GeneratorBase
extends JsonGenerator {
    public static final int SURR1_FIRST = 55296;
    public static final int SURR1_LAST = 56319;
    public static final int SURR2_FIRST = 56320;
    public static final int SURR2_LAST = 57343;
    protected static final String WRITE_BINARY = "write a binary value";
    protected static final String WRITE_BOOLEAN = "write a boolean value";
    protected static final String WRITE_NULL = "write a null";
    protected static final String WRITE_NUMBER = "write a number";
    protected static final String WRITE_RAW = "write a raw (unencoded) value";
    protected static final String WRITE_STRING = "write a string";
    protected static final int MAX_BIG_DECIMAL_SCALE = 9999;
    protected static final JacksonFeatureSet<StreamWriteCapability> DEFAULT_WRITE_CAPABILITIES = JacksonFeatureSet.fromDefaults((JacksonFeature[])StreamWriteCapability.values());
    protected static final JacksonFeatureSet<StreamWriteCapability> DEFAULT_TEXTUAL_WRITE_CAPABILITIES = DEFAULT_WRITE_CAPABILITIES.with(StreamWriteCapability.CAN_WRITE_FORMATTED_NUMBERS);
    protected static final JacksonFeatureSet<StreamWriteCapability> DEFAULT_BINARY_WRITE_CAPABILITIES = DEFAULT_WRITE_CAPABILITIES.with(StreamWriteCapability.CAN_WRITE_BINARY_NATIVELY);
    protected final ObjectWriteContext _objectWriteContext;
    protected final IOContext _ioContext;
    protected final StreamWriteConstraints _streamWriteConstraints;
    protected int _streamWriteFeatures;
    protected boolean _closed;

    protected GeneratorBase(ObjectWriteContext writeCtxt, IOContext ioCtxt, int streamWriteFeatures) {
        this._objectWriteContext = writeCtxt;
        this._ioContext = ioCtxt;
        this._streamWriteConstraints = ioCtxt.streamWriteConstraints();
        this._streamWriteFeatures = streamWriteFeatures;
    }

    @Override
    public final boolean isEnabled(StreamWriteFeature f) {
        return (this._streamWriteFeatures & f.getMask()) != 0;
    }

    @Override
    public final int streamWriteFeatures() {
        return this._streamWriteFeatures;
    }

    @Override
    public final JsonGenerator configure(StreamWriteFeature f, boolean state) {
        this._streamWriteFeatures = state ? (this._streamWriteFeatures |= f.getMask()) : (this._streamWriteFeatures &= ~f.getMask());
        return this;
    }

    @Override
    public final StreamWriteConstraints streamWriteConstraints() {
        return this._streamWriteConstraints;
    }

    @Override
    public ObjectWriteContext objectWriteContext() {
        return this._objectWriteContext;
    }

    public IOContext ioContext() {
        return this._ioContext;
    }

    @Override
    public JsonGenerator writeStartArray(Object forValue, int size) throws JacksonException {
        return this.writeStartArray(forValue);
    }

    @Override
    public JsonGenerator writeStartObject(Object forValue, int size) throws JacksonException {
        return this.writeStartObject(forValue);
    }

    @Override
    public JsonGenerator writeName(SerializableString name) throws JacksonException {
        return this.writeName(name.getValue());
    }

    @Override
    public JsonGenerator writeString(Reader reader, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    @Override
    public JsonGenerator writeString(SerializableString text) throws JacksonException {
        return this.writeString(text.getValue());
    }

    @Override
    public JsonGenerator writeRawValue(String text) throws JacksonException {
        this._verifyValueWrite("write raw value");
        return this.writeRaw(text);
    }

    @Override
    public JsonGenerator writeRawValue(String text, int offset, int len) throws JacksonException {
        this._verifyValueWrite("write raw value");
        return this.writeRaw(text, offset, len);
    }

    @Override
    public JsonGenerator writeRawValue(char[] text, int offset, int len) throws JacksonException {
        this._verifyValueWrite("write raw value");
        return this.writeRaw(text, offset, len);
    }

    @Override
    public JsonGenerator writeRawValue(SerializableString text) throws JacksonException {
        this._verifyValueWrite("write raw value");
        return this.writeRaw(text);
    }

    @Override
    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) throws JacksonException {
        this._reportUnsupportedOperation();
        return 0;
    }

    @Override
    public JsonGenerator writePOJO(Object value) throws JacksonException {
        if (value == null) {
            this.writeNull();
        } else {
            this._objectWriteContext.writeValue(this, value);
        }
        return this;
    }

    @Override
    public JsonGenerator writeTree(TreeNode rootNode) throws JacksonException {
        if (rootNode == null) {
            this.writeNull();
        } else {
            this._objectWriteContext.writeTree(this, rootNode);
        }
        return this;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public void close() {
        if (!this._closed) {
            try {
                this._closeInput();
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            finally {
                this._releaseBuffers();
                this._ioContext.close();
                this._closed = true;
            }
        }
    }

    protected abstract void _closeInput() throws IOException;

    protected abstract void _releaseBuffers();

    protected abstract void _verifyValueWrite(String var1) throws JacksonException;

    protected PrettyPrinter _constructDefaultPrettyPrinter() {
        return new DefaultPrettyPrinter();
    }

    protected String _asString(BigDecimal value) throws JacksonException {
        if (StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN.enabledIn(this._streamWriteFeatures)) {
            int scale = value.scale();
            if (scale < -9999 || scale > 9999) {
                this._reportError(String.format("Attempt to write plain `java.math.BigDecimal` (see JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) with illegal scale (%d): needs to be between [-%d, %d]", scale, 9999, 9999));
            }
            return value.toPlainString();
        }
        return value.toString();
    }

    protected final int _decodeSurrogate(int surr1, int surr2) throws JacksonException {
        if (surr2 < 56320 || surr2 > 57343) {
            String msg = String.format("Incomplete surrogate pair: first char 0x%04X, second 0x%04X", surr1, surr2);
            this._reportError(msg);
        }
        return (surr1 << 10) + surr2 + -56613888;
    }

    protected void _checkRangeBoundsForByteArray(byte[] data, int offset, int len) throws JacksonException {
        int dataLen;
        int end;
        int anyNegs;
        if (data == null) {
            this._reportArgumentError("Invalid `byte[]` argument: `null`");
        }
        if ((anyNegs = offset | len | (end = offset + len) | (dataLen = data.length) - end) < 0) {
            this._reportArgumentError(String.format("Invalid 'offset' (%d) and/or 'len' (%d) arguments for `byte[]` of length %d", offset, len, dataLen));
        }
    }

    protected void _checkRangeBoundsForCharArray(char[] data, int offset, int len) throws JacksonException {
        int dataLen;
        int end;
        int anyNegs;
        if (data == null) {
            this._reportArgumentError("Invalid `char[]` argument: `null`");
        }
        if ((anyNegs = offset | len | (end = offset + len) | (dataLen = data.length) - end) < 0) {
            this._reportArgumentError(String.format("Invalid 'offset' (%d) and/or 'len' (%d) arguments for `char[]` of length %d", offset, len, dataLen));
        }
    }

    protected void _checkRangeBoundsForString(String data, int offset, int len) throws JacksonException {
        int dataLen;
        int end;
        int anyNegs;
        if (data == null) {
            this._reportArgumentError("Invalid `String` argument: `null`");
        }
        if ((anyNegs = offset | len | (end = offset + len) | (dataLen = data.length()) - end) < 0) {
            this._reportArgumentError(String.format("Invalid 'offset' (%d) and/or 'len' (%d) arguments for `String` of length %d", offset, len, dataLen));
        }
    }

    protected void _throwInternal() {
        VersionUtil.throwInternal();
    }
}

