/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.HostInfo;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ConnectionImpl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.JdbcConnection;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.BasicConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionPlugin;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.ICurrentConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.NullArgumentMessage;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.util.ConnectionUtils;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.util.RdsUtils;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util.StringUtils;

public class ReaderClusterConnectionPlugin
implements IConnectionPlugin {
    private static final String GET_INSTANCE_QUERY = "SELECT @@aurora_server_id";
    protected IConnectionProvider connectionProvider;
    private final ICurrentConnectionProvider currentConnectionProvider;
    private final IConnectionPlugin nextPlugin;

    public ReaderClusterConnectionPlugin(ICurrentConnectionProvider currentConnectionProvider, IConnectionPlugin nextPlugin) {
        this(currentConnectionProvider, nextPlugin, new BasicConnectionProvider());
    }

    public ReaderClusterConnectionPlugin(ICurrentConnectionProvider currentConnectionProvider, IConnectionPlugin nextPlugin, IConnectionProvider connectionProvider) {
        if (connectionProvider == null) {
            throw new IllegalArgumentException(NullArgumentMessage.getMessage("connectionProvider"));
        }
        if (currentConnectionProvider == null) {
            throw new IllegalArgumentException(NullArgumentMessage.getMessage("currentConnectionProvider"));
        }
        this.currentConnectionProvider = currentConnectionProvider;
        this.nextPlugin = nextPlugin;
        this.connectionProvider = connectionProvider;
    }

    @Override
    public Object execute(Class<?> methodInvokeOn, String methodName, Callable<?> executeSqlFunc, Object[] args) throws Exception {
        return this.nextPlugin.execute(methodInvokeOn, methodName, executeSqlFunc, args);
    }

    @Override
    public void openInitialConnection(ConnectionUrl connectionUrl) throws SQLException {
        this.nextPlugin.openInitialConnection(connectionUrl);
        JdbcConnection currentConnection = this.currentConnectionProvider.getCurrentConnection();
        if (currentConnection != null) {
            String connectedHostName;
            HostInfo mainHostInfo = connectionUrl.getMainHost();
            RdsUtils rdsUtils = new RdsUtils();
            if (RdsUtils.isReaderClusterDns(mainHostInfo.getHost()) && !StringUtils.isNullOrEmpty(connectedHostName = this.getCurrentlyConnectedInstance(currentConnection))) {
                String pattern = mainHostInfo.getHostProperties().get(PropertyKey.clusterInstanceHostPattern.getKeyName());
                String instanceEndpoint = !StringUtils.isNullOrEmpty(pattern) ? pattern : RdsUtils.getRdsInstanceHostPattern(mainHostInfo.getHost());
                HostInfo instanceHostInfo = ConnectionUtils.createInstanceHostWithProperties(instanceEndpoint.replace("?", connectedHostName), mainHostInfo);
                ConnectionImpl hostConnection = this.connectionProvider.connect(instanceHostInfo);
                this.currentConnectionProvider.setCurrentConnection(hostConnection, instanceHostInfo);
            }
        }
    }

    @Override
    public void releaseResources() {
        this.nextPlugin.releaseResources();
    }

    @Override
    public void transactionBegun() {
        this.nextPlugin.transactionBegun();
    }

    @Override
    public void transactionCompleted() {
        this.nextPlugin.transactionCompleted();
    }

    private String getCurrentlyConnectedInstance(JdbcConnection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery(GET_INSTANCE_QUERY);
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }
}

