/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.postgresql.Driver;
import org.postgresql.ds.PGConnectionPoolDataSource;
import org.postgresql.ds.PGSimpleDataSource;
import org.postgresql.ds.common.BaseDataSource;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;

public class PgDriverHelper {
    private static final Logger LOGGER = Logger.getLogger(PgDriverHelper.class.getName());
    private static final String DS_CLASS_NAME = PGSimpleDataSource.class.getName();
    private static final String DS_POOLED_CLASS_NAME = PGConnectionPoolDataSource.class.getName();

    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        Integer socketTimeout;
        Integer connectTimeout;
        Integer loginTimeout;
        Boolean tcpKeepAlive;
        if (!(dataSource instanceof BaseDataSource)) {
            throw new SQLException(Messages.get("TargetDriverDialectManager.unexpectedClass", new Object[]{DS_CLASS_NAME + ", " + DS_POOLED_CLASS_NAME, dataSource.getClass().getName()}));
        }
        BaseDataSource baseDataSource = (BaseDataSource)dataSource;
        baseDataSource.setDatabaseName(PropertyDefinition.DATABASE.getString(props));
        baseDataSource.setUser(PropertyDefinition.USER.getString(props));
        baseDataSource.setPassword(PropertyDefinition.PASSWORD.getString(props));
        baseDataSource.setServerNames(new String[]{hostSpec.getHost()});
        if (hostSpec.isPortSpecified()) {
            baseDataSource.setPortNumbers(new int[]{hostSpec.getPort()});
        }
        if ((tcpKeepAlive = PropertyUtils.getBooleanPropertyValue(props, PropertyDefinition.TCP_KEEP_ALIVE)) != null) {
            baseDataSource.setTcpKeepAlive(tcpKeepAlive.booleanValue());
        }
        if ((loginTimeout = PropertyUtils.getIntegerPropertyValue(props, PropertyDefinition.LOGIN_TIMEOUT)) != null) {
            baseDataSource.setLoginTimeout((int)TimeUnit.MILLISECONDS.toSeconds(loginTimeout.intValue()));
        }
        if ((connectTimeout = PropertyUtils.getIntegerPropertyValue(props, PropertyDefinition.CONNECT_TIMEOUT)) != null) {
            baseDataSource.setConnectTimeout((int)TimeUnit.MILLISECONDS.toSeconds(connectTimeout.intValue()));
        }
        if ((socketTimeout = PropertyUtils.getIntegerPropertyValue(props, PropertyDefinition.SOCKET_TIMEOUT)) != null) {
            baseDataSource.setSocketTimeout((int)TimeUnit.MILLISECONDS.toSeconds(socketTimeout.intValue()));
        }
        PropertyDefinition.removeAll(props);
        PropertyUtils.applyProperties(dataSource, props);
    }

    public boolean isDriverRegistered() throws SQLException {
        return Driver.isRegistered();
    }

    public void registerDriver() throws SQLException {
        Driver.register();
    }
}

