/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.model.LayerVersionsListItem;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse;

public class ListLayerVersionsIterable
implements SdkIterable<ListLayerVersionsResponse> {
    private final LambdaClient client;
    private final ListLayerVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLayerVersionsIterable(LambdaClient client, ListLayerVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLayerVersionsResponseFetcher();
    }

    public Iterator<ListLayerVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LayerVersionsListItem> layerVersions() {
        Function<ListLayerVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.layerVersions() != null) {
                return response.layerVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLayerVersionsResponseFetcher
    implements SyncPageFetcher<ListLayerVersionsResponse> {
        private ListLayerVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListLayerVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListLayerVersionsResponse nextPage(ListLayerVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListLayerVersionsIterable.this.client.listLayerVersions(ListLayerVersionsIterable.this.firstRequest);
            }
            return ListLayerVersionsIterable.this.client.listLayerVersions((ListLayerVersionsRequest)((Object)ListLayerVersionsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

