/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.xml;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.util.Maps;
import org.zwobble.mammoth.internal.xml.NullXmlElement;
import org.zwobble.mammoth.internal.xml.XmlElementLike;
import org.zwobble.mammoth.internal.xml.XmlElementList;
import org.zwobble.mammoth.internal.xml.XmlNode;
import org.zwobble.mammoth.internal.xml.XmlNodeVisitor;

public class XmlElement
implements XmlNode,
XmlElementLike {
    private final String name;
    private final Map<String, String> attributes;
    private final List<XmlNode> children;

    public XmlElement(String name, Map<String, String> attributes, List<XmlNode> children) {
        this.name = name;
        this.attributes = attributes;
        this.children = children;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String name) {
        return this.getAttributeOrNone(name).orElseThrow(() -> new RuntimeException("Element has no '" + name + "' attribute"));
    }

    @Override
    public Optional<String> getAttributeOrNone(String name) {
        return Maps.lookup(this.attributes, name);
    }

    @Override
    public String innerText() {
        return String.join((CharSequence)"", Iterables.lazyMap(this.children, XmlNode::innerText));
    }

    @Override
    public <T> T accept(XmlNodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public List<XmlNode> getChildren() {
        return this.children;
    }

    public String toString() {
        return "XmlElement(name=" + this.name + ", attributes=" + this.attributes + ", children=" + this.children + ")";
    }

    public XmlElementList findChildren(String name) {
        return new XmlElementList(Lists.toList(this.findChildrenIterable(name)));
    }

    @Override
    public Optional<XmlElement> findChild(String name) {
        return Iterables.getFirst(this.findChildrenIterable(name));
    }

    @Override
    public boolean hasChild(String name) {
        return this.findChildrenIterable(name).iterator().hasNext();
    }

    @Override
    public XmlElementLike findChildOrEmpty(String name) {
        return Iterables.getFirst(this.findChildrenIterable(name), NullXmlElement.INSTANCE);
    }

    private Iterable<XmlElement> findChildrenIterable(String name) {
        return Iterables.lazyFilter(Iterables.lazyFilter(this.children, XmlElement.class), child -> child.getName().equals(name));
    }
}

