/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.zwobble.mammoth.internal.util.Iterables;

public class Lists {
    public static <T> List<T> list() {
        return Collections.emptyList();
    }

    public static <T> List<T> list(T value1) {
        return Collections.singletonList(value1);
    }

    public static <T> List<T> list(T value1, T value2) {
        return Arrays.asList(value1, value2);
    }

    public static <T> List<T> list(T value1, T value2, T value3) {
        return Arrays.asList(value1, value2, value3);
    }

    @SafeVarargs
    public static <T> List<T> list(T ... values) {
        return Arrays.asList(values);
    }

    public static <T> List<T> cons(T head, Iterable<T> tail) {
        return Lists.eagerConcat(Lists.list(head), tail);
    }

    public static <T> List<T> eagerConcat(Iterable<T> first, Iterable<T> second) {
        return Stream.concat(Iterables.stream(first), Iterables.stream(second)).collect(Collectors.toList());
    }

    public static <T> List<T> eagerConcat(Collection<T> first, Collection<T> second, Collection<T> third) {
        ArrayList<T> result = new ArrayList<T>(first.size() + second.size() + third.size());
        result.addAll(first);
        result.addAll(second);
        result.addAll(third);
        return result;
    }

    public static <T> List<T> eagerFilter(Iterable<T> iterable, Predicate<T> predicate) {
        return Iterables.stream(iterable).filter(predicate).collect(Collectors.toList());
    }

    public static <T, R> List<R> eagerMap(Iterable<T> iterable, Function<T, R> function) {
        return Iterables.stream(iterable).map(function).collect(Collectors.toList());
    }

    public static <T, R> List<R> eagerMapWithIndex(Iterable<T> iterable, BiFunction<Integer, T, R> function) {
        return Lists.toList(Iterables.lazyMapWithIndex(iterable, function));
    }

    public static <T, R> List<R> eagerFlatMap(Iterable<T> iterable, Function<T, Iterable<R>> function) {
        return Iterables.stream(iterable).flatMap(element -> Iterables.stream((Iterable)function.apply(element))).collect(Collectors.toList());
    }

    public static <T, R extends Comparable<R>> List<T> orderedBy(Iterable<T> iterable, Function<T, R> getKey) {
        return Iterables.stream(iterable).sorted(Lists.orderBy(getKey)).collect(Collectors.toList());
    }

    private static <T, R extends Comparable<R>> Comparator<T> orderBy(Function<T, R> getKey) {
        return (first, second) -> ((Comparable)getKey.apply(first)).compareTo((Comparable)getKey.apply(second));
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        return Iterables.stream(iterable).collect(Collectors.toList());
    }

    public static <T> Optional<T> tryGetFirst(List<T> list) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(0));
    }

    public static <T> Optional<T> tryGetLast(List<T> list) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(list.size() - 1));
    }

    public static <T> List<T> skip(List<T> list, int count) {
        return list.subList(Math.min(list.size(), count), list.size());
    }

    public static <T> Iterable<T> reversed(final List<T> list) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final ListIterator iterator = list.listIterator(list.size());
                return new Iterator<T>(){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public boolean hasNext() {
                        return iterator.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return iterator.previous();
                    }
                };
            }
        };
    }
}

