/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.styles.parsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.zwobble.mammoth.internal.html.HtmlTag;
import org.zwobble.mammoth.internal.styles.HtmlPath;
import org.zwobble.mammoth.internal.styles.HtmlPathElement;
import org.zwobble.mammoth.internal.styles.HtmlPathElements;
import org.zwobble.mammoth.internal.styles.parsing.TokenIterator;
import org.zwobble.mammoth.internal.styles.parsing.TokenParser;
import org.zwobble.mammoth.internal.styles.parsing.TokenType;
import org.zwobble.mammoth.internal.util.Maps;

public class HtmlPathParser {
    public static HtmlPath parse(TokenIterator<TokenType> tokens) {
        if (tokens.trySkip(TokenType.SYMBOL, "!")) {
            return HtmlPath.IGNORE;
        }
        return HtmlPathParser.parseHtmlPathElements(tokens);
    }

    private static HtmlPath parseHtmlPathElements(TokenIterator<TokenType> tokens) {
        ArrayList<HtmlPathElement> elements = new ArrayList<HtmlPathElement>();
        if (tokens.peekTokenType() == TokenType.IDENTIFIER) {
            HtmlPathElement element = HtmlPathParser.parseElement(tokens);
            elements.add(element);
            while (tokens.peekTokenType() == TokenType.WHITESPACE && tokens.isNext(1, TokenType.SYMBOL, ">")) {
                tokens.skip(TokenType.WHITESPACE);
                tokens.skip(TokenType.SYMBOL, ">");
                tokens.skip(TokenType.WHITESPACE);
                elements.add(HtmlPathParser.parseElement(tokens));
            }
        }
        return new HtmlPathElements(elements);
    }

    private static HtmlPathElement parseElement(TokenIterator<TokenType> tokens) {
        List<String> tagNames = HtmlPathParser.parseTagNames(tokens);
        List<Attribute> attributeList = HtmlPathParser.parseAttributeOrClassNames(tokens);
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Attribute attribute : attributeList) {
            if (attribute.append && attributes.containsKey(attribute.name)) {
                attributes.put(attribute.name, Maps.lookup(attributes, attribute.name).get() + " " + attribute.value);
                continue;
            }
            attributes.put(attribute.name, attribute.value);
        }
        boolean isFresh = HtmlPathParser.parseIsFresh(tokens);
        String separator = HtmlPathParser.parseSeparator(tokens);
        return new HtmlPathElement(new HtmlTag(tagNames, attributes, !isFresh, separator));
    }

    private static List<String> parseTagNames(TokenIterator<TokenType> tokens) {
        ArrayList<String> tagNames = new ArrayList<String>();
        tagNames.add(TokenParser.parseIdentifier(tokens));
        while (tokens.trySkip(TokenType.SYMBOL, "|")) {
            tagNames.add(TokenParser.parseIdentifier(tokens));
        }
        return tagNames;
    }

    private static List<Attribute> parseAttributeOrClassNames(TokenIterator<TokenType> tokens) {
        Optional<Attribute> attribute;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        while ((attribute = HtmlPathParser.parseAttributeOrClassName(tokens)).isPresent()) {
            attributes.add(attribute.get());
        }
        return attributes;
    }

    private static Optional<Attribute> parseAttributeOrClassName(TokenIterator<TokenType> tokens) {
        if (tokens.isNext(TokenType.SYMBOL, "[")) {
            return Optional.of(HtmlPathParser.parseAttribute(tokens));
        }
        if (tokens.isNext(TokenType.SYMBOL, ".")) {
            return Optional.of(HtmlPathParser.parseClassName(tokens));
        }
        return Optional.empty();
    }

    private static Attribute parseAttribute(TokenIterator<TokenType> tokens) {
        tokens.skip(TokenType.SYMBOL, "[");
        String name = TokenParser.parseIdentifier(tokens);
        tokens.skip(TokenType.SYMBOL, "=");
        String value = TokenParser.parseString(tokens);
        tokens.skip(TokenType.SYMBOL, "]");
        return new Attribute(name, value, true);
    }

    private static Attribute parseClassName(TokenIterator<TokenType> tokens) {
        tokens.skip(TokenType.SYMBOL, ".");
        String className = TokenParser.parseIdentifier(tokens);
        return new Attribute("class", className, true);
    }

    private static boolean parseIsFresh(TokenIterator<TokenType> tokens) {
        return tokens.tryParse(() -> {
            tokens.skip(TokenType.SYMBOL, ":");
            tokens.skip(TokenType.IDENTIFIER, "fresh");
        });
    }

    private static String parseSeparator(TokenIterator<TokenType> tokens) {
        boolean isSeparator = tokens.tryParse(() -> {
            tokens.skip(TokenType.SYMBOL, ":");
            tokens.skip(TokenType.IDENTIFIER, "separator");
        });
        if (isSeparator) {
            tokens.skip(TokenType.SYMBOL, "(");
            String value = TokenParser.parseString(tokens);
            tokens.skip(TokenType.SYMBOL, ")");
            return value;
        }
        return "";
    }

    private static class Attribute {
        private final String name;
        private final String value;
        private final boolean append;

        private Attribute(String name, String value, boolean append) {
            this.name = name;
            this.value = value;
            this.append = append;
        }
    }
}

