/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.styles;

import java.util.Optional;
import org.zwobble.mammoth.internal.documents.Table;
import org.zwobble.mammoth.internal.styles.DocumentElementMatcher;
import org.zwobble.mammoth.internal.styles.DocumentElementMatching;
import org.zwobble.mammoth.internal.styles.EqualToStringMatcher;
import org.zwobble.mammoth.internal.styles.StringMatcher;

public class TableMatcher
implements DocumentElementMatcher<Table> {
    public static final TableMatcher ANY = new TableMatcher(Optional.empty(), Optional.empty());
    private final Optional<String> styleId;
    private final Optional<StringMatcher> styleName;

    public static TableMatcher styleId(String styleId) {
        return new TableMatcher(Optional.of(styleId), Optional.empty());
    }

    public static TableMatcher styleName(String styleName) {
        return new TableMatcher(Optional.empty(), Optional.of(new EqualToStringMatcher(styleName)));
    }

    public TableMatcher(Optional<String> styleId, Optional<StringMatcher> styleName) {
        this.styleId = styleId;
        this.styleName = styleName;
    }

    @Override
    public boolean matches(Table table) {
        return DocumentElementMatching.matchesStyle(this.styleId, this.styleName, table.getStyle());
    }
}

