/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.styles;

import java.util.List;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.Break;
import org.zwobble.mammoth.internal.documents.Paragraph;
import org.zwobble.mammoth.internal.documents.Run;
import org.zwobble.mammoth.internal.documents.Table;
import org.zwobble.mammoth.internal.styles.HtmlPath;
import org.zwobble.mammoth.internal.styles.StyleMapBuilder;
import org.zwobble.mammoth.internal.styles.StyleMapping;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.util.Optionals;

public class StyleMap {
    public static final StyleMap EMPTY = new StyleMapBuilder().build();
    private final Optional<HtmlPath> bold;
    private final Optional<HtmlPath> italic;
    private final Optional<HtmlPath> underline;
    private final Optional<HtmlPath> strikethrough;
    private final Optional<HtmlPath> allCaps;
    private final Optional<HtmlPath> smallCaps;
    private final Optional<HtmlPath> commentReference;
    private final List<StyleMapping<Paragraph>> paragraphStyles;
    private final List<StyleMapping<Run>> runStyles;
    private final List<StyleMapping<Table>> tableStyles;
    private final List<StyleMapping<Break>> breakStyles;
    private final List<StyleMapping<String>> highlightStyles;

    public static StyleMapBuilder builder() {
        return new StyleMapBuilder();
    }

    public static StyleMap merge(StyleMap high, StyleMap low) {
        return new StyleMap(Optionals.first(high.bold, low.bold), Optionals.first(high.italic, low.italic), Optionals.first(high.underline, low.underline), Optionals.first(high.strikethrough, low.strikethrough), Optionals.first(high.allCaps, low.allCaps), Optionals.first(high.smallCaps, low.smallCaps), Optionals.first(high.commentReference, low.commentReference), Lists.eagerConcat(high.paragraphStyles, low.paragraphStyles), Lists.eagerConcat(high.runStyles, low.runStyles), Lists.eagerConcat(high.tableStyles, low.tableStyles), Lists.eagerConcat(high.breakStyles, low.breakStyles), Lists.eagerConcat(high.highlightStyles, low.highlightStyles));
    }

    public StyleMap(Optional<HtmlPath> bold, Optional<HtmlPath> italic, Optional<HtmlPath> underline, Optional<HtmlPath> strikethrough, Optional<HtmlPath> allCaps, Optional<HtmlPath> smallCaps, Optional<HtmlPath> commentReference, List<StyleMapping<Paragraph>> paragraphStyles, List<StyleMapping<Run>> runStyles, List<StyleMapping<Table>> tableStyles, List<StyleMapping<Break>> breakStyles, List<StyleMapping<String>> highlightStyles) {
        this.bold = bold;
        this.italic = italic;
        this.underline = underline;
        this.strikethrough = strikethrough;
        this.allCaps = allCaps;
        this.smallCaps = smallCaps;
        this.commentReference = commentReference;
        this.paragraphStyles = paragraphStyles;
        this.runStyles = runStyles;
        this.tableStyles = tableStyles;
        this.breakStyles = breakStyles;
        this.highlightStyles = highlightStyles;
    }

    public StyleMap update(StyleMap styleMap) {
        return StyleMap.merge(styleMap, this);
    }

    public Optional<HtmlPath> getBold() {
        return this.bold;
    }

    public Optional<HtmlPath> getItalic() {
        return this.italic;
    }

    public Optional<HtmlPath> getUnderline() {
        return this.underline;
    }

    public Optional<HtmlPath> getStrikethrough() {
        return this.strikethrough;
    }

    public Optional<HtmlPath> getAllCaps() {
        return this.allCaps;
    }

    public Optional<HtmlPath> getSmallCaps() {
        return this.smallCaps;
    }

    public Optional<HtmlPath> getCommentReference() {
        return this.commentReference;
    }

    public Optional<HtmlPath> getParagraphHtmlPath(Paragraph paragraph) {
        return Iterables.tryFind(this.paragraphStyles, styleMapping -> styleMapping.matches(paragraph)).map(StyleMapping::getHtmlPath);
    }

    public Optional<HtmlPath> getRunHtmlPath(Run run) {
        return Iterables.tryFind(this.runStyles, styleMapping -> styleMapping.matches(run)).map(StyleMapping::getHtmlPath);
    }

    public Optional<HtmlPath> getTableHtmlPath(Table table) {
        return Iterables.tryFind(this.tableStyles, styleMapping -> styleMapping.matches(table)).map(StyleMapping::getHtmlPath);
    }

    public Optional<HtmlPath> getBreakHtmlPath(Break breakElement) {
        return Iterables.tryFind(this.breakStyles, styleMapping -> styleMapping.matches(breakElement)).map(StyleMapping::getHtmlPath);
    }

    public Optional<HtmlPath> getHighlightHtmlPath(String color) {
        return Iterables.tryFind(this.highlightStyles, styleMapping -> styleMapping.matches(color)).map(StyleMapping::getHtmlPath);
    }
}

