/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.results;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.zwobble.mammoth.Result;
import org.zwobble.mammoth.internal.documents.Style;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.util.Sets;

public class InternalResult<T> {
    private final T value;
    private final Iterable<String> warnings;

    public static <T, R> InternalResult<List<R>> flatMap(Iterable<T> iterable, Function<T, InternalResult<R>> function) {
        List<InternalResult<R>> results = Lists.eagerMap(iterable, function);
        return new InternalResult<List<R>>(Lists.eagerMap(results, result -> result.value), Iterables.lazyFlatMap(results, result -> result.warnings));
    }

    public static <T1, T2, R> InternalResult<R> flatMap(InternalResult<T1> first, InternalResult<T2> second, BiFunction<T1, T2, InternalResult<R>> function) {
        InternalResult<R> intermediateResult = function.apply(first.value, second.value);
        return new InternalResult(intermediateResult.value, Iterables.lazyConcat(Iterables.lazyConcat(first.warnings, second.warnings), intermediateResult.warnings));
    }

    public static <T1, T2, R> InternalResult<R> map(InternalResult<T1> first, InternalResult<T2> second, BiFunction<T1, T2, R> function) {
        return new InternalResult<R>(function.apply(first.value, second.value), Iterables.lazyConcat(first.warnings, second.warnings));
    }

    public static InternalResult<Optional<Style>> empty() {
        return new InternalResult<Optional<Style>>(Optional.empty(), Lists.list());
    }

    public static <T> InternalResult<T> success(T value) {
        return new InternalResult<T>(value, Lists.list());
    }

    public InternalResult(T value, Iterable<String> warnings) {
        this.value = value;
        this.warnings = warnings;
    }

    public T getValue() {
        return this.value;
    }

    public Iterable<String> getWarnings() {
        return this.warnings;
    }

    public <R> InternalResult<R> map(Function<T, R> function) {
        return new InternalResult<R>(function.apply(this.value), this.warnings);
    }

    public <R> InternalResult<R> flatMap(Function<T, InternalResult<R>> function) {
        InternalResult<R> intermediateResult = function.apply(this.value);
        return new InternalResult<T>(intermediateResult.value, Iterables.lazyConcat(this.warnings, intermediateResult.warnings));
    }

    public Result<T> toResult() {
        final Set<String> warnings = Sets.toSet(this.warnings);
        return new Result<T>(){
            final /* synthetic */ InternalResult this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T getValue() {
                return this.this$0.value;
            }

            @Override
            public Set<String> getWarnings() {
                return warnings;
            }
        };
    }
}

