/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zwobble.mammoth.internal.archives.Archive;
import org.zwobble.mammoth.internal.archives.Archives;
import org.zwobble.mammoth.internal.documents.Bookmark;
import org.zwobble.mammoth.internal.documents.Break;
import org.zwobble.mammoth.internal.documents.Checkbox;
import org.zwobble.mammoth.internal.documents.CommentReference;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.documents.DocumentElementVisitor;
import org.zwobble.mammoth.internal.documents.HasChildren;
import org.zwobble.mammoth.internal.documents.Hyperlink;
import org.zwobble.mammoth.internal.documents.Image;
import org.zwobble.mammoth.internal.documents.NoteReference;
import org.zwobble.mammoth.internal.documents.NoteType;
import org.zwobble.mammoth.internal.documents.NumberingLevel;
import org.zwobble.mammoth.internal.documents.Paragraph;
import org.zwobble.mammoth.internal.documents.ParagraphIndent;
import org.zwobble.mammoth.internal.documents.Run;
import org.zwobble.mammoth.internal.documents.Style;
import org.zwobble.mammoth.internal.documents.Tab;
import org.zwobble.mammoth.internal.documents.Table;
import org.zwobble.mammoth.internal.documents.TableCell;
import org.zwobble.mammoth.internal.documents.TableRow;
import org.zwobble.mammoth.internal.documents.Text;
import org.zwobble.mammoth.internal.documents.VerticalAlignment;
import org.zwobble.mammoth.internal.docx.ContentTypes;
import org.zwobble.mammoth.internal.docx.Dingbats;
import org.zwobble.mammoth.internal.docx.FileReader;
import org.zwobble.mammoth.internal.docx.Numbering;
import org.zwobble.mammoth.internal.docx.ReadResult;
import org.zwobble.mammoth.internal.docx.Relationships;
import org.zwobble.mammoth.internal.docx.Styles;
import org.zwobble.mammoth.internal.docx.Uris;
import org.zwobble.mammoth.internal.results.InternalResult;
import org.zwobble.mammoth.internal.util.Casts;
import org.zwobble.mammoth.internal.util.InputStreamSupplier;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.util.Maps;
import org.zwobble.mammoth.internal.util.MutableBoolean;
import org.zwobble.mammoth.internal.util.Optionals;
import org.zwobble.mammoth.internal.util.Queues;
import org.zwobble.mammoth.internal.util.Sets;
import org.zwobble.mammoth.internal.util.Strings;
import org.zwobble.mammoth.internal.xml.NullXmlElement;
import org.zwobble.mammoth.internal.xml.XmlElement;
import org.zwobble.mammoth.internal.xml.XmlElementLike;
import org.zwobble.mammoth.internal.xml.XmlElementList;
import org.zwobble.mammoth.internal.xml.XmlNode;

class StatefulBodyXmlReader {
    private static final Set<String> IMAGE_TYPES_SUPPORTED_BY_BROWSERS = Sets.set("image/png", "image/gif", "image/jpeg", "image/svg+xml", "image/tiff");
    private final Styles styles;
    private final Numbering numbering;
    private final Relationships relationships;
    private final ContentTypes contentTypes;
    private final Archive file;
    private final FileReader fileReader;
    private final StringBuilder currentInstrText;
    private final Queue<ComplexField> complexFieldStack;
    private List<XmlNode> deletedParagraphContents;

    StatefulBodyXmlReader(Styles styles, Numbering numbering, Relationships relationships, ContentTypes contentTypes, Archive file, FileReader fileReader) {
        this.styles = styles;
        this.numbering = numbering;
        this.relationships = relationships;
        this.contentTypes = contentTypes;
        this.file = file;
        this.fileReader = fileReader;
        this.currentInstrText = new StringBuilder();
        this.complexFieldStack = Queues.stack();
        this.deletedParagraphContents = new ArrayList<XmlNode>();
    }

    ReadResult readElement(XmlElement element) {
        switch (element.getName()) {
            case "w:t": {
                return ReadResult.success(new Text(element.innerText()));
            }
            case "w:r": {
                return this.readRun(element);
            }
            case "w:p": {
                return this.readParagraph(element);
            }
            case "w:fldChar": {
                return this.readFieldChar(element);
            }
            case "w:instrText": {
                return this.readInstrText(element);
            }
            case "w:tab": {
                return ReadResult.success(Tab.TAB);
            }
            case "w:noBreakHyphen": {
                return ReadResult.success(new Text("\u2011"));
            }
            case "w:softHyphen": {
                return ReadResult.success(new Text("\u00ad"));
            }
            case "w:sym": {
                return this.readSymbol(element);
            }
            case "w:br": {
                return this.readBreak(element);
            }
            case "w:tbl": {
                return this.readTable(element);
            }
            case "w:tr": {
                return this.readTableRow(element);
            }
            case "w:tc": {
                return this.readTableCell(element);
            }
            case "w:hyperlink": {
                return this.readHyperlink(element);
            }
            case "w:bookmarkStart": {
                return this.readBookmark(element);
            }
            case "w:footnoteReference": {
                return this.readNoteReference(NoteType.FOOTNOTE, element);
            }
            case "w:endnoteReference": {
                return this.readNoteReference(NoteType.ENDNOTE, element);
            }
            case "w:commentReference": {
                return this.readCommentReference(element);
            }
            case "w:pict": {
                return this.readPict(element);
            }
            case "v:imagedata": {
                return this.readImagedata(element);
            }
            case "wp:inline": 
            case "wp:anchor": {
                return this.readInline(element);
            }
            case "w:sdt": {
                return this.readSdt(element);
            }
            case "w:ins": 
            case "w:object": 
            case "w:smartTag": 
            case "w:drawing": 
            case "v:group": 
            case "v:rect": 
            case "v:roundrect": 
            case "v:shape": 
            case "v:textbox": 
            case "w:txbxContent": {
                return this.readElements(element.getChildren());
            }
            case "office-word:wrap": 
            case "v:shadow": 
            case "v:shapetype": 
            case "w:bookmarkEnd": 
            case "w:sectPr": 
            case "w:proofErr": 
            case "w:lastRenderedPageBreak": 
            case "w:commentRangeStart": 
            case "w:commentRangeEnd": 
            case "w:del": 
            case "w:footnoteRef": 
            case "w:endnoteRef": 
            case "w:annotationRef": 
            case "w:pPr": 
            case "w:rPr": 
            case "w:tblPr": 
            case "w:tblGrid": 
            case "w:trPr": 
            case "w:tcPr": {
                return ReadResult.EMPTY_SUCCESS;
            }
        }
        String warning = "An unrecognised element was ignored: " + element.getName();
        return ReadResult.emptyWithWarning(warning);
    }

    private ReadResult readRun(XmlElement element) {
        XmlElementLike properties = element.findChildOrEmpty("w:rPr");
        return ReadResult.map(this.readRunStyle(properties), this.readElements(element.getChildren()), (style, children) -> {
            Optional<HyperlinkComplexField> hyperlinkComplexField = this.currentHyperlinkComplexField();
            if (hyperlinkComplexField.isPresent()) {
                children = Lists.list((DocumentElement)hyperlinkComplexField.get().childrenToHyperlink.apply(children));
            }
            return new Run(this.readHighlight(properties), this.isBold(properties), this.isItalic(properties), this.isUnderline(properties), this.isStrikethrough(properties), this.isAllCaps(properties), this.isSmallCaps(properties), this.readVerticalAlignment(properties), (Optional<Style>)style, (List<DocumentElement>)children);
        });
    }

    private Optional<HyperlinkComplexField> currentHyperlinkComplexField() {
        return Iterables.tryGetLast(Iterables.lazyFilter(this.complexFieldStack, HyperlinkComplexField.class));
    }

    private Optional<String> readHighlight(XmlElementLike properties) {
        return this.readVal(properties, "w:highlight").filter(value -> !value.isEmpty() && !value.equals("none"));
    }

    private boolean isBold(XmlElementLike properties) {
        return this.readBooleanElement(properties, "w:b");
    }

    private boolean isItalic(XmlElementLike properties) {
        return this.readBooleanElement(properties, "w:i");
    }

    private boolean isUnderline(XmlElementLike properties) {
        return properties.findChild("w:u").flatMap(child -> child.getAttributeOrNone("w:val")).map(value -> !value.equals("false") && !value.equals("0") && !value.equals("none")).orElse(false);
    }

    private boolean isStrikethrough(XmlElementLike properties) {
        return this.readBooleanElement(properties, "w:strike");
    }

    private boolean isAllCaps(XmlElementLike properties) {
        return this.readBooleanElement(properties, "w:caps");
    }

    private boolean isSmallCaps(XmlElementLike properties) {
        return this.readBooleanElement(properties, "w:smallCaps");
    }

    private boolean readBooleanElement(XmlElementLike properties, String tagName) {
        return properties.findChild(tagName).map(child -> this.readBooleanAttributeValue(child.getAttributeOrNone("w:val"))).orElse(false);
    }

    private boolean readBooleanAttributeValue(Optional<String> valAttributeValue) {
        return valAttributeValue.map(value -> !value.equals("false") && !value.equals("0")).orElse(true);
    }

    private VerticalAlignment readVerticalAlignment(XmlElementLike properties) {
        String verticalAlignment;
        switch (verticalAlignment = this.readVal(properties, "w:vertAlign").orElse("")) {
            case "superscript": {
                return VerticalAlignment.SUPERSCRIPT;
            }
            case "subscript": {
                return VerticalAlignment.SUBSCRIPT;
            }
        }
        return VerticalAlignment.BASELINE;
    }

    private InternalResult<Optional<Style>> readRunStyle(XmlElementLike properties) {
        return this.readStyle(properties, "w:rStyle", "Run", this.styles::findCharacterStyleById);
    }

    ReadResult readElements(Iterable<XmlNode> nodes) {
        return ReadResult.flatMap(Iterables.lazyFilter(nodes, XmlElement.class), this::readElement);
    }

    private ReadResult readParagraph(XmlElement element) {
        XmlElementLike properties = element.findChildOrEmpty("w:pPr");
        boolean isDeleted = properties.findChildOrEmpty("w:rPr").findChild("w:del").isPresent();
        if (isDeleted) {
            this.deletedParagraphContents.addAll(element.getChildren());
            return ReadResult.success(Lists.list());
        }
        ParagraphIndent indent = this.readParagraphIndent(properties);
        List<XmlNode> childrenXml = element.getChildren();
        if (!this.deletedParagraphContents.isEmpty()) {
            childrenXml = Lists.eagerConcat(this.deletedParagraphContents, childrenXml);
            this.deletedParagraphContents = new ArrayList<XmlNode>();
        }
        return ReadResult.map(this.readParagraphStyle(properties), this.readElements(childrenXml), (style, children) -> new Paragraph((Optional<Style>)style, this.readNumbering((Optional<Style>)style, properties), indent, (List<DocumentElement>)children)).appendExtra();
    }

    private ReadResult readFieldChar(XmlElement element) {
        String type = element.getAttributeOrNone("w:fldCharType").orElse("");
        if (type.equals("begin")) {
            this.complexFieldStack.add(ComplexField.begin(element));
            this.currentInstrText.setLength(0);
        } else if (type.equals("end")) {
            ComplexField complexField = this.complexFieldStack.remove();
            if (complexField instanceof BeginComplexField) {
                complexField = this.parseCurrentInstrText(complexField);
            }
            if (complexField instanceof CheckboxComplexField) {
                return ReadResult.success(new Checkbox(((CheckboxComplexField)complexField).checked));
            }
        } else if (type.equals("separate")) {
            ComplexField complexFieldSeparate = this.complexFieldStack.remove();
            ComplexField complexField = this.parseCurrentInstrText(complexFieldSeparate);
            this.complexFieldStack.add(complexField);
        }
        return ReadResult.EMPTY_SUCCESS;
    }

    private ComplexField parseCurrentInstrText(ComplexField complexField) {
        String instrText = this.currentInstrText.toString();
        XmlElementLike fldChar = complexField instanceof BeginComplexField ? ((BeginComplexField)complexField).fldChar : NullXmlElement.INSTANCE;
        return this.parseInstrText(instrText, fldChar);
    }

    private ComplexField parseInstrText(String instrText, XmlElementLike fldChar) {
        Pattern externalLinkPattern = Pattern.compile("\\s*HYPERLINK \"(.*)\"");
        Matcher externalLinkMatcher = externalLinkPattern.matcher(instrText);
        if (externalLinkMatcher.lookingAt()) {
            String href = externalLinkMatcher.group(1);
            return ComplexField.hyperlink(children -> Hyperlink.href(href, Optional.empty(), children));
        }
        Pattern internalLinkPattern = Pattern.compile("\\s*HYPERLINK\\s+\\\\l\\s+\"(.*)\"");
        Matcher internalLinkMatcher = internalLinkPattern.matcher(instrText);
        if (internalLinkMatcher.lookingAt()) {
            String anchor = internalLinkMatcher.group(1);
            return ComplexField.hyperlink(children -> Hyperlink.anchor(anchor, Optional.empty(), children));
        }
        Pattern checkboxPattern = Pattern.compile("\\s*FORMCHECKBOX\\s*");
        Matcher checkboxMatcher = checkboxPattern.matcher(instrText);
        if (checkboxMatcher.lookingAt()) {
            XmlElementLike checkboxElement = fldChar.findChildOrEmpty("w:ffData").findChildOrEmpty("w:checkBox");
            boolean checked = checkboxElement.hasChild("w:checked") ? this.readBooleanElement(checkboxElement, "w:checked") : this.readBooleanElement(checkboxElement, "w:default");
            return ComplexField.checkbox(checked);
        }
        return ComplexField.UNKNOWN;
    }

    private ReadResult readInstrText(XmlElement element) {
        this.currentInstrText.append(element.innerText());
        return ReadResult.EMPTY_SUCCESS;
    }

    private InternalResult<Optional<Style>> readParagraphStyle(XmlElementLike properties) {
        return this.readStyle(properties, "w:pStyle", "Paragraph", this.styles::findParagraphStyleById);
    }

    private InternalResult<Optional<Style>> readStyle(XmlElementLike properties, String styleTagName, String styleType, Function<String, Optional<Style>> findStyleById) {
        return this.readVal(properties, styleTagName).map(styleId -> this.findStyleById(styleType, (String)styleId, findStyleById)).orElse(InternalResult.empty());
    }

    private InternalResult<Optional<Style>> findStyleById(String styleType, String styleId, Function<String, Optional<Style>> findStyleById) {
        Optional<Style> style = findStyleById.apply(styleId);
        if (style.isPresent()) {
            return InternalResult.success(style);
        }
        return new InternalResult<Optional<Style>>(Optional.of(new Style(styleId, Optional.empty())), Lists.list(styleType + " style with ID " + styleId + " was referenced but not defined in the document"));
    }

    private Optional<NumberingLevel> readNumbering(Optional<Style> style, XmlElementLike properties) {
        String styleId;
        Optional<NumberingLevel> level;
        XmlElementLike numberingProperties = properties.findChildOrEmpty("w:numPr");
        Optional<String> numId = this.readVal(numberingProperties, "w:numId");
        Optional<String> levelIndex = this.readVal(numberingProperties, "w:ilvl");
        if (numId.isPresent() && levelIndex.isPresent()) {
            return this.numbering.findLevel(numId.get(), levelIndex.get());
        }
        if (style.isPresent() && (level = this.numbering.findLevelByParagraphStyleId(styleId = style.get().getStyleId())).isPresent()) {
            return level;
        }
        return Optional.empty();
    }

    private ParagraphIndent readParagraphIndent(XmlElementLike properties) {
        XmlElementLike indent = properties.findChildOrEmpty("w:ind");
        return new ParagraphIndent(Optionals.first(indent.getAttributeOrNone("w:start"), indent.getAttributeOrNone("w:left")), Optionals.first(indent.getAttributeOrNone("w:end"), indent.getAttributeOrNone("w:right")), indent.getAttributeOrNone("w:firstLine"), indent.getAttributeOrNone("w:hanging"));
    }

    private ReadResult readSymbol(XmlElement element) {
        Optional<String> font = element.getAttributeOrNone("w:font");
        Optional<String> charValue = element.getAttributeOrNone("w:char");
        if (font.isPresent() && charValue.isPresent()) {
            Optional<Integer> dingbat = Dingbats.findDingbat(font.get(), Integer.parseInt(charValue.get(), 16));
            if (!dingbat.isPresent() && Pattern.matches("F0..", charValue.get())) {
                dingbat = Dingbats.findDingbat(font.get(), Integer.parseInt(charValue.get().substring(2), 16));
            }
            if (dingbat.isPresent()) {
                return ReadResult.success(new Text(Strings.codepointToString(dingbat.get())));
            }
        }
        return ReadResult.emptyWithWarning("A w:sym element with an unsupported character was ignored: char " + charValue.orElse("null") + " in font " + font.orElse("null"));
    }

    private ReadResult readBreak(XmlElement element) {
        String breakType;
        switch (breakType = element.getAttributeOrNone("w:type").orElse("textWrapping")) {
            case "textWrapping": {
                return ReadResult.success(Break.LINE_BREAK);
            }
            case "page": {
                return ReadResult.success(Break.PAGE_BREAK);
            }
            case "column": {
                return ReadResult.success(Break.COLUMN_BREAK);
            }
        }
        return ReadResult.emptyWithWarning("Unsupported break type: " + breakType);
    }

    private ReadResult readTable(XmlElement element) {
        XmlElementLike properties = element.findChildOrEmpty("w:tblPr");
        return ReadResult.map(this.readTableStyle(properties), this.readElements(element.getChildren()).flatMap(this::calculateRowspans), Table::new);
    }

    private InternalResult<Optional<Style>> readTableStyle(XmlElementLike properties) {
        return this.readStyle(properties, "w:tblStyle", "Table", this.styles::findTableStyleById);
    }

    private ReadResult calculateRowspans(List<DocumentElement> rows) {
        Optional<String> error = this.checkTableRows(rows);
        if (error.isPresent()) {
            return ReadResult.withWarning(rows, error.get());
        }
        HashMap<Map.Entry<Integer, Integer>, Integer> rowspans = new HashMap<Map.Entry<Integer, Integer>, Integer>();
        HashSet<Map.Entry<Integer, Integer>> merged = new HashSet<Map.Entry<Integer, Integer>>();
        HashMap<Integer, Map.Entry<Integer, Integer>> lastCellForColumn = new HashMap<Integer, Map.Entry<Integer, Integer>>();
        for (int rowIndex2 = 0; rowIndex2 < rows.size(); ++rowIndex2) {
            TableRow row = (TableRow)rows.get(rowIndex2);
            int columnIndex = 0;
            for (int cellIndex = 0; cellIndex < row.getChildren().size(); ++cellIndex) {
                UnmergedTableCell cell = (UnmergedTableCell)row.getChildren().get(cellIndex);
                Optional spanningCell = Maps.lookup(lastCellForColumn, columnIndex);
                Map.Entry<Integer, Integer> position = Maps.entry(rowIndex2, cellIndex);
                if (cell.vmerge && spanningCell.isPresent()) {
                    rowspans.put((Map.Entry)spanningCell.get(), (Integer)Maps.lookup(rowspans, (Map.Entry)spanningCell.get()).get() + 1);
                    merged.add(position);
                } else {
                    lastCellForColumn.put(columnIndex, position);
                    rowspans.put(position, 1);
                }
                columnIndex += cell.colspan;
            }
        }
        return ReadResult.success(Lists.eagerMapWithIndex(rows, (rowIndex, rowElement) -> {
            TableRow row = (TableRow)rowElement;
            ArrayList<DocumentElement> mergedCells = new ArrayList<DocumentElement>();
            for (int cellIndex = 0; cellIndex < row.getChildren().size(); ++cellIndex) {
                UnmergedTableCell cell = (UnmergedTableCell)row.getChildren().get(cellIndex);
                Map.Entry<Integer, Integer> position = Maps.entry(rowIndex, cellIndex);
                if (merged.contains(position)) continue;
                mergedCells.add(new TableCell((Integer)Maps.lookup(rowspans, position).get(), cell.colspan, cell.children));
            }
            return new TableRow(mergedCells, row.isHeader());
        }));
    }

    private Optional<String> checkTableRows(List<DocumentElement> rows) {
        for (DocumentElement rowElement : rows) {
            Optional<TableRow> row = Casts.tryCast(TableRow.class, rowElement);
            if (!row.isPresent()) {
                return Optional.of("unexpected non-row element in table, cell merging may be incorrect");
            }
            for (DocumentElement cell : row.get().getChildren()) {
                if (cell instanceof UnmergedTableCell) continue;
                return Optional.of("unexpected non-cell element in table row, cell merging may be incorrect");
            }
        }
        return Optional.empty();
    }

    private ReadResult readTableRow(XmlElement element) {
        XmlElementLike properties = element.findChildOrEmpty("w:trPr");
        boolean deleted = properties.hasChild("w:del");
        if (deleted) {
            return ReadResult.EMPTY_SUCCESS;
        }
        boolean isHeader = properties.hasChild("w:tblHeader");
        return this.readElements(element.getChildren()).map(children -> Lists.list(new TableRow((List<DocumentElement>)children, isHeader)));
    }

    private ReadResult readTableCell(XmlElement element) {
        XmlElementLike properties = element.findChildOrEmpty("w:tcPr");
        Optional<String> gridSpan = properties.findChildOrEmpty("w:gridSpan").getAttributeOrNone("w:val");
        int colspan = gridSpan.map(Integer::parseInt).orElse(1);
        return this.readElements(element.getChildren()).map(children -> Lists.list(new UnmergedTableCell(this.readVmerge(properties), colspan, (List)children)));
    }

    private boolean readVmerge(XmlElementLike properties) {
        return properties.findChild("w:vMerge").map(element -> element.getAttributeOrNone("w:val").map(val -> val.equals("continue")).orElse(true)).orElse(false);
    }

    private ReadResult readHyperlink(XmlElement element) {
        Optional<String> relationshipId = element.getAttributeOrNone("r:id");
        Optional<String> anchor = element.getAttributeOrNone("w:anchor");
        Optional<String> targetFrame = element.getAttributeOrNone("w:tgtFrame").filter(value -> !value.isEmpty());
        ReadResult childrenResult = this.readElements(element.getChildren());
        if (relationshipId.isPresent()) {
            String targetHref = this.relationships.findTargetByRelationshipId(relationshipId.get());
            String href = anchor.map(fragment -> Uris.replaceFragment(targetHref, (String)anchor.get())).orElse(targetHref);
            return childrenResult.map(children -> Lists.list(Hyperlink.href(href, targetFrame, children)));
        }
        if (anchor.isPresent()) {
            return childrenResult.map(children -> Lists.list(Hyperlink.anchor((String)anchor.get(), targetFrame, children)));
        }
        return childrenResult;
    }

    private ReadResult readBookmark(XmlElement element) {
        String name = element.getAttribute("w:name");
        if (name.equals("_GoBack")) {
            return ReadResult.EMPTY_SUCCESS;
        }
        return ReadResult.success(new Bookmark(name));
    }

    private ReadResult readNoteReference(NoteType noteType, XmlElement element) {
        String noteId = element.getAttribute("w:id");
        return ReadResult.success(new NoteReference(noteType, noteId));
    }

    private ReadResult readCommentReference(XmlElement element) {
        String commentId = element.getAttribute("w:id");
        return ReadResult.success(new CommentReference(commentId));
    }

    private ReadResult readPict(XmlElement element) {
        return this.readElements(element.getChildren()).toExtra();
    }

    private ReadResult readImagedata(XmlElement element) {
        return element.getAttributeOrNone("r:id").map(relationshipId -> {
            Optional<String> title = element.getAttributeOrNone("o:title");
            String imagePath = this.relationshipIdToDocxPath((String)relationshipId);
            return this.readImage(imagePath, title, () -> Archives.getInputStream(this.file, imagePath));
        }).orElse(ReadResult.emptyWithWarning("A v:imagedata element without a relationship ID was ignored"));
    }

    private ReadResult readInline(XmlElement element) {
        XmlElementLike properties = element.findChildOrEmpty("wp:docPr");
        Optional<String> altText = Optionals.first(properties.getAttributeOrNone("descr").filter(description -> !description.trim().isEmpty()), properties.getAttributeOrNone("title"));
        XmlElementList blips = element.findChildren("a:graphic").findChildren("a:graphicData").findChildren("pic:pic").findChildren("pic:blipFill").findChildren("a:blip");
        return this.readBlips(blips, altText);
    }

    private ReadResult readBlips(XmlElementList blips, Optional<String> altText) {
        return ReadResult.flatMap(blips, blip -> this.readBlip((XmlElement)blip, altText));
    }

    private ReadResult readBlip(XmlElement blip, Optional<String> altText) {
        Optional<String> embedRelationshipId = blip.getAttributeOrNone("r:embed");
        Optional<String> linkRelationshipId = blip.getAttributeOrNone("r:link");
        if (embedRelationshipId.isPresent()) {
            String imagePath = this.relationshipIdToDocxPath(embedRelationshipId.get());
            return this.readImage(imagePath, altText, () -> Archives.getInputStream(this.file, imagePath));
        }
        if (linkRelationshipId.isPresent()) {
            String imagePath = this.relationships.findTargetByRelationshipId(linkRelationshipId.get());
            return this.readImage(imagePath, altText, () -> this.fileReader.getInputStream(imagePath));
        }
        return ReadResult.emptyWithWarning("Could not find image file for a:blip element");
    }

    private ReadResult readImage(String imagePath, Optional<String> altText, InputStreamSupplier open) {
        Optional<String> contentType = this.contentTypes.findContentType(imagePath);
        Image image = new Image(altText, contentType, open);
        String contentTypeString = contentType.orElse("(unknown)");
        if (IMAGE_TYPES_SUPPORTED_BY_BROWSERS.contains(contentTypeString)) {
            return ReadResult.success(image);
        }
        return ReadResult.withWarning(image, "Image of type " + contentTypeString + " is unlikely to display in web browsers");
    }

    private ReadResult readSdt(XmlElement element) {
        ReadResult contentResult = this.readElements(element.findChildOrEmpty("w:sdtContent").getChildren());
        return contentResult.map(content -> {
            Optional<XmlElement> checkbox = element.findChildOrEmpty("w:sdtPr").findChild("wordml:checkbox");
            if (!checkbox.isPresent()) {
                return content;
            }
            Optional<XmlElement> checkedElement = checkbox.get().findChild("wordml:checked");
            boolean isChecked = checkedElement.isPresent() && this.readBooleanAttributeValue(checkedElement.get().getAttributeOrNone("wordml:val"));
            Checkbox documentCheckbox = new Checkbox(isChecked);
            MutableBoolean hasCheckbox = new MutableBoolean(false);
            List<DocumentElement> replacedContent = Lists.eagerMap(content, this.transformElementsOfType(Text.class, text -> {
                if (text.getValue().length() > 0 && !hasCheckbox.get()) {
                    hasCheckbox.set(true);
                    return documentCheckbox;
                }
                return text;
            }));
            if (hasCheckbox.get()) {
                return replacedContent;
            }
            return Lists.list(documentCheckbox);
        });
    }

    private <T extends DocumentElement> Function<DocumentElement, DocumentElement> transformElementsOfType(Class<T> elementClass, Function<T, DocumentElement> transform) {
        return element -> {
            if (element instanceof HasChildren) {
                element = (DocumentElement)((HasChildren)((Object)element)).replaceChildren(Lists.eagerMap(((HasChildren)((Object)element)).getChildren(), this.transformElementsOfType(elementClass, transform)));
            }
            if (elementClass.isInstance(element)) {
                return (DocumentElement)transform.apply(element);
            }
            return element;
        };
    }

    private String relationshipIdToDocxPath(String relationshipId) {
        String target = this.relationships.findTargetByRelationshipId(relationshipId);
        return Uris.uriToZipEntryName("word", target);
    }

    private Optional<String> readVal(XmlElementLike element, String name) {
        return element.findChildOrEmpty(name).getAttributeOrNone("w:val");
    }

    private static class HyperlinkComplexField
    implements ComplexField {
        private final Function<List<DocumentElement>, Hyperlink> childrenToHyperlink;

        private HyperlinkComplexField(Function<List<DocumentElement>, Hyperlink> childrenToHyperlink) {
            this.childrenToHyperlink = childrenToHyperlink;
        }
    }

    private static interface ComplexField {
        public static final ComplexField UNKNOWN = new ComplexField(){};

        public static ComplexField begin(XmlElement fldChar) {
            return new BeginComplexField(fldChar);
        }

        public static ComplexField hyperlink(Function<List<DocumentElement>, Hyperlink> childrenToHyperlink) {
            return new HyperlinkComplexField(childrenToHyperlink);
        }

        public static ComplexField checkbox(boolean checked) {
            return new CheckboxComplexField(checked);
        }
    }

    private static class BeginComplexField
    implements ComplexField {
        private final XmlElement fldChar;

        private BeginComplexField(XmlElement fldChar) {
            this.fldChar = fldChar;
        }
    }

    private static class CheckboxComplexField
    implements ComplexField {
        private final boolean checked;

        private CheckboxComplexField(boolean checked) {
            this.checked = checked;
        }
    }

    private static class UnmergedTableCell
    implements DocumentElement,
    HasChildren<UnmergedTableCell> {
        private final boolean vmerge;
        private final int colspan;
        private final List<DocumentElement> children;

        private UnmergedTableCell(boolean vmerge, int colspan, List<DocumentElement> children) {
            this.vmerge = vmerge;
            this.colspan = colspan;
            this.children = children;
        }

        @Override
        public List<DocumentElement> getChildren() {
            return this.children;
        }

        @Override
        public UnmergedTableCell replaceChildren(List<DocumentElement> newChildren) {
            return new UnmergedTableCell(this.vmerge, this.colspan, newChildren);
        }

        @Override
        public <T, U> T accept(DocumentElementVisitor<T, U> visitor, U context) {
            return visitor.visit(new TableCell(1, this.colspan, this.children), context);
        }
    }
}

