/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.List;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.Comment;
import org.zwobble.mammoth.internal.documents.Document;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.documents.Notes;
import org.zwobble.mammoth.internal.docx.BodyXmlReader;
import org.zwobble.mammoth.internal.results.InternalResult;
import org.zwobble.mammoth.internal.xml.XmlElement;

public class DocumentXmlReader {
    private final BodyXmlReader bodyReader;
    private final Notes notes;
    private final List<Comment> comments;

    public DocumentXmlReader(BodyXmlReader bodyReader, Notes notes, List<Comment> comments) {
        this.bodyReader = bodyReader;
        this.notes = notes;
        this.comments = comments;
    }

    public InternalResult<Document> readElement(XmlElement element) {
        Optional<XmlElement> body = element.findChild("w:body");
        if (!body.isPresent()) {
            throw new IllegalArgumentException("Could not find the body element: are you sure this is a docx file?");
        }
        return this.bodyReader.readElements(body.get().getChildren()).toResult().map(children -> new Document((List<DocumentElement>)children, this.notes, this.comments));
    }
}

