/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.conversion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.zwobble.mammoth.internal.conversion.DocumentToHtmlOptions;
import org.zwobble.mammoth.internal.conversion.InternalImageConverter;
import org.zwobble.mammoth.internal.documents.Bookmark;
import org.zwobble.mammoth.internal.documents.Break;
import org.zwobble.mammoth.internal.documents.Checkbox;
import org.zwobble.mammoth.internal.documents.Comment;
import org.zwobble.mammoth.internal.documents.CommentReference;
import org.zwobble.mammoth.internal.documents.Document;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.documents.DocumentElementVisitor;
import org.zwobble.mammoth.internal.documents.HasChildren;
import org.zwobble.mammoth.internal.documents.Hyperlink;
import org.zwobble.mammoth.internal.documents.Image;
import org.zwobble.mammoth.internal.documents.Note;
import org.zwobble.mammoth.internal.documents.NoteReference;
import org.zwobble.mammoth.internal.documents.NoteType;
import org.zwobble.mammoth.internal.documents.Paragraph;
import org.zwobble.mammoth.internal.documents.Run;
import org.zwobble.mammoth.internal.documents.Tab;
import org.zwobble.mammoth.internal.documents.Table;
import org.zwobble.mammoth.internal.documents.TableCell;
import org.zwobble.mammoth.internal.documents.TableRow;
import org.zwobble.mammoth.internal.documents.Text;
import org.zwobble.mammoth.internal.documents.VerticalAlignment;
import org.zwobble.mammoth.internal.html.Html;
import org.zwobble.mammoth.internal.html.HtmlNode;
import org.zwobble.mammoth.internal.results.InternalResult;
import org.zwobble.mammoth.internal.styles.HtmlPath;
import org.zwobble.mammoth.internal.styles.StyleMap;
import org.zwobble.mammoth.internal.util.Casts;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.util.Maps;

public class DocumentToHtml {
    private final String idPrefix;
    private final boolean preserveEmptyParagraphs;
    private final StyleMap styleMap;
    private final InternalImageConverter imageConverter;
    private final Map<String, Comment> comments;
    private final List<NoteReference> noteReferences = new ArrayList<NoteReference>();
    private final List<ReferencedComment> referencedComments = new ArrayList<ReferencedComment>();
    private final Set<String> warnings = new HashSet<String>();
    private static final Context INITIAL_CONTEXT = new Context(false);

    public static InternalResult<List<HtmlNode>> convertToHtml(Document document, DocumentToHtmlOptions options) {
        DocumentToHtml documentConverter = new DocumentToHtml(options, document.getComments());
        return new InternalResult<List<HtmlNode>>(documentConverter.convertToHtml(document, INITIAL_CONTEXT), documentConverter.warnings);
    }

    private static List<Note> findNotes(Document document, Iterable<NoteReference> noteReferences) {
        return Lists.eagerMap(noteReferences, reference -> document.getNotes().findNote(reference.getNoteType(), reference.getNoteId()).get());
    }

    public static InternalResult<List<HtmlNode>> convertToHtml(DocumentElement element, DocumentToHtmlOptions options) {
        DocumentToHtml documentConverter = new DocumentToHtml(options, Lists.list());
        return new InternalResult<List<HtmlNode>>(documentConverter.convertToHtml(element, INITIAL_CONTEXT), documentConverter.warnings);
    }

    private DocumentToHtml(DocumentToHtmlOptions options, List<Comment> comments) {
        this.idPrefix = options.idPrefix();
        this.preserveEmptyParagraphs = options.shouldPreserveEmptyParagraphs();
        this.styleMap = options.styleMap();
        this.imageConverter = options.imageConverter();
        this.comments = Maps.toMapWithKey(comments, Comment::getCommentId);
    }

    private List<HtmlNode> convertToHtml(Document document, Context context) {
        List<HtmlNode> mainBody = this.convertChildrenToHtml(document, context);
        List<Note> notes = DocumentToHtml.findNotes(document, this.noteReferences);
        List noteNodes = notes.isEmpty() ? Lists.list() : Lists.list(Html.element("ol", Lists.eagerMap(notes, note -> this.convertToHtml((Note)note, context))));
        List commentNodes = this.referencedComments.isEmpty() ? Lists.list() : Lists.list(Html.element("dl", Lists.eagerFlatMap(this.referencedComments, comment -> this.convertToHtml((ReferencedComment)comment, context))));
        return Lists.eagerConcat(mainBody, noteNodes, commentNodes);
    }

    private HtmlNode convertToHtml(Note note, Context context) {
        String id = this.generateNoteHtmlId(note.getNoteType(), note.getId());
        String referenceId = this.generateNoteRefHtmlId(note.getNoteType(), note.getId());
        List<HtmlNode> noteBody = this.convertToHtml(note.getBody(), context);
        HtmlNode backLink = Html.collapsibleElement("p", Lists.list(Html.text(" "), Html.element("a", Maps.map("href", "#" + referenceId), Lists.list(Html.text("\u2191")))));
        return Html.element("li", Maps.map("id", id), Lists.eagerConcat(noteBody, Lists.list(backLink)));
    }

    private List<HtmlNode> convertToHtml(ReferencedComment referencedComment, Context context) {
        String commentId = referencedComment.comment.getCommentId();
        List<HtmlNode> body = this.convertToHtml(referencedComment.comment.getBody(), context);
        HtmlNode backLink = Html.collapsibleElement("p", Lists.list(Html.text(" "), Html.element("a", Maps.map("href", "#" + this.generateReferenceHtmlId("comment", commentId)), Lists.list(Html.text("\u2191")))));
        return Lists.list(Html.element("dt", Maps.map("id", this.generateReferentHtmlId("comment", commentId)), Lists.list(Html.text("Comment " + referencedComment.label))), Html.element("dd", Lists.eagerConcat(body, Lists.list(backLink))));
    }

    private List<HtmlNode> convertToHtml(List<DocumentElement> elements, Context context) {
        return Lists.eagerFlatMap(elements, element -> this.convertToHtml((DocumentElement)element, context));
    }

    private List<HtmlNode> convertChildrenToHtml(HasChildren element, Context context) {
        return this.convertToHtml(element.getChildren(), context);
    }

    private List<HtmlNode> convertToHtml(DocumentElement element, Context context) {
        return element.accept(new ElementConverterVisitor(), context);
    }

    private String generateNoteHtmlId(NoteType noteType, String noteId) {
        return this.generateReferentHtmlId(this.noteTypeToIdFragment(noteType), noteId);
    }

    private String generateNoteRefHtmlId(NoteType noteType, String noteId) {
        return this.generateReferenceHtmlId(this.noteTypeToIdFragment(noteType), noteId);
    }

    private String generateReferentHtmlId(String referenceType, String referenceId) {
        return this.generateId(referenceType + "-" + referenceId);
    }

    private String generateReferenceHtmlId(String referenceType, String referenceId) {
        return this.generateId(referenceType + "-ref-" + referenceId);
    }

    private String noteTypeToIdFragment(NoteType noteType) {
        switch (noteType) {
            case FOOTNOTE: {
                return "footnote";
            }
            case ENDNOTE: {
                return "endnote";
            }
        }
        throw new UnsupportedOperationException();
    }

    private String generateId(String bookmarkName) {
        return this.idPrefix + bookmarkName;
    }

    private static class Context {
        private final boolean isHeader;

        Context(boolean isHeader) {
            this.isHeader = isHeader;
        }

        Context isHeader(boolean isHeader) {
            return new Context(isHeader);
        }
    }

    private static class ReferencedComment {
        private final String label;
        private final Comment comment;

        private ReferencedComment(String label, Comment comment) {
            this.label = label;
            this.comment = comment;
        }
    }

    private class ElementConverterVisitor
    implements DocumentElementVisitor<List<HtmlNode>, Context> {
        private ElementConverterVisitor() {
        }

        @Override
        public List<HtmlNode> visit(Paragraph paragraph, Context context) {
            Supplier<List<HtmlNode>> children = () -> {
                List<HtmlNode> content = DocumentToHtml.this.convertChildrenToHtml(paragraph, context);
                return DocumentToHtml.this.preserveEmptyParagraphs ? Lists.cons(Html.FORCE_WRITE, content) : content;
            };
            HtmlPath mapping = DocumentToHtml.this.styleMap.getParagraphHtmlPath(paragraph).orElseGet(() -> {
                if (paragraph.getStyle().isPresent()) {
                    DocumentToHtml.this.warnings.add("Unrecognised paragraph style: " + paragraph.getStyle().get().describe());
                }
                return HtmlPath.element("p");
            });
            return mapping.wrap(children).get();
        }

        @Override
        public List<HtmlNode> visit(Run run, Context context) {
            Supplier<List<HtmlNode>> nodes = () -> DocumentToHtml.this.convertChildrenToHtml(run, context);
            if (run.getHighlight().isPresent()) {
                nodes = DocumentToHtml.this.styleMap.getHighlightHtmlPath(run.getHighlight().get()).orElse(HtmlPath.EMPTY).wrap(nodes);
            }
            if (run.isSmallCaps()) {
                nodes = DocumentToHtml.this.styleMap.getSmallCaps().orElse(HtmlPath.EMPTY).wrap(nodes);
            }
            if (run.isAllCaps()) {
                nodes = DocumentToHtml.this.styleMap.getAllCaps().orElse(HtmlPath.EMPTY).wrap(nodes);
            }
            if (run.isStrikethrough()) {
                nodes = DocumentToHtml.this.styleMap.getStrikethrough().orElse(HtmlPath.collapsibleElement("s")).wrap(nodes);
            }
            if (run.isUnderline()) {
                nodes = DocumentToHtml.this.styleMap.getUnderline().orElse(HtmlPath.EMPTY).wrap(nodes);
            }
            if (run.getVerticalAlignment() == VerticalAlignment.SUBSCRIPT) {
                nodes = HtmlPath.collapsibleElement("sub").wrap(nodes);
            }
            if (run.getVerticalAlignment() == VerticalAlignment.SUPERSCRIPT) {
                nodes = HtmlPath.collapsibleElement("sup").wrap(nodes);
            }
            if (run.isItalic()) {
                nodes = DocumentToHtml.this.styleMap.getItalic().orElse(HtmlPath.collapsibleElement("em")).wrap(nodes);
            }
            if (run.isBold()) {
                nodes = DocumentToHtml.this.styleMap.getBold().orElse(HtmlPath.collapsibleElement("strong")).wrap(nodes);
            }
            HtmlPath mapping = DocumentToHtml.this.styleMap.getRunHtmlPath(run).orElseGet(() -> {
                if (run.getStyle().isPresent()) {
                    DocumentToHtml.this.warnings.add("Unrecognised run style: " + run.getStyle().get().describe());
                }
                return HtmlPath.EMPTY;
            });
            return mapping.wrap(nodes).get();
        }

        @Override
        public List<HtmlNode> visit(Text text, Context context) {
            if (text.getValue().isEmpty()) {
                return Lists.list();
            }
            return Lists.list(Html.text(text.getValue()));
        }

        @Override
        public List<HtmlNode> visit(Tab tab, Context context) {
            return Lists.list(Html.text("\t"));
        }

        @Override
        public List<HtmlNode> visit(Break breakElement, Context context) {
            HtmlPath mapping = DocumentToHtml.this.styleMap.getBreakHtmlPath(breakElement).orElseGet(() -> {
                if (breakElement.getType() == Break.Type.LINE) {
                    return HtmlPath.element("br");
                }
                return HtmlPath.EMPTY;
            });
            return mapping.wrap(() -> Lists.list()).get();
        }

        @Override
        public List<HtmlNode> visit(Table table, Context context) {
            HtmlPath mapping = DocumentToHtml.this.styleMap.getTableHtmlPath(table).orElse(HtmlPath.element("table"));
            return mapping.wrap(() -> this.generateTableChildren(table, context)).get();
        }

        private List<HtmlNode> generateTableChildren(Table table, Context context) {
            int bodyIndex = Iterables.findIndex(table.getChildren(), child -> !this.isHeader((DocumentElement)child)).orElse(table.getChildren().size());
            if (bodyIndex == 0) {
                return DocumentToHtml.this.convertToHtml(table.getChildren(), context.isHeader(false));
            }
            List headRows = DocumentToHtml.this.convertToHtml(table.getChildren().subList(0, bodyIndex), context.isHeader(true));
            List bodyRows = DocumentToHtml.this.convertToHtml(table.getChildren().subList(bodyIndex, table.getChildren().size()), context.isHeader(false));
            return Lists.list(Html.element("thead", headRows), Html.element("tbody", bodyRows));
        }

        private boolean isHeader(DocumentElement child) {
            return Casts.tryCast(TableRow.class, child).map(TableRow::isHeader).orElse(false);
        }

        @Override
        public List<HtmlNode> visit(TableRow tableRow, Context context) {
            return Lists.list(Html.element("tr", Lists.cons(Html.FORCE_WRITE, DocumentToHtml.this.convertChildrenToHtml(tableRow, context))));
        }

        @Override
        public List<HtmlNode> visit(TableCell tableCell, Context context) {
            String tagName = context.isHeader ? "th" : "td";
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (tableCell.getColspan() != 1) {
                attributes.put("colspan", Integer.toString(tableCell.getColspan()));
            }
            if (tableCell.getRowspan() != 1) {
                attributes.put("rowspan", Integer.toString(tableCell.getRowspan()));
            }
            return Lists.list(Html.element(tagName, attributes, Lists.cons(Html.FORCE_WRITE, DocumentToHtml.this.convertChildrenToHtml(tableCell, context))));
        }

        @Override
        public List<HtmlNode> visit(Hyperlink hyperlink, Context context) {
            Map<String, String> attributes = Maps.mutableMap("href", this.generateHref(hyperlink));
            hyperlink.getTargetFrame().ifPresent(targetFrame -> attributes.put("target", (String)targetFrame));
            return Lists.list(Html.collapsibleElement("a", attributes, (List<HtmlNode>)DocumentToHtml.this.convertChildrenToHtml(hyperlink, context)));
        }

        private String generateHref(Hyperlink hyperlink) {
            if (hyperlink.getHref().isPresent()) {
                return hyperlink.getHref().get();
            }
            if (hyperlink.getAnchor().isPresent()) {
                return "#" + DocumentToHtml.this.generateId(hyperlink.getAnchor().get());
            }
            return "";
        }

        @Override
        public List<HtmlNode> visit(Checkbox checkbox, Context context) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("type", "checkbox");
            if (checkbox.checked()) {
                attributes.put("checked", "checked");
            }
            return Lists.list(Html.element("input", attributes));
        }

        @Override
        public List<HtmlNode> visit(Bookmark bookmark, Context context) {
            return Lists.list(Html.element("a", Maps.map("id", DocumentToHtml.this.generateId(bookmark.getName())), Lists.list(Html.FORCE_WRITE)));
        }

        @Override
        public List<HtmlNode> visit(NoteReference noteReference, Context context) {
            DocumentToHtml.this.noteReferences.add(noteReference);
            String noteAnchor = DocumentToHtml.this.generateNoteHtmlId(noteReference.getNoteType(), noteReference.getNoteId());
            String noteReferenceAnchor = DocumentToHtml.this.generateNoteRefHtmlId(noteReference.getNoteType(), noteReference.getNoteId());
            return Lists.list(Html.element("sup", Lists.list(Html.element("a", Maps.map("href", "#" + noteAnchor, "id", noteReferenceAnchor), Lists.list(Html.text("[" + DocumentToHtml.this.noteReferences.size() + "]"))))));
        }

        @Override
        public List<HtmlNode> visit(CommentReference commentReference, Context context) {
            return DocumentToHtml.this.styleMap.getCommentReference().orElse(HtmlPath.IGNORE).wrap(() -> {
                String commentId = commentReference.getCommentId();
                Comment comment = (Comment)Maps.lookup(DocumentToHtml.this.comments, commentId).orElseThrow(() -> new RuntimeException("Referenced comment could not be found, id: " + commentId));
                String label = "[" + comment.getAuthorInitials().orElse("") + (DocumentToHtml.this.referencedComments.size() + 1) + "]";
                DocumentToHtml.this.referencedComments.add(new ReferencedComment(label, comment));
                return Lists.list(Html.element("a", Maps.map("href", "#" + DocumentToHtml.this.generateReferentHtmlId("comment", commentId), "id", DocumentToHtml.this.generateReferenceHtmlId("comment", commentId)), Lists.list(Html.text(label))));
            }).get();
        }

        @Override
        public List<HtmlNode> visit(Image image, Context context) {
            try {
                return DocumentToHtml.this.imageConverter.convert(image);
            }
            catch (IOException exception) {
                DocumentToHtml.this.warnings.add(exception.getMessage());
                return Lists.list();
            }
        }
    }
}

