/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.archives;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.zwobble.mammoth.internal.archives.Archive;

public class ZippedArchive
implements Archive {
    private final ZipFile zipFile;

    public ZippedArchive(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public ZippedArchive(File file) throws IOException {
        this(new ZipFile(file));
    }

    @Override
    public Optional<InputStream> tryGetInputStream(String name) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(name);
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(this.zipFile.getInputStream(entry));
    }

    @Override
    public boolean exists(String name) {
        return this.zipFile.getEntry(name) != null;
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }
}

