/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.zwobble.mammoth.Result;
import org.zwobble.mammoth.images.ImageConverter;
import org.zwobble.mammoth.internal.InternalDocumentConverter;
import org.zwobble.mammoth.internal.conversion.DocumentToHtmlOptions;

public class DocumentConverter {
    private final DocumentToHtmlOptions options;

    public DocumentConverter() {
        this(DocumentToHtmlOptions.DEFAULT);
    }

    private DocumentConverter(DocumentToHtmlOptions options) {
        this.options = options;
    }

    public DocumentConverter idPrefix(String idPrefix) {
        return new DocumentConverter(this.options.idPrefix(idPrefix));
    }

    public DocumentConverter preserveEmptyParagraphs() {
        return new DocumentConverter(this.options.preserveEmptyParagraphs());
    }

    public DocumentConverter addStyleMap(String styleMap) {
        return new DocumentConverter(this.options.addStyleMap(styleMap));
    }

    public DocumentConverter disableDefaultStyleMap() {
        return new DocumentConverter(this.options.disableDefaultStyleMap());
    }

    public DocumentConverter disableEmbeddedStyleMap() {
        return new DocumentConverter(this.options.disableEmbeddedStyleMap());
    }

    public DocumentConverter imageConverter(ImageConverter.ImgElement imageConverter) {
        return new DocumentConverter(this.options.imageConverter(imageConverter));
    }

    public Result<String> convertToHtml(InputStream stream) throws IOException {
        return new InternalDocumentConverter(this.options).convertToHtml(stream).toResult();
    }

    public Result<String> convertToHtml(File file) throws IOException {
        return new InternalDocumentConverter(this.options).convertToHtml(file).toResult();
    }

    public Result<String> extractRawText(InputStream stream) throws IOException {
        return new InternalDocumentConverter(this.options).extractRawText(stream).toResult();
    }

    public Result<String> extractRawText(File file) throws IOException {
        return new InternalDocumentConverter(this.options).extractRawText(file).toResult();
    }
}

