/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.model.test.ModelTestParser;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.junit.Assert;

public final class TestParser
implements ModelTestParser {
    final ExtensionRegistry extensionRegistry;
    final String mainSubsystemName;

    public TestParser(String mainSubsystemName, ExtensionRegistry extensionRegistry) {
        this.mainSubsystemName = mainSubsystemName;
        this.extensionRegistry = extensionRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        String defaultNamespace = writer.getNamespaceContext().getNamespaceURI("");
        try {
            ModelNode subsystems = context.getModelNode().get("subsystem");
            if (subsystems.has(this.mainSubsystemName)) {
                ModelNode subsystem = subsystems.get(this.mainSubsystemName);
                XMLElementWriter subsystemWriter = context.getSubsystemWriter(this.mainSubsystemName);
                if (subsystemWriter != null) {
                    subsystemWriter.writeContent(writer, (Object)new SubsystemMarshallingContext(subsystem, writer));
                }
            } else {
                writer.writeEmptyElement(Element.SUBSYSTEM.getLocalName());
            }
        }
        catch (Throwable t) {
            Assert.fail((String)("could not marshal subsystem xml: " + t.getMessage() + ":\n" + Arrays.toString(t.getStackTrace()).replaceAll(", ", "\n")));
        }
        finally {
            writer.setDefaultNamespace(defaultNamespace);
        }
        writer.writeEndDocument();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        LinkedHashMap profileOps = new LinkedHashMap();
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (Namespace.forUri((String)reader.getNamespaceURI()) != Namespace.UNKNOWN) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (Element.forName((String)reader.getLocalName()) != Element.SUBSYSTEM) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            String namespace = reader.getNamespaceURI();
            if (profileOps.containsKey(namespace)) {
                throw ControllerLogger.ROOT_LOGGER.duplicateDeclaration("subsystem", reader.getLocation());
            }
            ArrayList subsystems = new ArrayList();
            reader.handleAny(subsystems);
            profileOps.put(namespace, subsystems);
        }
        Set completionHandlers = this.extensionRegistry.getProfileParsingCompletionHandlers();
        for (ProfileParsingCompletionHandler completionHandler : completionHandlers) {
            completionHandler.handleProfileParsingCompletion(profileOps, operations);
        }
        for (List subsystems : profileOps.values()) {
            operations.addAll(subsystems);
        }
    }
}

