/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import java.util.Arrays;
import java.util.Optional;

public enum LoginValue {
    PARAM_LOGIN_USERNAME("lgname", "username", ""),
    PARAM_LOGIN_PASSWORD("lgpassword", "password", ""),
    PARAM_LOGIN_TOKEN("lgtoken", "logintoken", ""),
    LOGIN_RESULT_SUCCESS("Success", "PASS", ""),
    LOGIN_WRONG_PASS("WrongPass", "wrongpassword", "Wrong Password."),
    FAILED("Failed", "failed", "Something went wrong"),
    LOGIN_WRONG_PLUGIN_PASS("WrongPluginPass", "wrongpluginpass", "Wrong Password. An authentication plugin rejected the password."),
    LOGIN_NO_NAME("NoName", "authmanager-authn-no-primary", "No user name given."),
    LOGIN_NOT_EXISTS("NotExists", "wrongpassword", "Username does not exist."),
    LOGIN_ILLEGAL("Illegal", "wrongpassword", "Username is illegal."),
    LOGIN_THROTTLED("Throttled", "throttled", "Too many login attempts in a short time."),
    LOGIN_EMPTY_PASS("EmptyPass", "authmanager-authn-no-primary", "Password is empty."),
    LOGIN_CREATE_BLOCKED("CreateBlocked", "createblocked", "The wiki tried to automatically create a new account for you, but your IP address has been blocked from account creation."),
    LOGIN_BLOCKED("Blocked", "blocked", "User is blocked."),
    LOGIN_NEEDTOKEN("NeedToken", "missingparam", "Token or session ID is missing."),
    LOGIN_WRONG_TOKEN("WrongToken", "badtoken", "Token is wrong."),
    UNKNOWN("unknown", "unknown", "Error text not recognized");

    private final String loginText;
    private final String clientLoginText;
    private final String message;

    private LoginValue(String loginText, String clientLoginText, String message) {
        this.loginText = loginText;
        this.clientLoginText = clientLoginText;
        this.message = message;
    }

    public static LoginValue of(String text) {
        Optional<LoginValue> optionalLoginValue = Arrays.stream(LoginValue.values()).filter(loginValue -> text != null && (text.equals(loginValue.loginText) || text.equals(loginValue.clientLoginText))).findFirst();
        return optionalLoginValue.orElse(UNKNOWN);
    }

    public String getLoginText() {
        return this.loginText;
    }

    public String getClientLoginText() {
        return this.clientLoginText;
    }

    public String getMessage(String loginType) {
        return loginType + ": " + this.message;
    }
}

