/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.webjars.MavenProperties;
import org.webjars.MultipleMatchesException;
import org.webjars.NotFoundException;

public class WebJarAssetLocator {
    public static final String WEBJARS_PACKAGE = "META-INF.resources.webjars";
    public static final String WEBJARS_PATH_PREFIX = "META-INF/resources/webjars";
    private static final Pattern WEBJAR_EXTRACTOR_PATTERN = Pattern.compile("META-INF/resources/webjars/([^/]*)/([^/]*)/(.*)$");
    protected final Map<String, WebJarInfo> allWebJars;

    public Map<String, WebJarInfo> getAllWebJars() {
        return this.allWebJars;
    }

    @Nonnull
    protected static ResourceList webJarResources(@Nonnull String webJarName, @Nonnull ResourceList resources) {
        if (WebJarAssetLocator.isEmpty(webJarName)) {
            throw new IllegalArgumentException("WebJar name must not be null or empty");
        }
        Objects.requireNonNull(resources, "Resources must not be null");
        return resources.filter(resource -> resource.getPath().startsWith(String.format("%s/%s/", WEBJARS_PATH_PREFIX, webJarName)));
    }

    @Nullable
    protected static String webJarVersion(@Nullable String webJarName, @Nonnull ResourceList resources) {
        if (WebJarAssetLocator.isEmpty(webJarName)) {
            return null;
        }
        if (resources.isEmpty()) {
            return null;
        }
        String aPath = ((Resource)resources.get(0)).getPath();
        String prefix = String.format("%s/%s/", WEBJARS_PATH_PREFIX, webJarName);
        if (aPath.startsWith(prefix)) {
            try {
                String withoutName = aPath.substring(prefix.length());
                String maybeVersion = withoutName.substring(0, withoutName.indexOf(47));
                ResourceList withMaybeVersion = resources.filter(resource -> resource.getPath().startsWith(String.format("%s%s/", prefix, maybeVersion)));
                if (withMaybeVersion.size() == resources.size()) {
                    return maybeVersion;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static Optional<MavenProperties> findMavenInfo(@Nullable URI classpathElementURI) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    protected static Map<String, WebJarInfo> findWebJars(@Nonnull ScanResult scanResult) {
        Objects.requireNonNull(scanResult, "Scan result must not be null");
        ResourceList allResources = scanResult.getAllResources();
        HashMap<String, WebJarInfo> webJars = new HashMap<String, WebJarInfo>(allResources.size());
        for (Resource resource : allResources) {
            String noPrefix = resource.getPath().substring(WEBJARS_PATH_PREFIX.length() + 1);
            String webJarName = noPrefix.substring(0, noPrefix.indexOf(47));
            if (webJars.containsKey(webJarName)) continue;
            ResourceList webJarResources = WebJarAssetLocator.webJarResources(webJarName, allResources);
            String maybeWebJarVersion = WebJarAssetLocator.webJarVersion(webJarName, webJarResources);
            Optional<MavenProperties> mavenProperties = WebJarAssetLocator.findMavenInfo(resource.getClasspathElementURI());
            Collection<String> paths = Collections.unmodifiableCollection(new HashSet(webJarResources.getPaths()));
            webJars.put(webJarName, new WebJarInfo(maybeWebJarVersion, mavenProperties, resource.getClasspathElementURI(), paths));
        }
        return webJars;
    }

    @Nullable
    public static Map.Entry<String, String> getWebJar(@Nonnull CharSequence path) {
        Objects.requireNonNull(path, "Path must not be null");
        Matcher matcher = WEBJAR_EXTRACTOR_PATTERN.matcher(path);
        if (matcher.find()) {
            String id = matcher.group(1);
            String version = matcher.group(2);
            return new AbstractMap.SimpleEntry<String, String>(id, version);
        }
        return null;
    }

    @Nonnull
    private static Map<String, WebJarInfo> scanForWebJars(@Nonnull ClassGraph classGraph) {
        Objects.requireNonNull(classGraph, "Class graph must not be null");
        try (ScanResult scanResult = classGraph.acceptPaths(new String[]{WEBJARS_PATH_PREFIX}).scan();){
            Map<String, WebJarInfo> map = WebJarAssetLocator.findWebJars(scanResult);
            return map;
        }
    }

    public WebJarAssetLocator() {
        this(new ClassGraph());
    }

    public WebJarAssetLocator(@Nullable ClassLoader classLoader) {
        this(new ClassGraph().overrideClassLoaders(new ClassLoader[]{classLoader}).ignoreParentClassLoaders());
    }

    public WebJarAssetLocator(String ... whitelistPaths) {
        this(new ClassGraph().acceptPaths(whitelistPaths));
    }

    public WebJarAssetLocator(@Nullable ClassLoader classLoader, String ... whitelistPaths) {
        this(new ClassGraph().overrideClassLoaders(new ClassLoader[]{classLoader}).ignoreParentClassLoaders().acceptPaths(whitelistPaths));
    }

    public WebJarAssetLocator(ClassGraph classGraph) {
        this(WebJarAssetLocator.scanForWebJars(classGraph));
    }

    public WebJarAssetLocator(@Nonnull Map<String, WebJarInfo> allWebJars) {
        this.allWebJars = allWebJars;
    }

    @Nonnull
    public String getFullPath(@Nonnull String partialPath) {
        if (WebJarAssetLocator.isEmpty(partialPath)) {
            throw new IllegalArgumentException("Partial path must not be null or empty");
        }
        ArrayList<String> paths = new ArrayList<String>(this.allWebJars.size());
        for (String webJarName : this.allWebJars.keySet()) {
            try {
                paths.add(this.getFullPath(webJarName, partialPath));
            }
            catch (NotFoundException notFoundException) {}
        }
        if (paths.isEmpty()) {
            WebJarAssetLocator.throwNotFoundException(partialPath);
        } else if (paths.size() > 1) {
            WebJarAssetLocator.throwMultipleMatchesException(partialPath, paths);
        }
        return (String)paths.get(0);
    }

    @Nonnull
    public String getFullPath(@Nonnull String webjar, @Nonnull String partialPath) {
        if (WebJarAssetLocator.isEmpty(webjar)) {
            throw new IllegalArgumentException("WebJar ID must not be null or empty");
        }
        if (WebJarAssetLocator.isEmpty(partialPath)) {
            throw new IllegalArgumentException("Partial path must not be null or empty");
        }
        if (this.allWebJars.containsKey(webjar)) {
            List<String> paths = this.allWebJars.get(webjar).getContents().stream().filter(path -> path.endsWith(partialPath)).collect(Collectors.toList());
            if (paths.isEmpty()) {
                WebJarAssetLocator.throwNotFoundException(partialPath);
            }
            if (paths.size() > 1) {
                WebJarAssetLocator.throwMultipleMatchesException(partialPath, paths);
            }
            return paths.get(0);
        }
        throw new NotFoundException(String.format("WebJar with id %s not found", webjar));
    }

    @Nullable
    public String getFullPathExact(@Nonnull String webJarName, @Nullable String exactPath) {
        if (WebJarAssetLocator.isEmpty(webJarName)) {
            throw new IllegalArgumentException("WebJar ID must not be null or empty");
        }
        if (WebJarAssetLocator.isEmpty(exactPath)) {
            return null;
        }
        WebJarInfo webJarInfo = this.allWebJars.get(webJarName);
        if (webJarInfo == null || webJarInfo.getContents().isEmpty()) {
            return null;
        }
        String version = webJarInfo.getVersion();
        String fullPath = WebJarAssetLocator.isEmpty(version) ? String.format("%s/%s/%s", WEBJARS_PATH_PREFIX, webJarName, exactPath) : String.format("%s/%s/%s/%s", WEBJARS_PATH_PREFIX, webJarName, version, exactPath);
        if (webJarInfo.getContents().contains(fullPath)) {
            return fullPath;
        }
        return null;
    }

    @Nonnull
    public Set<String> listAssets() {
        return this.listAssets("");
    }

    @Nonnull
    public Set<String> listAssets(@Nonnull String folderPath) {
        Objects.requireNonNull(folderPath, "Folder path must not be null");
        String prefix = String.format("%s%s%s", WEBJARS_PATH_PREFIX, folderPath.startsWith("/") ? "" : "/", folderPath);
        return this.allWebJars.values().stream().flatMap(webJarInfo -> webJarInfo.getContents().stream()).filter(path -> path.startsWith(folderPath) || path.startsWith(prefix)).collect(Collectors.toSet());
    }

    @Nonnull
    public Map<String, String> getWebJars() {
        HashMap<String, String> webJars = new HashMap<String, String>(this.allWebJars.size());
        for (Map.Entry<String, WebJarInfo> entry : this.allWebJars.entrySet()) {
            webJars.put(entry.getKey(), entry.getValue().getVersion());
        }
        return webJars;
    }

    @Nullable
    public String groupId(@Nullable String fullPath) {
        if (WebJarAssetLocator.isEmpty(fullPath)) {
            return null;
        }
        return this.allWebJars.values().stream().filter(webJarInfo -> webJarInfo.getContents().contains(fullPath)).findFirst().map(WebJarInfo::getGroupId).orElse(null);
    }

    private static boolean isEmpty(@Nullable String str) {
        return str == null || str.trim().isEmpty();
    }

    private static void throwNotFoundException(@Nullable String partialPath) {
        throw new NotFoundException(String.format("%s could not be found. Make sure you've added the corresponding WebJar and please check for typos.", partialPath));
    }

    private static void throwMultipleMatchesException(@Nullable String partialPath, @Nullable List<String> matches) {
        throw new MultipleMatchesException(String.format("Multiple matches found for %s. Please provide a more specific path, for example by including a version number.", partialPath), matches);
    }

    public static class WebJarInfo {
        final String version;
        final String groupId;
        final String artifactId;
        final URI uri;
        final Collection<String> contents;

        WebJarInfo(@Nullable String version, Optional<MavenProperties> mavenProperties, URI uri, @Nonnull Collection<String> contents) {
            this.version = version;
            this.groupId = mavenProperties.map(MavenProperties::getGroupId).orElse(null);
            this.artifactId = mavenProperties.map(MavenProperties::getArtifactId).orElse(null);
            this.uri = uri;
            this.contents = contents;
        }

        @Nullable
        public String getVersion() {
            return this.version;
        }

        @Nullable
        public String getGroupId() {
            return this.groupId;
        }

        @Nullable
        public String getArtifactId() {
            return this.artifactId;
        }

        public URI getUri() {
            return this.uri;
        }

        @Nonnull
        public Collection<String> getContents() {
            return this.contents;
        }
    }
}

