/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdependency;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.vafer.jdependency.Clazz;

public final class ClazzpathUnit {
    private final String id;
    private final Map<String, Clazz> clazzes;
    private final Map<String, Clazz> dependencies;

    ClazzpathUnit(String pId, Map<String, Clazz> pClazzes, Map<String, Clazz> pDependencies) {
        this.id = pId;
        this.clazzes = pClazzes;
        this.dependencies = pDependencies;
    }

    public Set<Clazz> getClazzes() {
        HashSet<Clazz> result = new HashSet<Clazz>(this.clazzes.values());
        return result;
    }

    public Clazz getClazz(String pClazzName) {
        Clazz result = this.clazzes.get(pClazzName);
        return result;
    }

    public Set<Clazz> getDependencies() {
        HashSet<Clazz> result = new HashSet<Clazz>(this.dependencies.values());
        return result;
    }

    public Set<Clazz> getTransitiveDependencies() {
        HashSet<Clazz> all = new HashSet<Clazz>();
        for (Clazz clazz : this.clazzes.values()) {
            clazz.findTransitiveDependencies(all);
        }
        return all;
    }

    public String toString() {
        return this.id;
    }
}

