/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SearchHighlight {
    @JsonProperty(value="field")
    private String field = null;
    @JsonProperty(value="snippet")
    private String snippet = null;
    @JsonProperty(value="snippets")
    private List<String> snippets = null;
    @JsonProperty(value="value")
    private String value = null;
    @JsonProperty(value="values")
    private List<String> values = null;
    @JsonProperty(value="indices")
    private List<Integer> indices = null;
    @JsonProperty(value="matched_tokens")
    private List<Object> matchedTokens = null;

    public SearchHighlight field(String field) {
        this.field = field;
        return this;
    }

    @Schema(example="company_name", description="")
    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public SearchHighlight snippet(String snippet) {
        this.snippet = snippet;
        return this;
    }

    @Schema(example="<mark>Stark</mark> Industries", description="Present only for (non-array) string fields")
    public String getSnippet() {
        return this.snippet;
    }

    public void setSnippet(String snippet) {
        this.snippet = snippet;
    }

    public SearchHighlight snippets(List<String> snippets) {
        this.snippets = snippets;
        return this;
    }

    public SearchHighlight addSnippetsItem(String snippetsItem) {
        if (this.snippets == null) {
            this.snippets = new ArrayList<String>();
        }
        this.snippets.add(snippetsItem);
        return this;
    }

    @Schema(example="[\"<mark>Stark</mark> Industries\",\"<mark>Stark</mark> Corp\"]", description="Present only for (array) string[] fields")
    public List<String> getSnippets() {
        return this.snippets;
    }

    public void setSnippets(List<String> snippets) {
        this.snippets = snippets;
    }

    public SearchHighlight value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="<mark>Stark</mark> Industries is a major supplier of space equipment.", description="Full field value with highlighting, present only for (non-array) string fields")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SearchHighlight values(List<String> values) {
        this.values = values;
        return this;
    }

    public SearchHighlight addValuesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Schema(example="[\"<mark>Stark</mark> Industries\",\"<mark>Stark</mark> Corp\"]", description="Full field value with highlighting, present only for (array) string[] fields")
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public SearchHighlight indices(List<Integer> indices) {
        this.indices = indices;
        return this;
    }

    public SearchHighlight addIndicesItem(Integer indicesItem) {
        if (this.indices == null) {
            this.indices = new ArrayList<Integer>();
        }
        this.indices.add(indicesItem);
        return this;
    }

    @Schema(example="1", description="The indices property will be present only for string[] fields and will contain the corresponding indices of the snippets in the search field")
    public List<Integer> getIndices() {
        return this.indices;
    }

    public void setIndices(List<Integer> indices) {
        this.indices = indices;
    }

    public SearchHighlight matchedTokens(List<Object> matchedTokens) {
        this.matchedTokens = matchedTokens;
        return this;
    }

    public SearchHighlight addMatchedTokensItem(Object matchedTokensItem) {
        if (this.matchedTokens == null) {
            this.matchedTokens = new ArrayList<Object>();
        }
        this.matchedTokens.add(matchedTokensItem);
        return this;
    }

    @Schema(description="")
    public List<Object> getMatchedTokens() {
        return this.matchedTokens;
    }

    public void setMatchedTokens(List<Object> matchedTokens) {
        this.matchedTokens = matchedTokens;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchHighlight searchHighlight = (SearchHighlight)o;
        return Objects.equals(this.field, searchHighlight.field) && Objects.equals(this.snippet, searchHighlight.snippet) && Objects.equals(this.snippets, searchHighlight.snippets) && Objects.equals(this.value, searchHighlight.value) && Objects.equals(this.values, searchHighlight.values) && Objects.equals(this.indices, searchHighlight.indices) && Objects.equals(this.matchedTokens, searchHighlight.matchedTokens);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.snippet, this.snippets, this.value, this.values, this.indices, this.matchedTokens);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchHighlight {\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("    snippet: ").append(this.toIndentedString(this.snippet)).append("\n");
        sb.append("    snippets: ").append(this.toIndentedString(this.snippets)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("    indices: ").append(this.toIndentedString(this.indices)).append("\n");
        sb.append("    matchedTokens: ").append(this.toIndentedString(this.matchedTokens)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

