/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.api;

import java.util.HashMap;
import java.util.Map;
import org.typesense.api.ApiCall;
import org.typesense.api.StemmingDictionaries;
import org.typesense.api.StemmingDictionary;

public class Stemming {
    private final ApiCall apiCall;
    private final StemmingDictionaries dictionaries;
    private final Map<String, StemmingDictionary> individualDictionaries;

    public Stemming(ApiCall apiCall) {
        this.apiCall = apiCall;
        this.dictionaries = new StemmingDictionaries(this.apiCall);
        this.individualDictionaries = new HashMap<String, StemmingDictionary>();
    }

    public StemmingDictionaries dictionaries() {
        return this.dictionaries;
    }

    public StemmingDictionary dictionaries(String dictionaryId) {
        if (!this.individualDictionaries.containsKey(dictionaryId)) {
            this.individualDictionaries.put(dictionaryId, new StemmingDictionary(dictionaryId, this.apiCall));
        }
        StemmingDictionary retVal = this.individualDictionaries.get(dictionaryId);
        return retVal;
    }
}

