/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.api;

import java.util.HashMap;
import java.util.Map;
import org.typesense.api.ApiCall;
import org.typesense.api.Configuration;
import org.typesense.api.Document;
import org.typesense.api.Documents;
import org.typesense.api.Override;
import org.typesense.api.Overrides;
import org.typesense.api.Synonym;
import org.typesense.api.Synonyms;
import org.typesense.api.utils.URLEncoding;
import org.typesense.model.CollectionResponse;
import org.typesense.model.CollectionUpdateSchema;

public class Collection {
    private final Configuration configuration;
    private final ApiCall apiCall;
    private final String name;
    private Documents documents;
    private Map<String, Document> individualDocuments;
    private Synonyms synonyms;
    private Map<String, Synonym> individualSynonyms;
    private Overrides overrides;
    private Map<String, Override> individualOverrides;
    private final String endpoint;

    Collection(String name, ApiCall apiCall, Configuration configuration) {
        this.name = name;
        this.apiCall = apiCall;
        this.configuration = configuration;
        this.endpoint = "/collections/" + URLEncoding.encodeURIComponent(this.name);
        this.documents = new Documents(this.name, this.apiCall, this.configuration);
        this.individualDocuments = new HashMap<String, Document>();
        this.synonyms = new Synonyms(this.name, this.apiCall);
        this.individualSynonyms = new HashMap<String, Synonym>();
        this.overrides = new Overrides(this.name, this.apiCall);
        this.individualOverrides = new HashMap<String, Override>();
    }

    public CollectionResponse retrieve() throws Exception {
        return this.apiCall.get(this.endpoint, null, CollectionResponse.class);
    }

    public CollectionUpdateSchema update(CollectionUpdateSchema c) throws Exception {
        return this.apiCall.patch(this.endpoint, c, null, CollectionUpdateSchema.class);
    }

    public CollectionResponse delete() throws Exception {
        return this.apiCall.delete(this.endpoint, null, CollectionResponse.class);
    }

    public Documents documents() {
        return this.documents;
    }

    public Document documents(String documentId) {
        if (!this.individualDocuments.containsKey(documentId)) {
            this.individualDocuments.put(documentId, new Document(this.name, documentId, this.apiCall));
        }
        Document retVal = this.individualDocuments.get(documentId);
        return retVal;
    }

    public Synonyms synonyms() {
        return this.synonyms;
    }

    public Synonym synonyms(String synonymId) {
        if (!this.individualSynonyms.containsKey(synonymId)) {
            this.individualSynonyms.put(synonymId, new Synonym(this.name, synonymId, this.apiCall));
        }
        Synonym retVal = this.individualSynonyms.get(synonymId);
        return retVal;
    }

    public Overrides overrides() {
        return this.overrides;
    }

    public Override overrides(String overrideId) {
        if (!this.individualOverrides.containsKey(overrideId)) {
            this.individualOverrides.put(overrideId, new Override(this.name, overrideId, this.apiCall));
        }
        Override retVal = this.individualOverrides.get(overrideId);
        return retVal;
    }
}

