/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typesense.api.Configuration;
import org.typesense.api.exceptions.HttpError;
import org.typesense.api.exceptions.ObjectAlreadyExists;
import org.typesense.api.exceptions.ObjectNotFound;
import org.typesense.api.exceptions.ObjectUnprocessable;
import org.typesense.api.exceptions.RequestForbidden;
import org.typesense.api.exceptions.RequestMalformed;
import org.typesense.api.exceptions.RequestUnauthorized;
import org.typesense.api.exceptions.ServerError;
import org.typesense.api.exceptions.ServiceUnavailable;
import org.typesense.api.exceptions.TypesenseError;
import org.typesense.model.ErrorResponse;
import org.typesense.resources.Node;

public class ApiCall {
    private final Configuration configuration;
    private final List<Node> nodes;
    private static int nodeIndex = 0;
    private static final String API_KEY_HEADER = "X-TYPESENSE-API-KEY";
    private static final Logger logger = LoggerFactory.getLogger(ApiCall.class);
    private final OkHttpClient client;
    private final String apiKey;
    private final Duration retryInterval;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final ObjectMapper mapper = new ObjectMapper();

    public ApiCall(Configuration configuration, OkHttpClient client) {
        this.configuration = configuration;
        this.nodes = configuration.nodes;
        this.apiKey = configuration.apiKey;
        this.retryInterval = configuration.retryInterval;
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.client = client;
    }

    public ApiCall(Configuration configuration) {
        this.configuration = configuration;
        this.nodes = configuration.nodes;
        this.apiKey = configuration.apiKey;
        this.retryInterval = configuration.retryInterval;
        nodeIndex = 0;
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.client = new OkHttpClient().newBuilder().connectTimeout(configuration.connectionTimeout.getSeconds(), TimeUnit.SECONDS).readTimeout(configuration.readTimeout.getSeconds(), TimeUnit.SECONDS).build();
    }

    boolean isDueForHealthCheck(Node node) {
        return Duration.between(node.lastAccessTimestamp, LocalDateTime.now()).getSeconds() > this.configuration.healthCheckInterval.getSeconds();
    }

    Node getNode() {
        if (this.configuration.nearestNode != null && (this.isDueForHealthCheck(this.configuration.nearestNode) || this.configuration.nearestNode.isHealthy)) {
            return this.configuration.nearestNode;
        }
        for (int i = 0; i < this.configuration.nodes.size(); ++i) {
            nodeIndex = (nodeIndex + 1) % this.configuration.nodes.size();
            Node testNode = this.configuration.nodes.get(nodeIndex);
            if (!testNode.isHealthy && !this.isDueForHealthCheck(testNode)) continue;
            return testNode;
        }
        return this.configuration.nodes.get(nodeIndex);
    }

    void setNodeHealthStatus(Node node, boolean status) {
        node.isHealthy = status;
        node.lastAccessTimestamp = LocalDateTime.now();
    }

    private TypesenseError getException(Response response) throws IOException {
        ErrorResponse errorResponse = (ErrorResponse)this.mapper.readValue(response.body().string(), ErrorResponse.class);
        String message = errorResponse.getMessage();
        int status_code = response.code();
        if (status_code == 400) {
            return new RequestMalformed(message, status_code);
        }
        if (status_code == 401) {
            return new RequestUnauthorized(message, status_code);
        }
        if (status_code == 403) {
            return new RequestForbidden(message, status_code);
        }
        if (status_code == 404) {
            return new ObjectNotFound(message, status_code);
        }
        if (status_code == 409) {
            return new ObjectAlreadyExists(message, status_code);
        }
        if (status_code == 422) {
            return new ObjectUnprocessable(message, status_code);
        }
        if (status_code == 500) {
            return new ServerError(message, status_code);
        }
        if (status_code == 503) {
            return new ServiceUnavailable(message, status_code);
        }
        return new HttpError(message, status_code);
    }

    <Q, R> R get(String endpoint, Q queryParameters, Class<R> responseClass) throws Exception {
        Request.Builder rb = new Request.Builder().get();
        return this.makeRequest(endpoint, queryParameters, rb, responseClass);
    }

    <B, Q, R> R put(String endpoint, B body, Q queryParameters, Class<R> responseClass) throws Exception {
        RequestBody requestBody = RequestBody.create((String)this.mapper.writeValueAsString(body), (MediaType)JSON);
        Request.Builder rb = new Request.Builder().put(requestBody);
        return this.makeRequest(endpoint, queryParameters, rb, responseClass);
    }

    <B, Q, R> R patch(String endpoint, B body, Q queryParameters, Class<R> responseClass) throws Exception {
        RequestBody requestBody = RequestBody.create((String)this.mapper.writeValueAsString(body), (MediaType)JSON);
        Request.Builder rb = new Request.Builder().patch(requestBody);
        return this.makeRequest(endpoint, queryParameters, rb, responseClass);
    }

    <B, Q, R> R post(String endpoint, B body, Q queryParameters, Class<R> responseClass) throws Exception {
        RequestBody requestBody = RequestBody.create((String)this.mapper.writeValueAsString(body), (MediaType)JSON);
        Request.Builder rb = new Request.Builder().post(requestBody);
        return this.makeRequest(endpoint, queryParameters, rb, responseClass);
    }

    <Q, R> R post(String endpoint, String body, Q queryParameters, Class<R> responseClass) throws Exception {
        RequestBody requestBody = RequestBody.create((String)body, (MediaType)JSON);
        Request.Builder rb = new Request.Builder().post(requestBody);
        return this.makeRequest(endpoint, queryParameters, rb, responseClass);
    }

    <Q, R> R delete(String endpoint, Q queryParameters, Class<R> responseClass) throws Exception {
        Request.Builder rb = new Request.Builder().delete();
        return this.makeRequest(endpoint, queryParameters, rb, responseClass);
    }

    <Q, T> T makeRequest(String endpoint, Q queryParameters, Request.Builder requestBuilder, Class<T> responseClass) throws Exception {
        int num_tries = 0;
        Exception lastException = new TypesenseError("Unknown client error", 400);
        while (num_tries < this.configuration.numRetries) {
            ++num_tries;
            Node node = this.getNode();
            String URI2 = node.baseUrl;
            try {
                String url = URI2 + endpoint;
                String fullUrl = this.populateQueryParameters(url, queryParameters).toString();
                Request request = requestBuilder.url(fullUrl).header(API_KEY_HEADER, this.apiKey).build();
                Response response = this.client.newCall(request).execute();
                if (response.code() < 500) {
                    this.setNodeHealthStatus(node, true);
                }
                if (response.code() >= 200 && response.code() < 300) {
                    return this.handleResponse(response, responseClass);
                }
                throw this.getException(response);
            }
            catch (Exception e) {
                boolean handleError;
                boolean bl = handleError = e instanceof ServerError || e instanceof ServiceUnavailable || e.getClass().getPackage().getName().startsWith("java.net") || e instanceof SSLException;
                if (!handleError) {
                    throw e;
                }
                this.setNodeHealthStatus(node, false);
                lastException = e;
                logger.debug("Request to " + node.host + " failed because: " + e.getMessage());
                logger.debug("Sleeping for " + this.retryInterval.getSeconds() + "s and then retrying request");
                try {
                    Thread.sleep(this.retryInterval.getSeconds() * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        throw lastException;
    }

    private <T> HttpUrl.Builder populateQueryParameters(String url, T queryParameters) {
        HttpUrl.Builder httpBuilder = HttpUrl.parse((String)url).newBuilder();
        if (queryParameters != null) {
            Map map = (Map)this.mapper.convertValue(queryParameters, Map.class);
            for (Map.Entry entry : map.entrySet()) {
                StringBuilder value = new StringBuilder();
                if (entry.getValue() instanceof ArrayList) {
                    for (int i = 0; i < ((ArrayList)entry.getValue()).size(); ++i) {
                        value.append(((ArrayList)entry.getValue()).get(i));
                        if (i == ((ArrayList)entry.getValue()).size() - 1) continue;
                        value.append(",");
                    }
                    httpBuilder.addQueryParameter((String)entry.getKey(), value.toString());
                    continue;
                }
                if (entry.getValue() == null) continue;
                httpBuilder.addQueryParameter((String)entry.getKey(), entry.getValue().toString());
            }
        }
        return httpBuilder;
    }

    <T> T handleResponse(Response response, Class<T> responseClass) throws IOException {
        if (responseClass == null) {
            try {
                return (T)this.mapper.readValue(response.body().string(), HashMap.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                if (responseClass == String.class) {
                    return (T)response.body().string();
                }
                return (T)this.mapper.readValue(response.body().string(), responseClass);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

