/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetBlobLiteral;

public class SqlJetBlobLiteral
extends SqlJetExpression
implements ISqlJetBlobLiteral {
    private final byte[] value;

    public SqlJetBlobLiteral(CommonTree ast) {
        assert ("blob_literal".equalsIgnoreCase(ast.getText()));
        this.value = SqlJetBlobLiteral.parseBlob(ast.getChild(0).getText());
    }

    public byte[] getValue() {
        return this.value;
    }

    public String toString() {
        return SqlJetBlobLiteral.asBlob(this.value);
    }

    public static byte[] parseBlob(String data) {
        data = data.substring(2, data.length() - 1).toLowerCase();
        byte[] buffer = new byte[data.length() / 2];
        for (int i = 0; i < buffer.length; ++i) {
            char c1 = data.charAt(i * 2);
            char c2 = data.charAt(i * 2 + 1);
            int b1 = c1 - (c1 >= 'a' ? 97 : 48);
            int b2 = c2 - (c2 >= 'a' ? 97 : 48);
            buffer[i] = (byte)(b1 * 16 + b2);
        }
        return buffer;
    }

    public static String asBlob(byte[] data) {
        StringBuffer buffer = new StringBuffer("x'");
        for (byte b : data) {
            buffer.append((char)(b / 16 > 9 ? 97 + b / 16 - 10 : 48 + b / 16));
            buffer.append((char)(b % 16 > 9 ? 97 + b % 16 - 10 : 48 + b % 16));
        }
        buffer.append("'");
        return buffer.toString();
    }
}

