/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.table;

import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;

public class SqlJetDefaultBusyHandler
implements ISqlJetBusyHandler {
    public static final String SQLJET_BUSY_RETRIES_PROPERTY = "SQLJET_BUSY_RETRIES";
    public static final String SQLJET_BUSY_SLEEP_PROPERTY = "SQLJET_BUSY_SLEEP";
    private static final int DEFAULT_RETRIES = 10;
    private static final int DEFAULT_SLEEP = 100;
    private int retries;
    private int sleep;
    private boolean cancel = false;

    public SqlJetDefaultBusyHandler() {
        this.retries = SqlJetUtility.getIntSysProp(SQLJET_BUSY_RETRIES_PROPERTY, 10);
        this.sleep = SqlJetUtility.getIntSysProp(SQLJET_BUSY_SLEEP_PROPERTY, 100);
    }

    public SqlJetDefaultBusyHandler(int retries, int sleep) {
        this.retries = retries > 0 ? retries : SqlJetUtility.getIntSysProp(SQLJET_BUSY_RETRIES_PROPERTY, 10);
        this.sleep = sleep > 0 ? sleep : SqlJetUtility.getIntSysProp(SQLJET_BUSY_SLEEP_PROPERTY, 100);
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getSleep() {
        return this.sleep;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public boolean call(int number) {
        if (this.cancel) {
            this.cancel = false;
            return false;
        }
        if (number > this.retries) {
            return false;
        }
        try {
            Thread.sleep(this.sleep);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }
}

