/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.SqlJetSortingOrder;

public class SqlJetIndexedColumn
implements ISqlJetIndexedColumn {
    private final String name;
    private final String collation;
    private final SqlJetSortingOrder sortingOrder;
    private ISqlJetColumnDef tableColumn;

    public SqlJetIndexedColumn(CommonTree ast) {
        this.name = ast.getText();
        String collation = null;
        SqlJetSortingOrder sortingOrder = null;
        for (int i = 0; i < ast.getChildCount(); ++i) {
            CommonTree child = (CommonTree)ast.getChild(i);
            if ("collate".equalsIgnoreCase(child.getText())) {
                collation = child.getChild(0).getText();
                continue;
            }
            if ("asc".equalsIgnoreCase(child.getText())) {
                sortingOrder = SqlJetSortingOrder.ASC;
                continue;
            }
            if ("desc".equalsIgnoreCase(child.getText())) {
                sortingOrder = SqlJetSortingOrder.DESC;
                continue;
            }
            assert (false);
        }
        this.collation = collation;
        this.sortingOrder = sortingOrder;
    }

    public String getName() {
        return this.name;
    }

    public String getCollation() {
        return this.collation;
    }

    public SqlJetSortingOrder getSortingOrder() {
        return this.sortingOrder;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        if (this.getCollation() != null) {
            buffer.append(" COLLATE ");
            buffer.append(this.getCollation());
        }
        if (this.getSortingOrder() != null) {
            buffer.append(' ');
            buffer.append((Object)this.getSortingOrder());
        }
        return buffer.toString();
    }

    public void setTableColumn(ISqlJetColumnDef tableColumn) {
        this.tableColumn = tableColumn;
    }

    public ISqlJetColumnDef getTableColumn() {
        return this.tableColumn;
    }
}

