/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.util.List;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetUnpackedRecordFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBaseIndexDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetUnpackedRecord;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.SqlJetSortingOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetBtreeIndexTable
extends SqlJetBtreeTable
implements ISqlJetBtreeIndexTable {
    private ISqlJetIndexDef indexDef;
    private List<String> columns;

    public SqlJetBtreeIndexTable(ISqlJetSchema schema, String indexName, boolean write) throws SqlJetException {
        super(((SqlJetSchema)schema).getDb(), ((SqlJetSchema)schema).getBtree(), ((SqlJetBaseIndexDef)schema.getIndex(indexName)).getPage(), write, true);
        this.indexDef = schema.getIndex(indexName);
        this.adjustKeyInfo();
    }

    public SqlJetBtreeIndexTable(ISqlJetSchema schema, String indexName, List<String> columns, boolean write) throws SqlJetException {
        super(((SqlJetSchema)schema).getDb(), ((SqlJetSchema)schema).getBtree(), ((SqlJetBaseIndexDef)schema.getIndex(indexName)).getPage(), write, true);
        this.indexDef = schema.getIndex(indexName);
        this.columns = columns;
        this.adjustKeyInfo();
    }

    public ISqlJetIndexDef getIndexDef() {
        return this.indexDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lookup(boolean next, Object ... values) throws SqlJetException {
        long l;
        this.lock();
        try {
            l = this.lookupSafe(next, false, false, values);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
        return l;
    }

    private long lookupSafe(boolean next, boolean near, boolean last, Object ... values) throws SqlJetException {
        ISqlJetBtreeRecord key = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), values);
        ISqlJetMemoryPointer k = key.getRawRecord();
        if (next) {
            if (!last) {
                this.next();
            } else {
                this.previous();
            }
        } else {
            int moved = this.cursorMoveTo(k, last);
            if (moved != 0) {
                if (!last) {
                    if (moved < 0) {
                        this.next();
                    }
                } else if (moved > 0) {
                    this.previous();
                }
            }
        }
        ISqlJetBtreeRecord record = this.getRecord();
        if (null == record) {
            return 0L;
        }
        if (!near && this.keyCompare(k, record.getRawRecord()) != 0) {
            return 0L;
        }
        return this.getKeyRowId(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cursorMoveTo(ISqlJetMemoryPointer pKey, boolean last) throws SqlJetException {
        int n;
        block7: {
            SqlJetUnpackedRecord pIdxKey;
            this.clearRecordCache();
            int nKey = pKey.remaining();
            if (!last) {
                return this.cursor.moveTo(pKey, nKey, false);
            }
            if (pKey != null) {
                assert ((long)nKey == (long)nKey);
                pIdxKey = this.keyInfo.recordUnpack(nKey, pKey);
                pIdxKey.getFlags().add(SqlJetUnpackedRecordFlags.INCRKEY);
                if (pIdxKey == null) {
                    throw new SqlJetException(SqlJetErrorCode.NOMEM);
                }
            } else {
                pIdxKey = null;
            }
            try {
                n = this.cursor.moveToUnpacked(pIdxKey, nKey, false);
                Object var7_6 = null;
                if (pKey == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var7_7 = null;
                    if (pKey == null) break block8;
                    SqlJetUnpackedRecord.delete(pIdxKey);
                }
                throw throwable;
            }
            SqlJetUnpackedRecord.delete(pIdxKey);
        }
        return n;
    }

    private int keyCompare(ISqlJetMemoryPointer key, ISqlJetMemoryPointer record) throws SqlJetException {
        SqlJetUnpackedRecord unpacked = this.keyInfo.recordUnpack(key.remaining(), key);
        Set<SqlJetUnpackedRecordFlags> flags = unpacked.getFlags();
        flags.add(SqlJetUnpackedRecordFlags.IGNORE_ROWID);
        flags.add(SqlJetUnpackedRecordFlags.PREFIX_MATCH);
        return unpacked.recordCompare(record.remaining(), record);
    }

    @Override
    public int compareKeys(Object[] firstKey, Object[] lastKey) throws SqlJetException {
        SqlJetEncoding encoding = this.db.getOptions().getEncoding();
        ISqlJetMemoryPointer firstRec = SqlJetBtreeRecord.getRecord(encoding, firstKey).getRawRecord();
        ISqlJetMemoryPointer lastRec = SqlJetBtreeRecord.getRecord(encoding, lastKey).getRawRecord();
        SqlJetUnpackedRecord unpacked = this.keyInfo.recordUnpack(firstRec.remaining(), firstRec);
        unpacked.getFlags().add(SqlJetUnpackedRecordFlags.PREFIX_MATCH);
        return unpacked.recordCompare(lastRec.remaining(), lastRec);
    }

    @Override
    public boolean checkKey(Object ... key) throws SqlJetException {
        if (this.eof()) {
            return false;
        }
        ISqlJetMemoryPointer keyRecord = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), key).getRawRecord();
        return 0 == this.keyCompare(keyRecord, this.getRecord().getRawRecord());
    }

    private void adjustKeyInfo() throws SqlJetException {
        if (null == this.keyInfo) {
            throw new SqlJetException(SqlJetErrorCode.INTERNAL);
        }
        if (null != this.columns) {
            this.keyInfo.setNField(this.columns.size());
        } else if (null != this.indexDef.getColumns()) {
            this.keyInfo.setNField(this.indexDef.getColumns().size());
            int i = 0;
            for (ISqlJetIndexedColumn column : this.indexDef.getColumns()) {
                this.keyInfo.setSortOrder(i++, column.getSortingOrder() == SqlJetSortingOrder.DESC);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(long rowId, boolean append, Object ... key) throws SqlJetException {
        this.lock();
        try {
            ISqlJetMemoryPointer zKey = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), SqlJetUtility.addArrays(key, new Object[]{rowId})).getRawRecord();
            this.cursor.insert(zKey, zKey.remaining(), SqlJetUtility.allocatePtr(0), 0, 0, append);
            this.clearRecordCache();
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(long rowId, Object ... key) throws SqlJetException {
        boolean bl;
        block10: {
            boolean bl2;
            block9: {
                boolean bl3;
                block8: {
                    boolean bl4;
                    block7: {
                        this.lock();
                        try {
                            ISqlJetBtreeRecord rec = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), key);
                            ISqlJetMemoryPointer k = rec.getRawRecord();
                            if (this.cursorMoveTo(k, false) < 0) {
                                this.next();
                            }
                            do {
                                ISqlJetBtreeRecord record;
                                if (null == (record = this.getRecord())) {
                                    bl4 = false;
                                    Object var9_10 = null;
                                    break block7;
                                }
                                if (this.keyCompare(k, record.getRawRecord()) != 0) {
                                    bl3 = false;
                                    break block8;
                                }
                                if (this.getKeyRowId(record) != rowId) continue;
                                this.cursor.delete();
                                this.clearRecordCache();
                                if (this.cursorMoveTo(k, false) < 0) {
                                    this.next();
                                }
                                bl2 = true;
                                break block9;
                            } while (this.next());
                            bl = false;
                            break block10;
                        }
                        catch (Throwable throwable) {
                            Object var9_14 = null;
                            this.unlock();
                            throw throwable;
                        }
                    }
                    this.unlock();
                    return bl4;
                }
                Object var9_11 = null;
                this.unlock();
                return bl3;
            }
            Object var9_12 = null;
            this.unlock();
            return bl2;
        }
        Object var9_13 = null;
        this.unlock();
        return bl;
    }

    private long getKeyRowId(ISqlJetBtreeRecord record) {
        if (null == record) {
            return 0L;
        }
        List<ISqlJetVdbeMem> fields = record.getFields();
        if (null == fields || 0 == fields.size()) {
            return 0L;
        }
        return fields.get(fields.size() - 1).intValue();
    }

    @Override
    public long getKeyRowId() throws SqlJetException {
        return this.getKeyRowId(this.getRecord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex(ISqlJetSchema schema) throws SqlJetException {
        this.lock();
        try {
            this.btree.clearTable(this.rootPage, null);
            SqlJetBtreeDataTable dataTable = new SqlJetBtreeDataTable(schema, this.indexDef.getTableName(), false);
            try {
                dataTable.first();
                while (!dataTable.eof()) {
                    Object[] key = dataTable.getKeyForIndex(dataTable.getAsNamedFields(dataTable.getValues()), this.indexDef);
                    this.insert(dataTable.getRowId(), true, key);
                    dataTable.next();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                dataTable.close();
                throw throwable;
            }
            dataTable.close();
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
    }

    @Override
    public int compareKey(Object[] key) throws SqlJetException {
        if (this.eof()) {
            return 1;
        }
        ISqlJetMemoryPointer keyRecord = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), key).getRawRecord();
        return this.keyCompare(keyRecord, this.getRecord().getRawRecord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lookupNear(boolean next, Object[] key) throws SqlJetException {
        long l;
        this.lock();
        try {
            l = this.lookupSafe(next, true, false, key);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lookupLastNear(Object[] key) throws SqlJetException {
        long l;
        this.lock();
        try {
            l = this.lookupSafe(false, true, true, key);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
        return l;
    }
}

