/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.SecureRandom;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetIOErrorCode;
import org.tmatesoft.sqljet.core.SqlJetIOException;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.SqlJetFileAccesPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFile;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetMemJournal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetFileSystem
implements ISqlJetFileSystem {
    public static final String FS_NAME = SqlJetFileSystem.class.getCanonicalName();
    private static final String SQLJET_TEMP_FILE_PREFIX = "tejlqs_";
    private final SecureRandom random = new SecureRandom();

    @Override
    public String getName() {
        return FS_NAME;
    }

    @Override
    public ISqlJetFile open(File path, SqlJetFileType type, Set<SqlJetFileOpenPermission> permissions) throws SqlJetException {
        File filePath;
        if (null == type) {
            throw new SqlJetException(SqlJetErrorCode.BAD_PARAMETER, "File type must not be null to open file");
        }
        if (null == permissions || permissions.isEmpty()) {
            throw new SqlJetException(SqlJetErrorCode.BAD_PARAMETER, "Permissions must not be null or empty to open file");
        }
        boolean isExclusive = permissions.contains((Object)SqlJetFileOpenPermission.EXCLUSIVE);
        boolean isDelete = permissions.contains((Object)SqlJetFileOpenPermission.DELETEONCLOSE);
        boolean isCreate = permissions.contains((Object)SqlJetFileOpenPermission.CREATE);
        boolean isReadonly = permissions.contains((Object)SqlJetFileOpenPermission.READONLY);
        boolean isReadWrite = permissions.contains((Object)SqlJetFileOpenPermission.READWRITE);
        assert (!(isReadonly && isReadWrite || !isReadWrite && !isReadonly));
        assert (!isCreate || isReadWrite);
        assert (!isExclusive || isCreate);
        assert (!isDelete || isCreate);
        assert (SqlJetFileType.MAIN_DB != type || !isDelete);
        assert (SqlJetFileType.MAIN_JOURNAL != type || !isDelete);
        assert (SqlJetFileType.MASTER_JOURNAL != type || !isDelete);
        if (null != path) {
            try {
                filePath = path.getCanonicalFile();
            }
            catch (IOException e) {
                throw new SqlJetException(SqlJetErrorCode.CANTOPEN, (Throwable)e);
            }
        }
        assert (isDelete && (!isCreate || SqlJetFileType.MASTER_JOURNAL != type && SqlJetFileType.MAIN_JOURNAL != type));
        try {
            filePath = this.getTempFile();
        }
        catch (IOException e) {
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN, (Throwable)e);
        }
        assert (null != filePath);
        if (!isReadWrite && !filePath.exists()) {
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN);
        }
        String mode = "rw";
        RandomAccessFile file = null;
        try {
            try {
                file = new RandomAccessFile(filePath, "rw");
            }
            catch (FileNotFoundException e) {
                for (int i = 0; i < 10; ++i) {
                    try {
                        Thread.sleep(10L);
                        file = new RandomAccessFile(filePath, "rw");
                    }
                    catch (InterruptedException e1) {
                    }
                    catch (FileNotFoundException e1) {
                        // empty catch block
                    }
                    if (file != null) break;
                }
                if (file == null) {
                    file = new RandomAccessFile(filePath, "rw");
                }
            }
        }
        catch (FileNotFoundException e) {
            if (isReadWrite && !isExclusive) {
                permissions.remove((Object)SqlJetFileOpenPermission.READWRITE);
                permissions.remove((Object)SqlJetFileOpenPermission.CREATE);
                permissions.add(SqlJetFileOpenPermission.READONLY);
                return this.open(filePath, type, permissions);
            }
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN);
        }
        if (isDelete) {
            filePath.deleteOnExit();
        }
        boolean noLock = SqlJetFileType.MAIN_DB != type;
        return new SqlJetFile(this, file, filePath, type, permissions, noLock);
    }

    @Override
    public File getTempFile() throws IOException {
        return File.createTempFile(SQLJET_TEMP_FILE_PREFIX, null);
    }

    @Override
    public boolean delete(File path, boolean sync) {
        assert (null != path);
        if (path == null || !path.exists()) {
            return false;
        }
        boolean delete = path.delete();
        if (sync && !delete && path.exists()) {
            for (int i = 0; i < 100 && (!(delete = path.delete()) || path.exists()); ++i) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        return delete && !path.exists();
    }

    @Override
    public boolean access(File path, SqlJetFileAccesPermission permission) throws SqlJetException {
        assert (null != path);
        assert (null != permission);
        switch (permission) {
            case EXISTS: {
                return path.exists();
            }
            case READONLY: {
                return path.canRead() && !path.canWrite();
            }
            case READWRITE: {
                return path.canRead() && path.canWrite();
            }
        }
        throw new SqlJetException(SqlJetErrorCode.INTERNAL, "Unhandled SqlJetFileAccesPermission value :" + permission.name());
    }

    @Override
    public long currentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public byte[] randomness(int numBytes) {
        assert (numBytes > 0);
        byte[] bytes = new byte[numBytes];
        this.random.nextBytes(bytes);
        return bytes;
    }

    @Override
    public long sleep(long microseconds) {
        assert (microseconds > 0L);
        long t = System.currentTimeMillis();
        try {
            Thread.sleep(microseconds);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return System.currentTimeMillis() - t;
    }

    @Override
    public ISqlJetFile memJournalOpen() {
        return new SqlJetMemJournal();
    }

    @Override
    public String getFullPath(File filename) throws SqlJetException {
        assert (filename != null);
        try {
            return filename.getCanonicalPath();
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_ACCESS, (Throwable)e);
        }
    }
}

