/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.internal.Utils;
import org.testng.reporters.ICustomizeXmlReport;
import org.testng.reporters.RuntimeBehavior;
import org.testng.reporters.XMLReporterConfig;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.XMLSuiteResultWriter;
import org.testng.util.TimeUtils;

public abstract class AbstractXmlReporter
implements IReporter,
ICustomizeXmlReport {
    private final XMLReporterConfig config = new XMLReporterConfig();

    public String fileName() {
        return RuntimeBehavior.getDefaultFileNameForXmlReports();
    }

    @Override
    public XMLReporterConfig getConfig() {
        return this.config;
    }

    @Override
    public void addCustomTagsFor(XMLStringBuffer xmlBuffer, ITestResult testResult) {
    }

    protected final void writeReporterOutput(XMLStringBuffer xmlBuffer) {
        this.writeReporterOutput(xmlBuffer, Reporter.getOutput());
    }

    protected final void writeReporterOutput(XMLStringBuffer xmlBuffer, List<String> output) {
        xmlBuffer.push("reporter-output");
        for (String line : output) {
            if (line == null) continue;
            xmlBuffer.push("line");
            xmlBuffer.addCDATA(line);
            xmlBuffer.pop();
        }
        xmlBuffer.pop();
    }

    protected final void writeSuite(XMLStringBuffer rootBuffer, ISuite suite) {
        switch (this.config.getFileFragmentationLevel()) {
            case 1: {
                this.writeSuiteToBuffer(rootBuffer, suite);
                break;
            }
            case 2: 
            case 3: {
                File suiteFile = this.referenceSuite(rootBuffer, suite);
                this.writeSuiteToFile(suiteFile, suite);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected value: " + this.config.getFileFragmentationLevel()));
            }
        }
    }

    private void writeSuiteToFile(File suiteFile, ISuite suite) {
        XMLStringBuffer xmlBuffer = new XMLStringBuffer();
        this.writeSuiteToBuffer(xmlBuffer, suite);
        File parentDir = suiteFile.getParentFile();
        boolean ignored = suiteFile.getParentFile().mkdirs();
        if (parentDir.exists() || suiteFile.getParentFile().exists()) {
            Utils.writeUtf8File(parentDir.getAbsolutePath(), this.fileName(), xmlBuffer.toXML());
        }
    }

    private File referenceSuite(XMLStringBuffer xmlBuffer, ISuite suite) {
        String relativePath = suite.getName() + File.separatorChar + this.fileName();
        File suiteFile = new File(this.config.getOutputDirectory(), relativePath);
        Properties attrs = new Properties();
        attrs.setProperty("url", relativePath);
        xmlBuffer.addEmptyElement("suite", attrs);
        return suiteFile;
    }

    private void writeSuiteToBuffer(XMLStringBuffer xmlBuffer, ISuite suite) {
        xmlBuffer.push("suite", this.getSuiteAttributes(suite));
        this.writeSuiteGroups(xmlBuffer, suite);
        Map<String, ISuiteResult> results = suite.getResults();
        XMLSuiteResultWriter suiteResultWriter = new XMLSuiteResultWriter(this.config, this);
        for (Map.Entry<String, ISuiteResult> result : results.entrySet()) {
            suiteResultWriter.writeSuiteResult(xmlBuffer, result.getValue());
        }
        xmlBuffer.pop();
    }

    private Set<ITestNGMethod> getUniqueMethodSet(Collection<ITestNGMethod> methods) {
        return new LinkedHashSet<ITestNGMethod>(methods);
    }

    private void writeSuiteGroups(XMLStringBuffer xmlBuffer, ISuite suite) {
        xmlBuffer.push("groups");
        Map<String, Collection<ITestNGMethod>> methodsByGroups = suite.getMethodsByGroups();
        for (Map.Entry<String, Collection<ITestNGMethod>> entry : methodsByGroups.entrySet()) {
            Properties groupAttrs = new Properties();
            groupAttrs.setProperty("name", entry.getKey());
            xmlBuffer.push("group", groupAttrs);
            Set<ITestNGMethod> groupMethods = this.getUniqueMethodSet(entry.getValue());
            for (ITestNGMethod groupMethod : groupMethods) {
                Properties methodAttrs = new Properties();
                methodAttrs.setProperty("name", groupMethod.getMethodName());
                methodAttrs.setProperty("signature", groupMethod.toString());
                methodAttrs.setProperty("class", groupMethod.getRealClass().getName());
                xmlBuffer.addEmptyElement("method", methodAttrs);
            }
            xmlBuffer.pop();
        }
        xmlBuffer.pop();
    }

    private Properties getSuiteAttributes(ISuite suite) {
        Properties props = new Properties();
        props.setProperty("name", suite.getName());
        Map<String, ISuiteResult> results = suite.getResults();
        Date minStartDate = new Date();
        Date maxEndDate = null;
        for (Map.Entry<String, ISuiteResult> result : results.entrySet()) {
            ITestContext testContext = result.getValue().getTestContext();
            Date startDate = testContext.getStartDate();
            Date endDate = testContext.getEndDate();
            if (minStartDate.after(startDate)) {
                minStartDate = startDate;
            }
            if (maxEndDate != null && !maxEndDate.before(endDate)) continue;
            maxEndDate = endDate != null ? endDate : startDate;
        }
        if (maxEndDate == null) {
            maxEndDate = minStartDate;
        }
        AbstractXmlReporter.setDurationAttributes(this.config, props, minStartDate, maxEndDate);
        return props;
    }

    protected static void setDurationAttributes(XMLReporterConfig config, Properties attributes, Date minStartDate, Date maxEndDate) {
        String startTime = TimeUtils.formatTimeInLocalOrSpecifiedTimeZone(minStartDate.getTime(), config.getTimestampFormat());
        String endTime = TimeUtils.formatTimeInLocalOrSpecifiedTimeZone(maxEndDate.getTime(), config.getTimestampFormat());
        long duration = maxEndDate.getTime() - minStartDate.getTime();
        attributes.setProperty("started-at", startTime);
        attributes.setProperty("finished-at", endTime);
        attributes.setProperty("duration-ms", Long.toString(duration));
    }

    protected final Properties writeSummaryCount(Count count) {
        Properties p = new Properties();
        p.put("passed", (Object)count.passed);
        p.put("failed", (Object)count.failed);
        p.put("skipped", (Object)count.skipped);
        if (count.retried > 0) {
            p.put("retried", (Object)count.retried);
        }
        p.put("ignored", (Object)count.ignored);
        p.put("total", (Object)count.total());
        return p;
    }

    protected final Count computeCountForSuite(ISuite s) {
        int passed = 0;
        int failed = 0;
        int skipped = 0;
        int retried = 0;
        int ignored = 0;
        for (ISuiteResult sr : s.getResults().values()) {
            ITestContext testContext = sr.getTestContext();
            passed += testContext.getPassedTests().size();
            failed += testContext.getFailedTests().size();
            int retriedPerTest = 0;
            int skippedPerTest = 0;
            for (ITestResult result : testContext.getSkippedTests().getAllResults()) {
                if (result.wasRetried()) {
                    ++retriedPerTest;
                    continue;
                }
                ++skippedPerTest;
            }
            skipped += skippedPerTest;
            retried += retriedPerTest;
            ignored += (int)testContext.getExcludedMethods().stream().filter(ITestNGMethod::isTest).count();
        }
        return Count.Builder.builder().withPassed(passed).withFailed(failed).withSkipped(skipped).withRetried(retried).withIgnored(ignored).build();
    }

    public static class Count {
        private int passed;
        private int failed;
        private int skipped;
        private int retried;
        private int ignored;

        public int total() {
            return this.passed + this.failed + this.skipped + this.retried + this.ignored;
        }

        public void add(Count count) {
            this.passed += count.passed;
            this.failed += count.failed;
            this.skipped += count.skipped;
            this.retried += count.retried;
            this.ignored += count.retried;
        }

        private Count(Builder builder) {
            this.passed = builder.passed;
            this.failed = builder.failed;
            this.skipped = builder.skipped;
            this.retried = builder.retried;
            this.ignored = builder.ignored;
        }

        public static final class Builder {
            private int passed;
            private int failed;
            private int skipped;
            private int retried;
            private int ignored;

            private Builder() {
            }

            public static Builder builder() {
                return new Builder();
            }

            public Builder withPassed(int val) {
                this.passed = val;
                return this;
            }

            public Builder withFailed(int val) {
                this.failed = val;
                return this;
            }

            public Builder withSkipped(int val) {
                this.skipped = val;
                return this;
            }

            public Builder withRetried(int val) {
                this.retried = val;
                return this;
            }

            public Builder withIgnored(int val) {
                this.ignored = val;
                return this;
            }

            public Count build() {
                return new Count(this);
            }
        }
    }
}

