/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.typesense;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class TypesenseContainer
extends GenericContainer<TypesenseContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"typesense/typesense");
    private static final int PORT = 8108;
    private static final String DEFAULT_API_KEY = "testcontainers";
    private String apiKey = "testcontainers";

    public TypesenseContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public TypesenseContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{8108});
        this.withEnv("TYPESENSE_DATA_DIR", "/tmp");
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/health").forStatusCode(200).forResponsePredicate(response -> response.contains("\"ok\":true")));
    }

    protected void configure() {
        this.withEnv("TYPESENSE_API_KEY", this.apiKey);
    }

    public TypesenseContainer withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public String getHttpPort() {
        return String.valueOf(this.getMappedPort(8108));
    }

    public String getApiKey() {
        return this.apiKey;
    }
}

