/*
 * Decompiled with CFR 0.152.
 */
package tachyon.heartbeat;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import tachyon.heartbeat.HeartbeatScheduler;
import tachyon.heartbeat.HeartbeatTimer;

public final class ScheduledTimer
implements HeartbeatTimer {
    private final String mThreadName;
    private final Lock mLock;
    private final Condition mCondition;

    public ScheduledTimer(String threadName, long intervalMs) {
        this.mThreadName = threadName;
        this.mLock = new ReentrantLock();
        this.mCondition = this.mLock.newCondition();
    }

    public String getThreadName() {
        return this.mThreadName;
    }

    public void schedule() {
        this.mLock.lock();
        this.mCondition.signal();
        this.mLock.unlock();
    }

    @Override
    public synchronized void tick() throws InterruptedException {
        HeartbeatScheduler.addTimer(this);
        this.mLock.lock();
        this.mCondition.await();
        this.mLock.unlock();
    }
}

