/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl.facade;

import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.ssl.SslVo;
import org.tio.core.ssl.facade.IHandshakeCompletedListener;
import org.tio.core.ssl.facade.ISessionClosedListener;
import org.tio.core.ssl.facade.ITaskHandler;
import org.tio.core.ssl.facade.SSLLog;
import org.tio.core.ssl.facade.Tasks;
import org.tio.core.ssl.facade.Worker;

class Handshaker {
    private static Logger log = LoggerFactory.getLogger(Handshaker.class);
    private static final String TAG = "Handshaker";
    private final ITaskHandler _taskHandler;
    private final Worker _worker;
    private boolean _finished;
    private IHandshakeCompletedListener _hscl;
    private ISessionClosedListener _sessionClosedListener;
    private boolean _client;
    private ChannelContext channelContext;

    public Handshaker(boolean client, Worker worker, ITaskHandler taskHandler, ChannelContext channelContext) {
        this.channelContext = channelContext;
        this._worker = worker;
        this._taskHandler = taskHandler;
        this._finished = false;
        this._client = client;
    }

    private void debug(String msg, String ... args) {
        SSLLog.debug(this.channelContext.toString(), msg, args);
    }

    void begin() throws SSLException {
        this._worker.beginHandshake();
        this.shakehands();
    }

    void carryOn() throws SSLException {
        this.shakehands();
    }

    void handleUnwrapResult(SSLEngineResult result) throws SSLException {
        if (result.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) {
            this.handshakeFinished();
        } else {
            this.shakehands();
        }
    }

    void addCompletedListener(IHandshakeCompletedListener hscl) {
        this._hscl = hscl;
    }

    void removeCompletedListener(IHandshakeCompletedListener hscl) {
        this._hscl = hscl;
    }

    boolean isFinished() {
        return this._finished;
    }

    private void shakehands() throws SSLException {
        SSLEngineResult.HandshakeStatus handshakeStatus = this._worker.getHandshakeStatus();
        log.info("{}, handshakeStatus:{}", (Object)this.channelContext, (Object)handshakeStatus);
        switch (handshakeStatus) {
            case NOT_HANDSHAKING: {
                break;
            }
            case FINISHED: {
                this.handshakeFinished();
                break;
            }
            case NEED_TASK: {
                this._taskHandler.process(new Tasks(this._worker, this));
                break;
            }
            case NEED_WRAP: {
                SSLEngineResult w_result = this._worker.wrap(new SslVo(), null);
                if (w_result.getStatus().equals((Object)SSLEngineResult.Status.CLOSED) && null != this._sessionClosedListener) {
                    this._sessionClosedListener.onSessionClosed();
                }
                if (w_result.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) {
                    this.handshakeFinished();
                    break;
                }
                this.shakehands();
                break;
            }
            case NEED_UNWRAP: {
                if (this._worker.pendingUnwrap()) {
                    SSLEngineResult u_result = this._worker.unwrap(null);
                    this.debug("Unwrap result " + u_result, new String[0]);
                    if (u_result.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) {
                        this.handshakeFinished();
                    }
                    if (!u_result.getStatus().equals((Object)SSLEngineResult.Status.OK)) break;
                    this.shakehands();
                    break;
                }
                this.debug("No pending data to unwrap", new String[0]);
            }
        }
    }

    private void handshakeFinished() {
        this._finished = true;
        this._hscl.onComplete();
    }
}

