/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.intf.GroupListener;
import org.tio.core.maintain.MaintainUtils;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.lock.LockUtils;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.lock.SetWithLock;

public class Groups {
    private Comparator<ChannelContext> channelContextComparator = null;
    private static Logger log = LoggerFactory.getLogger(Groups.class);
    private MapWithLock<String, SetWithLock<ChannelContext>> groupmap = new MapWithLock(new HashMap());
    private String rwKey = "_tio_groups_bind__";

    public void bind(String groupid, ChannelContext channelContext) {
        this.bind(groupid, channelContext, true);
    }

    public void bind(String groupid, ChannelContext channelContext, boolean callbackListener) {
        GroupListener groupListener;
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        if (StrUtil.isBlank((CharSequence)groupid)) {
            return;
        }
        SetWithLock channelSet = (SetWithLock)this.groupmap.get((Object)groupid);
        if (channelSet == null) {
            try {
                LockUtils.runWriteOrWaitRead((String)(this.rwKey + groupid), (Object)this, () -> {
                    if (this.groupmap.get((Object)groupid) == null) {
                        this.groupmap.put((Object)groupid, (Object)new SetWithLock(MaintainUtils.createSet(this.channelContextComparator)));
                    }
                });
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            channelSet = (SetWithLock)this.groupmap.get((Object)groupid);
        }
        channelSet.add((Object)channelContext);
        channelContext.getGroups().add((Object)groupid);
        if (callbackListener && (groupListener = channelContext.tioConfig.getGroupListener()) != null) {
            try {
                groupListener.onAfterBind(channelContext, groupid);
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
        }
    }

    public SetWithLock<ChannelContext> clients(TioConfig tioConfig, String groupid) {
        if (tioConfig.isShortConnection) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)groupid)) {
            return null;
        }
        return (SetWithLock)this.groupmap.get((Object)groupid);
    }

    public MapWithLock<String, SetWithLock<ChannelContext>> getGroupmap() {
        return this.groupmap;
    }

    public SetWithLock<String> groups(ChannelContext channelContext) {
        TioConfig tioConfig = channelContext.tioConfig;
        if (tioConfig.isShortConnection) {
            return null;
        }
        return channelContext.getGroups();
    }

    public void unbind(ChannelContext channelContext) {
        this.unbind(channelContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(ChannelContext channelContext, boolean callbackListener) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        try {
            SetWithLock<String> setWithLock = channelContext.getGroups();
            ReentrantReadWriteLock.WriteLock writeLock = setWithLock.writeLock();
            writeLock.lock();
            try {
                Set groups = (Set)setWithLock.getObj();
                if (groups != null && groups.size() > 0) {
                    for (String groupid : groups) {
                        try {
                            this.unbind(groupid, channelContext, false, callbackListener);
                        }
                        catch (Exception e) {
                            log.error(e.toString(), (Throwable)e);
                        }
                    }
                    groups.clear();
                    channelContext.getGroups().clear();
                }
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            finally {
                writeLock.unlock();
            }
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
    }

    public void unbind(String groupid, ChannelContext channelContext) {
        this.unbind(groupid, channelContext, true);
    }

    public void unbind(String groupid, ChannelContext channelContext, boolean deleteFromChannelContext) {
        this.unbind(groupid, channelContext, deleteFromChannelContext, true);
    }

    public void unbind(String groupid, ChannelContext channelContext, boolean deleteFromChannelContext, boolean callbackListener) {
        block10: {
            if (channelContext.tioConfig.isShortConnection) {
                return;
            }
            if (StrUtil.isBlank((CharSequence)groupid)) {
                return;
            }
            try {
                GroupListener groupListener;
                SetWithLock channelSet = (SetWithLock)this.groupmap.get((Object)groupid);
                if (channelSet == null) break block10;
                boolean ss = channelSet.remove((Object)channelContext);
                if (!ss) {
                    log.warn("{}, \u79fb\u9664\u5931\u8d25,group:{} cid:{}", new Object[]{channelContext, groupid, channelContext.getId()});
                }
                if (deleteFromChannelContext) {
                    channelContext.getGroups().remove((Object)groupid);
                }
                if (callbackListener && (groupListener = channelContext.tioConfig.getGroupListener()) != null) {
                    try {
                        groupListener.onAfterUnbind(channelContext, groupid);
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                }
                if (((Set)channelSet.getObj()).size() == 0) {
                    this.groupmap.remove((Object)groupid);
                }
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
    }

    public Comparator<ChannelContext> getChannelContextComparator() {
        return this.channelContextComparator;
    }

    public void setChannelContextComparator(Comparator<ChannelContext> channelContextComparator) {
        this.channelContextComparator = channelContextComparator;
    }
}

