/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.postprocessor;

import de.fau.cs.osr.utils.StringTools;
import de.fau.cs.osr.utils.visitor.VisitorLogic;
import java.util.Iterator;
import org.sweble.wikitext.parser.nodes.WtNewline;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTable;
import org.sweble.wikitext.parser.nodes.WtTableCaption;
import org.sweble.wikitext.parser.nodes.WtTableCell;
import org.sweble.wikitext.parser.nodes.WtTableHeader;
import org.sweble.wikitext.parser.nodes.WtTableRow;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.nodes.WtXmlComment;
import org.sweble.wikitext.parser.nodes.WtXmlEndTag;
import org.sweble.wikitext.parser.nodes.WtXmlStartTag;
import org.sweble.wikitext.parser.postprocessor.ElementType;
import org.sweble.wikitext.parser.postprocessor.InsertionMode;
import org.sweble.wikitext.parser.postprocessor.TreeBuilder;
import org.sweble.wikitext.parser.postprocessor.TreeBuilderModeBase;
import org.sweble.wikitext.parser.postprocessor.WtNodeFlags;

public final class TreeBuilderInTable
extends TreeBuilderModeBase {
    public TreeBuilderInTable(VisitorLogic<WtNode> logic, TreeBuilder treeBuilder) {
        super(logic, treeBuilder);
    }

    public void visit(WtXmlStartTag n) {
        ElementType nodeType = TreeBuilderInTable.getNodeType(n);
        if (nodeType == null) {
            this.anythingElseR16(n);
            return;
        }
        switch (nodeType) {
            case CAPTION: {
                this.startTagR04(n);
                break;
            }
            case COLGROUP: {
                this.startTagR05(n);
                break;
            }
            case COL: {
                this.startTagR06(n);
                break;
            }
            case TBODY: 
            case TFOOT: 
            case THEAD: {
                this.startTagR07(n);
                break;
            }
            case TD: 
            case TH: 
            case TR: {
                this.startTagR08(n);
                break;
            }
            case TABLE: {
                this.startTagR09(n);
                break;
            }
            case P: {
                if (n.getNodeType() == 720944) break;
                this.anythingElseR16(n);
                break;
            }
            default: {
                this.anythingElseR16(n);
                return;
            }
        }
    }

    public void visit(WtXmlEndTag n) {
        ElementType nodeType = TreeBuilderInTable.getNodeType(n);
        if (nodeType == null) {
            this.anythingElseR16(n);
            return;
        }
        switch (nodeType) {
            case TABLE: {
                this.endTagR10(n);
                break;
            }
            case CAPTION: 
            case COLGROUP: 
            case COL: 
            case TBODY: 
            case TFOOT: 
            case THEAD: 
            case TD: 
            case TH: 
            case TR: 
            case PAGE: {
                this.endTagR11(n);
                break;
            }
            case P: {
                if (n.getNodeType() == 720945) break;
                this.anythingElseR16(n);
                break;
            }
            default: {
                this.anythingElseR16(n);
            }
        }
    }

    public void visit(WtNode n) {
        this.anythingElseR16(n);
    }

    public void visit(WtText n) {
        ElementType nodeType = TreeBuilderInTable.getNodeType(this.tb.getCurrentNode());
        if (nodeType == null) {
            this.anythingElseR16(n);
            return;
        }
        switch (nodeType) {
            case TBODY: 
            case TFOOT: 
            case THEAD: 
            case TR: 
            case TABLE: {
                this.tokenR01(n);
                break;
            }
            default: {
                this.anythingElseR16(n);
            }
        }
    }

    public void visit(WtNewline n) {
        this.dispatch(this.getFactory().text(n.getContent()));
    }

    public void visit(WtXmlComment n) {
        this.tokenR02(n);
    }

    public void visit(WtTableCaption n) {
        this.startTagR04(n);
        this.iterate(n.getBody());
        this.dispatch(this.getFactory().createSyntheticEndTag(n));
    }

    public void visit(WtTableCell n) {
        this.startTagR08(n);
    }

    public void visit(WtTableHeader n) {
        this.startTagR08(n);
    }

    public void visit(WtTableRow n) {
        this.startTagR08(n);
    }

    public void visit(WtTable n) {
        this.startTagR09(n);
    }

    private void tokenR01(WtNode node) {
        this.tb.resetPendingTableCharTokens();
        this.tb.setOriginalInsertionMode();
        this.tb.switchInsertionMode(InsertionMode.IN_TABLE_TEXT);
        this.dispatch(node);
    }

    private void tokenR02(WtNode n) {
        this.tb.appendToCurrentNode(n);
    }

    private void startTagR04(WtNode n) {
        this.tb.clearStackBackToTableContext();
        this.tb.insertMarkerInActiveFormattingElements();
        this.tb.insertAnHtmlElement(n);
        this.tb.switchInsertionMode(InsertionMode.IN_CAPTION);
    }

    private void startTagR05(WtNode n) {
        this.tb.clearStackBackToTableContext();
        this.tb.insertAnHtmlElement(n);
        this.tb.switchInsertionMode(InsertionMode.IN_COLUMN_GROUP);
    }

    private void startTagR06(WtNode n) {
        this.dispatch(this.getFactory().createMissingRepairStartTag(ElementType.COLGROUP));
        this.dispatch(n);
    }

    private void startTagR07(WtNode n) {
        this.tb.clearStackBackToTableContext();
        this.tb.insertAnHtmlElement(n);
        this.tb.switchInsertionMode(InsertionMode.IN_TABLE_BODY);
    }

    private void startTagR08(WtNode n) {
        WtNode itbody = this.getFactory().createMissingRepairStartTag(ElementType.TBODY);
        WtNodeFlags.setImplicit(itbody);
        this.dispatch(itbody);
        this.dispatch(n);
    }

    private void startTagR09(WtNode n) {
        this.tb.error(n, "12.2.5.4.9 R09");
        this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.TABLE));
        this.dispatch(n);
    }

    private void endTagR10(WtNode n) {
        TreeBuilderInTable.addRtDataOfEndTag(this.tb.popFromStackUntilIncluding(ElementType.TABLE), n);
        this.tb.resetInsertionMode();
    }

    private void endTagR11(WtNode n) {
        this.tb.error(n, "12.2.5.4.9 R11");
        this.tb.ignore(n);
    }

    private void anythingElseR16(WtNode n) {
        this.tb.error(n, "12.2.5.4.9 R16");
        this.tb.setFosterParentingMode(true);
        this.tb.processInInsertionMode(InsertionMode.IN_BODY, n);
        this.tb.setFosterParentingMode(false);
    }

    public static final class TreeBuilderInCell
    extends TreeBuilderModeBase {
        public TreeBuilderInCell(VisitorLogic<WtNode> logic, TreeBuilder treeBuilder) {
            super(logic, treeBuilder);
        }

        public void visit(WtXmlStartTag n) {
            ElementType nodeType = TreeBuilderInCell.getNodeType(n);
            if (nodeType == null) {
                this.anythingElse(n);
                return;
            }
            switch (nodeType) {
                case CAPTION: 
                case COLGROUP: 
                case COL: 
                case TBODY: 
                case TFOOT: 
                case THEAD: 
                case TD: 
                case TH: 
                case TR: {
                    this.rule02(n);
                    break;
                }
                default: {
                    this.anythingElse(n);
                }
            }
        }

        public void visit(WtXmlEndTag n) {
            ElementType nodeType = TreeBuilderInCell.getNodeType(n);
            if (nodeType == null) {
                this.anythingElse(n);
                return;
            }
            block0 : switch (nodeType) {
                case TD: 
                case TH: {
                    if (!this.tb.isElementTypeInTableScope(nodeType)) {
                        this.tb.error(n, "12.2.5.4.15 R01 (1)");
                        this.tb.ignore(n);
                        break;
                    }
                    this.tb.generateImpliedEndTags();
                    if (TreeBuilderInCell.getNodeType(this.tb.getCurrentNode()) != nodeType) {
                        this.tb.error(n, "12.2.5.4.15 R01 (2)");
                    }
                    TreeBuilderInCell.addRtDataOfEndTag(this.tb.popFromStackUntilIncluding(nodeType), n);
                    this.tb.clearActiveFormattingElementsToLastMarker();
                    this.tb.switchInsertionMode(InsertionMode.IN_ROW);
                    break;
                }
                case CAPTION: 
                case COLGROUP: 
                case COL: 
                case PAGE: {
                    this.tb.error(n, "12.2.5.4.15 R03");
                    this.tb.ignore(n);
                    break;
                }
                case TBODY: 
                case TFOOT: 
                case THEAD: 
                case TR: 
                case TABLE: {
                    if (!this.tb.isElementTypeInTableScope(nodeType)) {
                        switch (nodeType) {
                            case TBODY: 
                            case TFOOT: 
                            case THEAD: {
                                this.tb.error(n, "12.2.5.4.15 R04");
                                this.tb.ignore(n);
                                break block0;
                            }
                        }
                        throw new AssertionError((Object)nodeType.toString());
                    }
                    this.closeCell();
                    this.dispatch(n);
                    break;
                }
                default: {
                    this.anythingElse(n);
                }
            }
        }

        public void visit(WtNode n) {
            this.anythingElse(n);
        }

        public void visit(WtTableCaption n) {
            this.rule02(n);
        }

        public void visit(WtTableCell n) {
            this.rule02(n);
        }

        public void visit(WtTableHeader n) {
            this.rule02(n);
        }

        public void visit(WtTableRow n) {
            this.rule02(n);
        }

        private void rule02(WtNode n) {
            this.closeCell();
            this.dispatch(n);
        }

        private void anythingElse(WtNode n) {
            this.tb.processInInsertionMode(InsertionMode.IN_BODY, n);
        }

        private void closeCell() {
            if (this.tb.isElementTypeInTableScope(ElementType.TD)) {
                this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.TD));
            } else {
                if (!this.tb.isElementTypeInTableScope(ElementType.TH)) {
                    throw new AssertionError();
                }
                this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.TH));
            }
        }
    }

    public static final class TreeBuilderInRow
    extends TreeBuilderModeBase {
        public TreeBuilderInRow(VisitorLogic<WtNode> logic, TreeBuilder treeBuilder) {
            super(logic, treeBuilder);
        }

        public void visit(WtXmlStartTag n) {
            ElementType nodeType = TreeBuilderInRow.getNodeType(n);
            if (nodeType == null) {
                this.anythingElse(n);
                return;
            }
            switch (nodeType) {
                case TD: 
                case TH: {
                    this.rule01(n);
                    break;
                }
                case CAPTION: 
                case COLGROUP: 
                case COL: 
                case TBODY: 
                case TFOOT: 
                case THEAD: 
                case TR: {
                    this.rule03(n);
                    break;
                }
                default: {
                    this.anythingElse(n);
                }
            }
        }

        public void visit(WtXmlEndTag n) {
            ElementType nodeType = TreeBuilderInRow.getNodeType(n);
            if (nodeType == null) {
                this.anythingElse(n);
                return;
            }
            switch (nodeType) {
                case TR: {
                    this.tb.clearStackBackToTableRowContext();
                    WtNode row = this.tb.popFromStack();
                    if (TreeBuilderInRow.getNodeType(row) != ElementType.TR) {
                        throw new AssertionError();
                    }
                    TreeBuilderInRow.addRtDataOfEndTag(row, n);
                    this.tb.switchInsertionMode(InsertionMode.IN_TABLE_BODY);
                    break;
                }
                case TABLE: {
                    this.rule03(n);
                    break;
                }
                case TBODY: 
                case TFOOT: 
                case THEAD: {
                    if (this.tb.isElementTypeInTableScope(nodeType)) {
                        this.tb.error(n, "12.2.5.4.14 R04");
                        this.tb.ignore(n);
                        break;
                    }
                    this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.TR));
                    this.dispatch(n);
                    break;
                }
                case CAPTION: 
                case COLGROUP: 
                case COL: 
                case TD: 
                case TH: 
                case PAGE: {
                    this.tb.error(n, "12.2.5.4.14 R05");
                    this.tb.ignore(n);
                    break;
                }
                default: {
                    this.anythingElse(n);
                }
            }
        }

        public void visit(WtNode n) {
            this.anythingElse(n);
        }

        public void visit(WtTableCell n) {
            this.rule01(n);
            this.iterate(n.getBody());
            this.dispatch(this.getFactory().createSyntheticEndTag(n));
        }

        public void visit(WtTableHeader n) {
            this.rule01(n);
            this.iterate(n.getBody());
            this.dispatch(this.getFactory().createSyntheticEndTag(n));
        }

        public void visit(WtTableCaption n) {
            this.rule03(n);
        }

        public void visit(WtTableRow n) {
            this.rule03(n);
        }

        private void rule01(WtNode n) {
            this.tb.clearStackBackToTableRowContext();
            this.tb.insertAnHtmlElement(n);
            this.tb.switchInsertionMode(InsertionMode.IN_CELL);
            this.tb.insertMarkerInActiveFormattingElements();
        }

        private void rule03(WtNode n) {
            this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.TR));
            this.dispatch(n);
        }

        private void anythingElse(WtNode n) {
            this.tb.processInInsertionMode(InsertionMode.IN_TABLE, n);
        }
    }

    public static final class TreeBuilderInTableBody
    extends TreeBuilderModeBase {
        public TreeBuilderInTableBody(VisitorLogic<WtNode> logic, TreeBuilder treeBuilder) {
            super(logic, treeBuilder);
        }

        public void visit(WtXmlStartTag n) {
            ElementType nodeType = TreeBuilderInTableBody.getNodeType(n);
            if (nodeType == null) {
                this.anythingElse(n);
                return;
            }
            switch (nodeType) {
                case TR: {
                    this.rule01(n);
                    break;
                }
                case TD: 
                case TH: {
                    this.rule02(n);
                    break;
                }
                case CAPTION: 
                case COLGROUP: 
                case COL: 
                case TBODY: 
                case TFOOT: 
                case THEAD: {
                    this.rule04(n);
                    break;
                }
                default: {
                    this.anythingElse(n);
                }
            }
        }

        public void visit(WtXmlEndTag n) {
            ElementType nodeType = TreeBuilderInTableBody.getNodeType(n);
            if (nodeType == null) {
                this.anythingElse(n);
                return;
            }
            switch (nodeType) {
                case TBODY: 
                case TFOOT: 
                case THEAD: {
                    if (!this.tb.isElementTypeInTableScope(nodeType)) {
                        this.tb.error(n, "12.2.5.4.13 R03");
                        this.tb.ignore(n);
                        break;
                    }
                    this.tb.clearStackBackToTableBodyContext();
                    TreeBuilderInTableBody.addRtDataOfEndTag(this.tb.popFromStack(), n);
                    this.tb.switchInsertionMode(InsertionMode.IN_TABLE);
                    break;
                }
                case TABLE: {
                    this.rule04(n);
                    break;
                }
                case CAPTION: 
                case COLGROUP: 
                case COL: 
                case TD: 
                case TH: 
                case TR: 
                case PAGE: {
                    this.tb.error(n, "12.2.5.4.13 R05");
                    this.tb.ignore(n);
                    break;
                }
                default: {
                    this.anythingElse(n);
                }
            }
        }

        public void visit(WtNode n) {
            this.anythingElse(n);
        }

        public void visit(WtTableRow n) {
            this.rule01(n);
            this.iterate(n.getBody());
            this.dispatch(this.getFactory().createSyntheticEndTag(n));
        }

        public void visit(WtTableHeader n) {
            this.rule02(n);
        }

        public void visit(WtTableCell n) {
            this.rule02(n);
        }

        public void visit(WtTableCaption n) {
            this.rule04(n);
        }

        private void rule01(WtNode n) {
            this.tb.clearStackBackToTableBodyContext();
            this.tb.insertAnHtmlElement(n);
            this.tb.switchInsertionMode(InsertionMode.IN_ROW);
        }

        private void rule02(WtNode n) {
            WtNode table = this.tb.getFromStack(ElementType.TABLE);
            if (table.getNodeType() == 720911 && !this.hasRows((WtTable)table)) {
                WtNode tr = this.getFactory().createMissingRepairStartTag(ElementType.TR);
                WtNodeFlags.setImplicit(tr);
                this.dispatch(tr);
                this.dispatch(n);
            } else {
                this.tb.error(n, "12.2.5.4.13 R02");
                this.dispatch(this.getFactory().createMissingRepairStartTag(ElementType.TR));
                this.dispatch(n);
            }
        }

        private boolean hasRows(WtTable table) {
            Iterator iterator = table.getBody().iterator();
            block6: while (iterator.hasNext()) {
                WtNode n = (WtNode)iterator.next();
                switch (n.getNodeType()) {
                    case 720946: {
                        Iterator iterator2 = n.iterator();
                        while (iterator2.hasNext()) {
                            WtNode rows = (WtNode)iterator2.next();
                            if (TreeBuilderInTableBody.getNodeType(rows) != ElementType.TR) continue;
                            return true;
                        }
                        return false;
                    }
                    case 4097: {
                        continue block6;
                    }
                    case 720912: {
                        continue block6;
                    }
                    case 720932: {
                        if (TreeBuilderInTableBody.getNodeType(n) != ElementType.CAPTION) break;
                        continue block6;
                    }
                }
                throw new AssertionError();
            }
            return false;
        }

        private void rule04(WtNode n) {
            this.tb.clearStackBackToTableBodyContext();
            ElementType curNodeType = TreeBuilderInTableBody.getNodeType(this.tb.getCurrentNode());
            switch (curNodeType) {
                case TBODY: 
                case TFOOT: 
                case THEAD: {
                    this.dispatch(this.getFactory().createMissingRepairEndTag(curNodeType));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.dispatch(n);
        }

        private void anythingElse(WtNode n) {
            this.tb.processInInsertionMode(InsertionMode.IN_TABLE, n);
        }
    }

    public static final class TreeBuilderInColumnGroup
    extends TreeBuilderModeBase {
        public TreeBuilderInColumnGroup(VisitorLogic<WtNode> logic, TreeBuilder treeBuilder) {
            super(logic, treeBuilder);
        }

        public void visit(WtXmlStartTag n) {
            ElementType nodeType = TreeBuilderInColumnGroup.getNodeType(n);
            if (nodeType == null) {
                this.anythingElse(n);
            } else if (nodeType == ElementType.COL) {
                this.tb.insertAnHtmlElement(n);
                this.tb.popFromStack();
            } else {
                this.anythingElse(n);
            }
        }

        public void visit(WtXmlEndTag n) {
            ElementType nodeType = TreeBuilderInColumnGroup.getNodeType(n);
            if (nodeType == null) {
                this.anythingElse(n);
            } else if (nodeType == ElementType.COLGROUP) {
                if (TreeBuilderInColumnGroup.getNodeType(this.tb.popFromStack()) != ElementType.COLGROUP) {
                    throw new AssertionError();
                }
                this.tb.switchInsertionMode(InsertionMode.IN_TABLE);
            } else if (nodeType == ElementType.COL) {
                this.tb.error(n, "12.2.5.4.12 R07");
                this.tb.ignore(n);
            } else {
                this.anythingElse(n);
            }
        }

        public void visit(WtNode n) {
            throw new AssertionError();
        }

        public void visit(WtText n) {
            if (StringTools.isWhitespace((String)n.getContent())) {
                this.tb.insertText(n);
            } else {
                this.anythingElse(n);
            }
        }

        public void visit(WtNewline n) {
            this.dispatch(this.getFactory().text(n.getContent()));
        }

        public void visit(WtXmlComment n) {
            this.tb.appendToCurrentNode(n);
        }

        private void anythingElse(WtNode n) {
            this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.COLGROUP));
            this.dispatch(n);
        }
    }

    public static final class TreeBuilderInCaption
    extends TreeBuilderModeBase {
        public TreeBuilderInCaption(VisitorLogic<WtNode> logic, TreeBuilder treeBuilder) {
            super(logic, treeBuilder);
        }

        public void visit(WtXmlStartTag n) {
            ElementType nodeType = TreeBuilderInCaption.getNodeType(n);
            if (nodeType == null) {
                this.anythingElse(n);
                return;
            }
            switch (nodeType) {
                case CAPTION: 
                case COLGROUP: 
                case COL: 
                case TBODY: 
                case TFOOT: 
                case THEAD: 
                case TD: 
                case TH: 
                case TR: {
                    this.rule02(n);
                    break;
                }
                default: {
                    this.anythingElse(n);
                }
            }
        }

        public void visit(WtXmlEndTag n) {
            ElementType nodeType = TreeBuilderInCaption.getNodeType(n);
            if (nodeType == null) {
                this.anythingElse(n);
                return;
            }
            switch (nodeType) {
                case CAPTION: {
                    this.tb.generateImpliedEndTags();
                    if (!TreeBuilderInCaption.isNodeOneOf(this.tb.getCurrentNode(), ElementType.CAPTION)) {
                        this.tb.error(n, "12.2.5.4.11 R01 (2)");
                    }
                    TreeBuilderInCaption.addRtDataOfEndTag(this.tb.popFromStackUntilIncluding(ElementType.CAPTION), n);
                    this.tb.clearActiveFormattingElementsToLastMarker();
                    this.tb.switchInsertionMode(InsertionMode.IN_TABLE);
                    break;
                }
                case TABLE: {
                    this.rule02(n);
                    break;
                }
                case COLGROUP: 
                case COL: 
                case TBODY: 
                case TFOOT: 
                case THEAD: 
                case TD: 
                case TH: 
                case TR: 
                case PAGE: {
                    this.tb.error(n, "12.2.5.4.11 R03");
                    this.tb.ignore(n);
                    break;
                }
                default: {
                    this.anythingElse(n);
                }
            }
        }

        public void visit(WtNode n) {
            this.anythingElse(n);
        }

        private void rule02(WtNode n) {
            this.tb.error(n, "12.2.5.4.11 R02");
            this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.CAPTION));
            this.dispatch(n);
        }

        public void visit(WtTableCaption n) {
            this.rule02(n);
        }

        public void visit(WtTableCell n) {
            this.rule02(n);
        }

        public void visit(WtTableHeader n) {
            this.rule02(n);
        }

        public void visit(WtTableRow n) {
            this.rule02(n);
        }

        private void anythingElse(WtNode n) {
            this.tb.processInInsertionMode(InsertionMode.IN_BODY, n);
        }
    }

    public static final class TreeBuilderInTableText
    extends TreeBuilderModeBase {
        public TreeBuilderInTableText(VisitorLogic<WtNode> logic, TreeBuilder treeBuilder) {
            super(logic, treeBuilder);
        }

        public void visit(WtNode n) {
            WtText textNode = this.getFactory().text(this.tb.getPendingTableCharTokens());
            if (StringTools.isWhitespace((String)textNode.getContent())) {
                this.tb.insertText(textNode);
            } else {
                ((TreeBuilderInTable)this.tb.getModeImpl(InsertionMode.IN_TABLE)).anythingElseR16(textNode);
            }
            this.tb.resetToOriginalInsertionMode();
            this.dispatch(n);
        }

        public void visit(WtText n) {
            this.tb.appendToPendingTableCharTokens(n.getContent());
        }

        public void visit(WtNewline n) {
            this.dispatch(this.getFactory().text(n.getContent()));
        }
    }
}

