/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.postprocessor;

import org.sweble.wikitext.parser.postprocessor.ElementType;

public enum StackScope {
    GENERAL_SCOPE_WITHOUT_LAZY_PARSED_PAGE{

        @Override
        public boolean isInList(ElementType nodeType) {
            switch (nodeType) {
                case SECTION_HEADING: 
                case SECTION_BODY: 
                case CAPTION: 
                case TABLE: 
                case TD: 
                case TH: {
                    return true;
                }
            }
            return false;
        }
    }
    ,
    GENERAL_SCOPE{

        @Override
        public boolean isInList(ElementType nodeType) {
            switch (nodeType) {
                case PAGE: {
                    return true;
                }
            }
            return GENERAL_SCOPE_WITHOUT_LAZY_PARSED_PAGE.isInList(nodeType);
        }
    }
    ,
    BUTTON_SCOPE{

        @Override
        public boolean isInList(ElementType nodeType) {
            switch (nodeType) {
                default: 
            }
            return GENERAL_SCOPE.isInList(nodeType);
        }
    }
    ,
    LIST_ITEM_SCOPE{

        @Override
        public boolean isInList(ElementType nodeType) {
            switch (nodeType) {
                case UL: 
                case OL: {
                    return true;
                }
            }
            return GENERAL_SCOPE.isInList(nodeType);
        }
    }
    ,
    TABLE_SCOPE{

        @Override
        public boolean isInList(ElementType nodeType) {
            switch (nodeType) {
                case TABLE: 
                case PAGE: {
                    return true;
                }
            }
            return false;
        }
    };


    public abstract boolean isInList(ElementType var1);
}

