/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.http;

import java.io.IOException;
import java.time.Instant;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.Order;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.web.http.CookieHttpSessionIdResolver;
import org.springframework.session.web.http.HttpSessionAdapter;
import org.springframework.session.web.http.HttpSessionIdResolver;
import org.springframework.session.web.http.OnCommittedResponseWrapper;
import org.springframework.session.web.http.OncePerRequestFilter;
import org.springframework.session.web.http.SessionRepositoryFilter;

@Order(value=-2147483598)
public class SessionRepositoryFilter<S extends Session>
extends OncePerRequestFilter {
    private static final String SESSION_LOGGER_NAME = SessionRepositoryFilter.class.getName().concat(".SESSION_LOGGER");
    private static final Log SESSION_LOGGER = LogFactory.getLog((String)SESSION_LOGGER_NAME);
    public static final String SESSION_REPOSITORY_ATTR = SessionRepository.class.getName();
    public static final String INVALID_SESSION_ID_ATTR = SESSION_REPOSITORY_ATTR + ".invalidSessionId";
    private static final String CURRENT_SESSION_ATTR = SESSION_REPOSITORY_ATTR + ".CURRENT_SESSION";
    public static final int DEFAULT_ORDER = -2147483598;
    private final SessionRepository<S> sessionRepository;
    private ServletContext servletContext;
    private HttpSessionIdResolver httpSessionIdResolver = new CookieHttpSessionIdResolver();

    public SessionRepositoryFilter(SessionRepository<S> sessionRepository) {
        if (sessionRepository == null) {
            throw new IllegalArgumentException("sessionRepository cannot be null");
        }
        this.sessionRepository = sessionRepository;
    }

    public void setHttpSessionIdResolver(HttpSessionIdResolver httpSessionIdResolver) {
        if (httpSessionIdResolver == null) {
            throw new IllegalArgumentException("httpSessionIdResolver cannot be null");
        }
        this.httpSessionIdResolver = httpSessionIdResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        request.setAttribute(SESSION_REPOSITORY_ATTR, this.sessionRepository);
        SessionRepositoryRequestWrapper wrappedRequest = new SessionRepositoryRequestWrapper(request, response, this.servletContext);
        SessionRepositoryResponseWrapper wrappedResponse = new SessionRepositoryResponseWrapper(wrappedRequest, response);
        try {
            filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        }
        finally {
            wrappedRequest.commitSession();
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private final class SessionRepositoryRequestWrapper
    extends HttpServletRequestWrapper {
        private Boolean requestedSessionIdValid;
        private boolean requestedSessionInvalidated;
        private final HttpServletResponse response;
        private final ServletContext servletContext;

        private SessionRepositoryRequestWrapper(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
            super(request);
            this.response = response;
            this.servletContext = servletContext;
        }

        private void commitSession() {
            HttpSessionWrapper wrappedSession = this.getCurrentSession();
            if (wrappedSession == null) {
                if (this.isInvalidateClientSession()) {
                    SessionRepositoryFilter.this.httpSessionIdResolver.expireSession((HttpServletRequest)this, this.response);
                }
            } else {
                Object session = wrappedSession.getSession();
                SessionRepositoryFilter.this.sessionRepository.save(session);
                String sessionId = session.getId();
                if (!this.isRequestedSessionIdValid() || !sessionId.equals(this.getRequestedSessionId())) {
                    SessionRepositoryFilter.this.httpSessionIdResolver.setSessionId((HttpServletRequest)this, this.response, sessionId);
                }
            }
        }

        private org.springframework.session.web.http.SessionRepositoryFilter$SessionRepositoryRequestWrapper.HttpSessionWrapper getCurrentSession() {
            return (HttpSessionWrapper)this.getAttribute(CURRENT_SESSION_ATTR);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void setCurrentSession(HttpSessionWrapper currentSession) {
            if (currentSession == null) {
                this.removeAttribute(CURRENT_SESSION_ATTR);
            } else {
                this.setAttribute(CURRENT_SESSION_ATTR, currentSession);
            }
        }

        public String changeSessionId() {
            HttpSession session = this.getSession(false);
            if (session == null) {
                throw new IllegalStateException("Cannot change session ID. There is no session associated with this request.");
            }
            return this.getCurrentSession().getSession().changeSessionId();
        }

        public boolean isRequestedSessionIdValid() {
            if (this.requestedSessionIdValid == null) {
                String sessionId = this.getRequestedSessionId();
                Object session = sessionId == null ? null : (Object)this.getSession(sessionId);
                return this.isRequestedSessionIdValid(session);
            }
            return this.requestedSessionIdValid;
        }

        private boolean isRequestedSessionIdValid(S session) {
            if (this.requestedSessionIdValid == null) {
                this.requestedSessionIdValid = session != null;
            }
            return this.requestedSessionIdValid;
        }

        private boolean isInvalidateClientSession() {
            return this.getCurrentSession() == null && this.requestedSessionInvalidated;
        }

        private S getSession(String sessionId) {
            Object session = SessionRepositoryFilter.this.sessionRepository.findById(sessionId);
            if (session == null) {
                return null;
            }
            session.setLastAccessedTime(Instant.now());
            return session;
        }

        public org.springframework.session.web.http.SessionRepositoryFilter$SessionRepositoryRequestWrapper.HttpSessionWrapper getSession(boolean create) {
            HttpSessionWrapper currentSession = this.getCurrentSession();
            if (currentSession != null) {
                return currentSession;
            }
            String requestedSessionId = this.getRequestedSessionId();
            if (requestedSessionId != null) {
                if (this.getAttribute(INVALID_SESSION_ID_ATTR) == null) {
                    Object session = this.getSession(requestedSessionId);
                    this.requestedSessionIdValid = true;
                    currentSession = new HttpSessionWrapper(this, session, this.getServletContext());
                    currentSession.setNew(false);
                    this.setCurrentSession(currentSession);
                    return currentSession;
                }
            } else {
                if (SESSION_LOGGER.isDebugEnabled()) {
                    SESSION_LOGGER.debug((Object)"No session found by id: Caching result for getSession(false) for this HttpServletRequest.");
                }
                this.setAttribute(INVALID_SESSION_ID_ATTR, "true");
            }
            if (!create) {
                return null;
            }
            if (SESSION_LOGGER.isDebugEnabled()) {
                SESSION_LOGGER.debug((Object)("A new session was created. To help you troubleshoot where the session was created we provided a StackTrace (this is not an error). You can prevent this from appearing by disabling DEBUG logging for " + SESSION_LOGGER_NAME), (Throwable)new RuntimeException("For debugging purposes only (not an error)"));
            }
            Object session = SessionRepositoryFilter.this.sessionRepository.createSession();
            session.setLastAccessedTime(Instant.now());
            currentSession = new HttpSessionWrapper(this, session, this.getServletContext());
            this.setCurrentSession(currentSession);
            return currentSession;
        }

        public ServletContext getServletContext() {
            if (this.servletContext != null) {
                return this.servletContext;
            }
            return super.getServletContext();
        }

        public org.springframework.session.web.http.SessionRepositoryFilter$SessionRepositoryRequestWrapper.HttpSessionWrapper getSession() {
            return this.getSession(true);
        }

        public String getRequestedSessionId() {
            return SessionRepositoryFilter.this.httpSessionIdResolver.resolveSessionIds((HttpServletRequest)this).stream().filter(sessionId -> SessionRepositoryFilter.this.sessionRepository.findById((String)sessionId) != null).findFirst().orElse(null);
        }

        private static final class HttpSessionWrapper
        extends HttpSessionAdapter<S> {
            final /* synthetic */ SessionRepositoryRequestWrapper this$1;

            HttpSessionWrapper(S session, ServletContext servletContext) {
                this.this$1 = var1_1;
                super(session, servletContext);
            }

            @Override
            public void invalidate() {
                super.invalidate();
                this.this$1.requestedSessionInvalidated = true;
                this.this$1.setCurrentSession(null);
                this.this$1.SessionRepositoryFilter.this.sessionRepository.deleteById(this.getId());
            }
        }
    }

    private final class SessionRepositoryResponseWrapper
    extends OnCommittedResponseWrapper {
        private final SessionRepositoryRequestWrapper request;

        SessionRepositoryResponseWrapper(SessionRepositoryRequestWrapper request, HttpServletResponse response) {
            super(response);
            if (request == null) {
                throw new IllegalArgumentException("request cannot be null");
            }
            this.request = request;
        }

        @Override
        protected void onResponseCommitted() {
            this.request.commitSession();
        }
    }
}

