/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.http;

import java.time.Duration;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.springframework.session.Session;

class HttpSessionAdapter<S extends Session>
implements HttpSession {
    private S session;
    private final ServletContext servletContext;
    private boolean invalidated;
    private boolean old;
    private static final HttpSessionContext NOOP_SESSION_CONTEXT = new HttpSessionContext(){

        public HttpSession getSession(String sessionId) {
            return null;
        }

        public Enumeration<String> getIds() {
            return EMPTY_ENUMERATION;
        }
    };
    private static final Enumeration<String> EMPTY_ENUMERATION = new Enumeration<String>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public String nextElement() {
            throw new NoSuchElementException("a");
        }
    };

    HttpSessionAdapter(S session, ServletContext servletContext) {
        if (session == null) {
            throw new IllegalArgumentException("session cannot be null");
        }
        if (servletContext == null) {
            throw new IllegalArgumentException("servletContext cannot be null");
        }
        this.session = session;
        this.servletContext = servletContext;
    }

    public void setSession(S session) {
        this.session = session;
    }

    public S getSession() {
        return this.session;
    }

    public long getCreationTime() {
        this.checkState();
        return this.session.getCreationTime().toEpochMilli();
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        this.checkState();
        return this.session.getLastAccessedTime().toEpochMilli();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(Duration.ofSeconds(interval));
    }

    public int getMaxInactiveInterval() {
        return (int)this.session.getMaxInactiveInterval().getSeconds();
    }

    public HttpSessionContext getSessionContext() {
        return NOOP_SESSION_CONTEXT;
    }

    public Object getAttribute(String name) {
        this.checkState();
        return this.session.getAttribute(name);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.checkState();
        return Collections.enumeration(this.session.getAttributeNames());
    }

    public String[] getValueNames() {
        this.checkState();
        Set<String> attrs = this.session.getAttributeNames();
        return attrs.toArray(new String[0]);
    }

    public void setAttribute(String name, Object value) {
        this.checkState();
        this.session.setAttribute(name, value);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.checkState();
        this.session.removeAttribute(name);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.checkState();
        this.invalidated = true;
    }

    public void setNew(boolean isNew) {
        this.old = !isNew;
    }

    public boolean isNew() {
        this.checkState();
        return !this.old;
    }

    private void checkState() {
        if (this.invalidated) {
            throw new IllegalStateException("The HttpSession has already be invalidated.");
        }
    }
}

