/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.redis.inbound.RedisInboundChannelAdapter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RedisInboundChannelAdapterParser
extends AbstractChannelAdapterParser {
    protected AbstractBeanDefinition doParse(Element element, ParserContext parserContext, String channelName) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(RedisInboundChannelAdapter.class);
        String connectionFactory = element.getAttribute("connection-factory");
        if (!StringUtils.hasText((String)connectionFactory)) {
            connectionFactory = "redisConnectionFactory";
        }
        builder.addConstructorArgReference(connectionFactory);
        builder.addPropertyReference("outputChannel", channelName);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"topics");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"topic-patterns");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-channel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converter");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"serializer", (boolean)true);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"task-executor");
        return builder.getBeanDefinition();
    }
}

