/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import javax.net.ssl.SSLSession;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.connection.NoListenerException;
import org.springframework.integration.ip.tcp.connection.SocketInfo;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptor;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.ErrorMessage;

public abstract class TcpConnectionInterceptorSupport
extends TcpConnectionSupport
implements TcpConnectionInterceptor {
    private TcpConnectionSupport theConnection;
    private TcpListener tcpListener;
    private TcpSender tcpSender;
    private Boolean realSender;

    public TcpConnectionInterceptorSupport() {
    }

    public TcpConnectionInterceptorSupport(ApplicationEventPublisher applicationEventPublisher) {
        super(applicationEventPublisher);
    }

    @Override
    public void close() {
        this.theConnection.close();
    }

    @Override
    public boolean isOpen() {
        return this.theConnection.isOpen();
    }

    @Override
    public Object getPayload() throws Exception {
        return this.theConnection.getPayload();
    }

    @Override
    public String getHostName() {
        return this.theConnection.getHostName();
    }

    @Override
    public String getHostAddress() {
        return this.theConnection.getHostAddress();
    }

    @Override
    public int getPort() {
        return this.theConnection.getPort();
    }

    @Override
    public Object getDeserializerStateKey() {
        return this.theConnection.getDeserializerStateKey();
    }

    @Override
    public void registerListener(TcpListener listener) {
        this.tcpListener = listener;
        this.theConnection.registerListener(this);
    }

    @Override
    public void registerSender(TcpSender sender) {
        this.tcpSender = sender;
        this.theConnection.registerSender(this);
    }

    @Override
    public String getConnectionId() {
        return this.theConnection.getConnectionId();
    }

    @Override
    public SocketInfo getSocketInfo() {
        return this.theConnection.getSocketInfo();
    }

    @Override
    public String getConnectionFactoryName() {
        return this.theConnection.getConnectionFactoryName();
    }

    @Override
    public void run() {
        this.theConnection.run();
    }

    @Override
    public void setMapper(TcpMessageMapper mapper) {
        this.theConnection.setMapper(mapper);
    }

    @Override
    public Deserializer<?> getDeserializer() {
        return this.theConnection.getDeserializer();
    }

    @Override
    public void setDeserializer(Deserializer<?> deserializer) {
        this.theConnection.setDeserializer(deserializer);
    }

    @Override
    public Serializer<?> getSerializer() {
        return this.theConnection.getSerializer();
    }

    @Override
    public void setSerializer(Serializer<?> serializer) {
        this.theConnection.setSerializer(serializer);
    }

    @Override
    public boolean isServer() {
        return this.theConnection.isServer();
    }

    @Override
    public SSLSession getSslSession() {
        return this.theConnection.getSslSession();
    }

    @Override
    public boolean onMessage(Message<?> message) {
        if (this.tcpListener == null) {
            if (message instanceof ErrorMessage) {
                return false;
            }
            throw new NoListenerException("No listener registered for message reception");
        }
        return this.tcpListener.onMessage(message);
    }

    @Override
    public void send(Message<?> message) throws Exception {
        this.theConnection.send(message);
    }

    public TcpConnectionSupport getTheConnection() {
        return this.theConnection;
    }

    public void setTheConnection(TcpConnectionSupport theConnection) {
        this.theConnection = theConnection;
    }

    @Override
    public TcpListener getListener() {
        return this.tcpListener;
    }

    @Override
    public void addNewConnection(TcpConnection connection) {
        if (this.tcpSender != null) {
            this.tcpSender.addNewConnection(this);
        }
    }

    @Override
    public void removeDeadConnection(TcpConnection connection) {
        if (this.tcpSender != null) {
            this.tcpSender.removeDeadConnection(this);
        }
    }

    @Override
    public long incrementAndGetConnectionSequence() {
        return this.theConnection.incrementAndGetConnectionSequence();
    }

    @Override
    public TcpSender getSender() {
        return this.tcpSender;
    }

    protected boolean hasRealSender() {
        if (this.realSender != null) {
            return this.realSender;
        }
        TcpSender sender = this.getSender();
        while (sender instanceof TcpConnectionInterceptorSupport) {
            sender = ((TcpConnectionInterceptorSupport)sender).getSender();
        }
        this.realSender = sender != null;
        return this.realSender;
    }
}

