/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.expression;

import java.beans.Introspector;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.expression.IndexAccessor;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TargetedAccessor;
import org.springframework.util.Assert;

public class SpelPropertyAccessorRegistrar {
    private final Map<String, PropertyAccessor> propertyAccessors = new LinkedHashMap<String, PropertyAccessor>();
    private final Map<String, IndexAccessor> indexAccessors = new LinkedHashMap<String, IndexAccessor>();

    public SpelPropertyAccessorRegistrar() {
    }

    public SpelPropertyAccessorRegistrar(PropertyAccessor ... propertyAccessors) {
        Assert.notEmpty((Object[])propertyAccessors, (String)"'propertyAccessors' must not be empty");
        for (PropertyAccessor propertyAccessor : propertyAccessors) {
            this.propertyAccessors.put(SpelPropertyAccessorRegistrar.obtainAccessorKey((TargetedAccessor)propertyAccessor), propertyAccessor);
        }
    }

    public SpelPropertyAccessorRegistrar(Map<String, PropertyAccessor> propertyAccessors) {
        Assert.notEmpty(propertyAccessors, (String)"'propertyAccessors' must not be empty");
        this.propertyAccessors.putAll(propertyAccessors);
    }

    public Map<String, PropertyAccessor> getPropertyAccessors() {
        return this.propertyAccessors;
    }

    public void setIndexAccessors(Map<String, IndexAccessor> indexAccessors) {
        Assert.notEmpty(indexAccessors, (String)"'indexAccessors' must not be empty");
        this.indexAccessors.putAll(indexAccessors);
    }

    public Map<String, IndexAccessor> getIndexAccessors() {
        return this.indexAccessors;
    }

    public SpelPropertyAccessorRegistrar add(String name, PropertyAccessor propertyAccessor) {
        Assert.hasText((String)name, (String)"'name' must not be empty");
        Assert.notNull((Object)propertyAccessor, (String)"'propertyAccessor' must not be null");
        this.propertyAccessors.put(name, propertyAccessor);
        return this;
    }

    public SpelPropertyAccessorRegistrar add(PropertyAccessor ... propertyAccessors) {
        Assert.notEmpty((Object[])propertyAccessors, (String)"'propertyAccessors' must not be empty");
        for (PropertyAccessor propertyAccessor : propertyAccessors) {
            this.propertyAccessors.put(SpelPropertyAccessorRegistrar.obtainAccessorKey((TargetedAccessor)propertyAccessor), propertyAccessor);
        }
        return this;
    }

    public SpelPropertyAccessorRegistrar add(String name, IndexAccessor indexAccessor) {
        Assert.hasText((String)name, (String)"'name' must not be empty");
        Assert.notNull((Object)indexAccessor, (String)"'indexAccessor' must not be null");
        this.indexAccessors.put(name, indexAccessor);
        return this;
    }

    public SpelPropertyAccessorRegistrar add(IndexAccessor ... indexAccessors) {
        Assert.notEmpty((Object[])indexAccessors, (String)"'indexAccessors' must not be empty");
        for (IndexAccessor indexAccessor : indexAccessors) {
            this.indexAccessors.put(SpelPropertyAccessorRegistrar.obtainAccessorKey((TargetedAccessor)indexAccessor), indexAccessor);
        }
        return this;
    }

    private static String obtainAccessorKey(TargetedAccessor targetedAccessor) {
        return Introspector.decapitalize(targetedAccessor.getClass().getSimpleName());
    }
}

