/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.util.concurrent.Callable;

@FunctionalInterface
public interface CheckedCallable<T, E extends Throwable> {
    public T call() throws E;

    default public Callable<T> unchecked() {
        return () -> {
            try {
                return this.call();
            }
            catch (Throwable t) {
                if (t instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)t;
                    throw runtimeException;
                }
                if (t instanceof Error) {
                    Error error = (Error)t;
                    throw error;
                }
                throw new IllegalStateException(t);
            }
        };
    }

    @Deprecated(since="6.5", forRemoval=true)
    default public Callable<T> uncheckedCallable() {
        return this.unchecked();
    }
}

