/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import org.springframework.integration.StaticMessageHeaderAccessor;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class StreamTransformer
extends AbstractTransformer {
    private final String charset;

    public StreamTransformer() {
        this(null);
    }

    public StreamTransformer(String charset) {
        this.charset = charset;
    }

    @Override
    protected Object doTransform(Message<?> message) {
        try {
            Assert.isTrue((boolean)(message.getPayload() instanceof InputStream), (String)"payload must be an InputStream");
            InputStream stream = (InputStream)message.getPayload();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileCopyUtils.copy((InputStream)stream, (OutputStream)baos);
            Object result = this.charset == null ? baos.toByteArray() : (byte[])baos.toString(this.charset);
            Closeable closeableResource = StaticMessageHeaderAccessor.getCloseableResource(message);
            if (closeableResource != null) {
                closeableResource.close();
                result = this.getMessageBuilderFactory().withPayload(result).copyHeaders((Map<String, ?>)message.getHeaders()).removeHeader("closeableResource").build();
            }
            return result;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

