/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gateway;

import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.integration.gateway.AsyncRequestReplyExchanger;
import org.springframework.integration.gateway.GatewayProxyFactoryBean;
import org.springframework.integration.gateway.RequestReplyExchanger;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public class GatewayMessageHandler
extends AbstractReplyProducingMessageHandler
implements ManageableLifecycle {
    private final Lock lock = new ReentrantLock();
    private volatile GatewayProxyFactoryBean<?> gatewayProxyFactoryBean;
    private volatile Object exchanger;
    private volatile boolean running;
    private MessageChannel requestChannel;
    private String requestChannelName;
    private MessageChannel replyChannel;
    private String replyChannelName;
    private MessageChannel errorChannel;
    private String errorChannelName;
    private Long requestTimeout;
    private Long replyTimeout;
    private boolean errorOnTimeout;
    private Executor executor = new SimpleAsyncTaskExecutor();

    public void setRequestChannel(MessageChannel requestChannel) {
        this.requestChannel = requestChannel;
    }

    public void setRequestChannelName(String requestChannel) {
        this.requestChannelName = requestChannel;
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.replyChannel = replyChannel;
    }

    public void setReplyChannelName(String replyChannel) {
        this.replyChannelName = replyChannel;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void setErrorChannelName(String errorChannel) {
        this.errorChannelName = errorChannel;
    }

    public void setRequestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setReplyTimeout(Long replyTimeout) {
        this.replyTimeout = replyTimeout;
    }

    public void setErrorOnTimeout(boolean errorOnTimeout) {
        this.errorOnTimeout = errorOnTimeout;
    }

    public void setAsyncExecutor(@Nullable Executor executor) {
        this.executor = executor;
    }

    @Override
    protected Object handleRequestMessage(Message<?> requestMessage) {
        if (this.exchanger == null) {
            this.lock.lock();
            try {
                if (this.exchanger == null) {
                    this.initialize();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.isAsync() ? ((AsyncRequestReplyExchanger)this.exchanger).exchange(requestMessage) : ((RequestReplyExchanger)this.exchanger).exchange(requestMessage);
    }

    private void initialize() {
        BeanFactory beanFactory;
        this.gatewayProxyFactoryBean = this.isAsync() ? new GatewayProxyFactoryBean<AsyncRequestReplyExchanger>(AsyncRequestReplyExchanger.class) : new GatewayProxyFactoryBean<RequestReplyExchanger>(RequestReplyExchanger.class);
        this.gatewayProxyFactoryBean.setDefaultRequestChannel(this.requestChannel);
        this.gatewayProxyFactoryBean.setDefaultRequestChannelName(this.requestChannelName);
        this.gatewayProxyFactoryBean.setDefaultReplyChannel(this.replyChannel);
        this.gatewayProxyFactoryBean.setDefaultReplyChannelName(this.replyChannelName);
        this.gatewayProxyFactoryBean.setErrorChannel(this.errorChannel);
        this.gatewayProxyFactoryBean.setErrorChannelName(this.errorChannelName);
        this.gatewayProxyFactoryBean.setErrorOnTimeout(this.errorOnTimeout);
        this.gatewayProxyFactoryBean.setAsyncExecutor(this.executor);
        if (this.requestTimeout != null) {
            this.gatewayProxyFactoryBean.setDefaultRequestTimeout(this.requestTimeout);
        }
        if (this.replyTimeout != null) {
            this.gatewayProxyFactoryBean.setDefaultReplyTimeout(this.replyTimeout);
        }
        if ((beanFactory = this.getBeanFactory()) instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
            configurableListableBeanFactory.initializeBean(this.gatewayProxyFactoryBean, this.getComponentName() + "#gpfb");
        }
        try {
            this.exchanger = this.gatewayProxyFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new BeanCreationException("Can't instantiate the GatewayProxyFactoryBean: " + String.valueOf(this), (Throwable)e);
        }
        if (this.running) {
            this.gatewayProxyFactoryBean.stop();
            this.gatewayProxyFactoryBean.start();
        }
    }

    @Override
    public void start() {
        if (this.exchanger == null) {
            this.lock.lock();
            try {
                if (this.exchanger == null) {
                    this.initialize();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        this.gatewayProxyFactoryBean.start();
        this.running = true;
    }

    @Override
    public void stop() {
        this.gatewayProxyFactoryBean.stop();
        this.running = false;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }
}

