/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gateway;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.JavaUtils;
import org.springframework.integration.annotation.GatewayHeader;
import org.springframework.integration.annotation.MessagingGateway;
import org.springframework.integration.gateway.GatewayMethodMetadata;
import org.springframework.integration.gateway.GatewayProxyFactoryBean;
import org.springframework.integration.gateway.MethodArgsMessageMapper;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AnnotationGatewayProxyFactoryBean<T>
extends GatewayProxyFactoryBean<T> {
    private final AnnotationAttributes gatewayAttributes;
    private BeanExpressionResolver resolver = new StandardBeanExpressionResolver();
    private BeanExpressionContext expressionContext;

    public AnnotationGatewayProxyFactoryBean(Class<T> serviceInterface) {
        super(serviceInterface);
        this.gatewayAttributes = AnnotationGatewayProxyFactoryBean.mergeAnnotationAttributes(serviceInterface);
    }

    private static AnnotationAttributes mergeAnnotationAttributes(Class<?> serviceInterface) {
        AnnotationAttributes annotationAttributes = AnnotationUtils.getAnnotationAttributes(null, (Annotation)AnnotationUtils.synthesizeAnnotation(MessagingGateway.class));
        if (AnnotatedElementUtils.isAnnotated(serviceInterface, MessagingGateway.class)) {
            Annotation annotation = MergedAnnotations.from(serviceInterface).get(MessagingGateway.class).getRoot().synthesize();
            List<Annotation> annotationChain = MessagingAnnotationUtils.getAnnotationChain(annotation, MessagingGateway.class);
            for (Map.Entry attribute : annotationAttributes.entrySet()) {
                String key = (String)attribute.getKey();
                Object value = MessagingAnnotationUtils.resolveAttribute(annotationChain, key, Object.class);
                if (value == null) continue;
                attribute.setValue(value);
            }
        }
        return annotationAttributes;
    }

    @Override
    protected void onInit() {
        BeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory beanFactory2 = (ConfigurableBeanFactory)beanFactory;
            this.resolver = beanFactory2.getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext(beanFactory2, null);
        }
        this.populateGatewayMethodMetadataIfAny();
        String defaultRequestTimeout = this.resolveAttribute("defaultRequestTimeout");
        String defaultReplyTimeout = this.resolveAttribute("defaultReplyTimeout");
        JavaUtils.INSTANCE.acceptIfCondition(this.getDefaultRequestChannel() == null && this.getDefaultRequestChannelName() == null, this.resolveAttribute("defaultRequestChannel"), this::setDefaultRequestChannelName).acceptIfCondition(this.getDefaultReplyChannel() == null && this.getDefaultReplyChannelName() == null, this.resolveAttribute("defaultReplyChannel"), this::setDefaultReplyChannelName).acceptIfCondition(this.getErrorChannel() == null && this.getErrorChannelName() == null, this.resolveAttribute("errorChannel"), this::setErrorChannelName).acceptIfCondition(this.getDefaultRequestTimeout() == null && StringUtils.hasText((String)defaultRequestTimeout), this.evaluateExpression(defaultRequestTimeout, Long.class), this::setDefaultRequestTimeout).acceptIfCondition(this.getDefaultReplyTimeout() == null && StringUtils.hasText((String)defaultReplyTimeout), this.evaluateExpression(defaultReplyTimeout, Long.class), this::setDefaultReplyTimeout);
        this.populateAsyncExecutorIfAny();
        boolean proxyDefaultMethods = this.gatewayAttributes.getBoolean("proxyDefaultMethods");
        if (proxyDefaultMethods) {
            this.setProxyDefaultMethods(true);
        }
        super.onInit();
    }

    private void populateGatewayMethodMetadataIfAny() {
        if (this.getGlobalMethodMetadata() != null) {
            return;
        }
        ConfigurableBeanFactory beanFactory = (ConfigurableBeanFactory)this.getBeanFactory();
        String defaultPayloadExpression = this.resolveAttribute("defaultPayloadExpression");
        Object[] defaultHeaders = (GatewayHeader[])this.gatewayAttributes.get((Object)"defaultHeaders");
        String mapper = this.resolveAttribute("mapper");
        boolean hasMapper = StringUtils.hasText((String)mapper);
        boolean hasDefaultPayloadExpression = StringUtils.hasText((String)defaultPayloadExpression);
        Assert.state((!hasMapper || !hasDefaultPayloadExpression ? 1 : 0) != 0, (String)"'defaultPayloadExpression' is not allowed when a 'mapper' is provided");
        boolean hasDefaultHeaders = !ObjectUtils.isEmpty((Object[])defaultHeaders);
        Assert.state((!hasMapper || !hasDefaultHeaders ? 1 : 0) != 0, (String)"'defaultHeaders' are not allowed when a 'mapper' is provided");
        JavaUtils.INSTANCE.acceptIfCondition(hasMapper && this.getMapper() == null, mapper, value -> this.setMapper((MethodArgsMessageMapper)beanFactory.getBean(value, MethodArgsMessageMapper.class)));
        if (hasDefaultHeaders || hasDefaultPayloadExpression) {
            GatewayMethodMetadata gatewayMethodMetadata = new GatewayMethodMetadata();
            if (hasDefaultPayloadExpression) {
                gatewayMethodMetadata.setPayloadExpression(EXPRESSION_PARSER.parseExpression(defaultPayloadExpression));
            }
            Map<String, Expression> headerExpressions = Arrays.stream(defaultHeaders).collect(Collectors.toMap(header -> beanFactory.resolveEmbeddedValue(header.name()), header -> {
                String headerExpression;
                String headerValue = beanFactory.resolveEmbeddedValue(header.value());
                boolean hasValue = StringUtils.hasText((String)headerValue);
                Assert.state((hasValue != StringUtils.hasText((String)(headerExpression = beanFactory.resolveEmbeddedValue(header.expression()))) ? 1 : 0) != 0, (String)"exactly one of 'value' or 'expression' is required on a gateway's header.");
                return hasValue ? new LiteralExpression(headerValue) : EXPRESSION_PARSER.parseExpression(headerExpression);
            }));
            gatewayMethodMetadata.setHeaderExpressions(headerExpressions);
            this.setGlobalMethodMetadata(gatewayMethodMetadata);
        }
    }

    private void populateAsyncExecutorIfAny() {
        BeanFactory beanFactory = this.getBeanFactory();
        if (!this.isAsyncExecutorExplicitlySet()) {
            String asyncExecutor = this.resolveAttribute("asyncExecutor");
            if (asyncExecutor == null || "__NULL__".equals(asyncExecutor)) {
                this.setAsyncExecutor(null);
            } else if (StringUtils.hasText((String)asyncExecutor)) {
                this.setAsyncExecutor((Executor)beanFactory.getBean(asyncExecutor, Executor.class));
            }
        }
    }

    @Nullable
    private String resolveAttribute(String attributeName) {
        ConfigurableBeanFactory beanFactory = (ConfigurableBeanFactory)this.getBeanFactory();
        return beanFactory.resolveEmbeddedValue(this.gatewayAttributes.getString(attributeName));
    }

    @Nullable
    private <V> V evaluateExpression(@Nullable String value, Class<V> targetClass) {
        if (StringUtils.hasText((String)value)) {
            Object result = this.resolver.evaluate(value, this.expressionContext);
            return (V)this.getConversionService().convert(result, targetClass);
        }
        return null;
    }
}

