/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dispatcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.dispatcher.LoadBalancingStrategy;
import org.springframework.integration.dispatcher.MessageHandlingTaskDecorator;
import org.springframework.integration.dispatcher.UnicastingDispatcher;
import org.springframework.integration.util.ErrorHandlingTaskExecutor;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public class PartitionedDispatcher
extends AbstractDispatcher {
    private final Map<Integer, UnicastingDispatcher> partitions = new HashMap<Integer, UnicastingDispatcher>();
    private final List<ExecutorService> executors = new ArrayList<ExecutorService>();
    private final int partitionCount;
    private final Function<Message<?>, Object> partitionKeyFunction;
    private ThreadFactory threadFactory = new CustomizableThreadFactory("partition-thread-");
    private boolean failover = true;
    @Nullable
    private LoadBalancingStrategy loadBalancingStrategy;
    private ErrorHandler errorHandler;
    private MessageHandlingTaskDecorator messageHandlingTaskDecorator = task -> task;

    public PartitionedDispatcher(int partitionCount, Function<Message<?>, Object> partitionKeyFunction) {
        Assert.isTrue((partitionCount > 0 ? 1 : 0) != 0, (String)"'partitionCount' must be greater than 0");
        Assert.notNull(partitionKeyFunction, (String)"'partitionKeyFunction' must not be null");
        this.partitionKeyFunction = partitionKeyFunction;
        this.partitionCount = partitionCount;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        Assert.notNull((Object)threadFactory, (String)"'threadFactory' must not be null");
        this.threadFactory = threadFactory;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    public void setLoadBalancingStrategy(@Nullable LoadBalancingStrategy loadBalancingStrategy) {
        this.loadBalancingStrategy = loadBalancingStrategy;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setMessageHandlingTaskDecorator(MessageHandlingTaskDecorator messageHandlingTaskDecorator) {
        Assert.notNull((Object)messageHandlingTaskDecorator, (String)"'messageHandlingTaskDecorator' must not be null.");
        this.messageHandlingTaskDecorator = messageHandlingTaskDecorator;
    }

    public void shutdown() {
        this.executors.forEach(ExecutorService::shutdown);
        this.executors.clear();
        this.partitions.clear();
    }

    @Override
    public boolean dispatch(Message<?> message) {
        this.populatedPartitions();
        int partition = Math.abs(this.partitionKeyFunction.apply(message).hashCode()) % this.partitionCount;
        UnicastingDispatcher partitionDispatcher = this.partitions.get(partition);
        return partitionDispatcher.dispatch(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populatedPartitions() {
        if (this.partitions.isEmpty()) {
            Map<Integer, UnicastingDispatcher> map = this.partitions;
            synchronized (map) {
                if (this.partitions.isEmpty()) {
                    HashMap<Integer, UnicastingDispatcher> partitionsToUse = new HashMap<Integer, UnicastingDispatcher>();
                    for (int i = 0; i < this.partitionCount; ++i) {
                        partitionsToUse.put(i, this.newPartition());
                    }
                    this.partitions.putAll(partitionsToUse);
                }
            }
        }
    }

    private UnicastingDispatcher newPartition() {
        ExecutorService executor = Executors.newSingleThreadExecutor(this.threadFactory);
        this.executors.add(executor);
        DelegateDispatcher delegateDispatcher = new DelegateDispatcher((Executor)((Object)new ErrorHandlingTaskExecutor(executor, this.errorHandler)));
        delegateDispatcher.setFailover(this.failover);
        delegateDispatcher.setLoadBalancingStrategy(this.loadBalancingStrategy);
        delegateDispatcher.setMessageHandlingTaskDecorator(this.messageHandlingTaskDecorator);
        return delegateDispatcher;
    }

    private final class DelegateDispatcher
    extends UnicastingDispatcher {
        DelegateDispatcher(Executor executor) {
            super(executor);
        }

        @Override
        protected Set<MessageHandler> getHandlers() {
            return PartitionedDispatcher.this.getHandlers();
        }

        @Override
        protected boolean tryOptimizedDispatch(Message<?> message) {
            return PartitionedDispatcher.this.tryOptimizedDispatch(message);
        }
    }
}

