/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.reflect.AnnotatedElement;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.integration.annotation.MessagingGateway;
import org.springframework.integration.gateway.AnnotationGatewayProxyFactoryBean;

class GatewayProxyInstantiationPostProcessor
implements InstantiationAwareBeanPostProcessor,
BeanRegistrationAotProcessor,
ApplicationContextAware {
    private final BeanDefinitionRegistry registry;
    private ApplicationContext applicationContext;

    GatewayProxyInstantiationPostProcessor(BeanDefinitionRegistry registry) {
        this.registry = registry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        BeanDefinition beanDefinition;
        if (beanClass.isInterface() && AnnotatedElementUtils.hasAnnotation(beanClass, MessagingGateway.class) && ((beanDefinition = this.registry.getBeanDefinition(beanName)) instanceof AnnotatedGenericBeanDefinition || beanDefinition instanceof ScannedGenericBeanDefinition)) {
            AnnotationGatewayProxyFactoryBean gatewayProxyFactoryBean = new AnnotationGatewayProxyFactoryBean(beanClass);
            gatewayProxyFactoryBean.setApplicationContext(this.applicationContext);
            gatewayProxyFactoryBean.setBeanFactory((BeanFactory)this.applicationContext.getAutowireCapableBeanFactory());
            ClassLoader classLoader = this.applicationContext.getClassLoader();
            if (classLoader != null) {
                gatewayProxyFactoryBean.setBeanClassLoader(classLoader);
            }
            gatewayProxyFactoryBean.setBeanName(beanName);
            gatewayProxyFactoryBean.afterPropertiesSet();
            return gatewayProxyFactoryBean;
        }
        return null;
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class beanClass = registeredBean.getBeanClass();
        if (beanClass.isInterface() && AnnotatedElementUtils.hasAnnotation((AnnotatedElement)beanClass, MessagingGateway.class)) {
            RootBeanDefinition beanDefinition = registeredBean.getMergedBeanDefinition();
            beanDefinition.setBeanClass(AnnotationGatewayProxyFactoryBean.class);
            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)beanClass);
            beanDefinition.setTargetType(ResolvableType.forClassWithGenerics(AnnotationGatewayProxyFactoryBean.class, (Class[])new Class[]{beanClass}));
        }
        return null;
    }
}

