/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.integration.json;

import org.springframework.core.convert.converter.Converter;

/**
 * The {@link Converter} implementation for the conversion of
 * {@link JsonPropertyAccessor.ToStringFriendlyJsonNode} to {@link String},
 * when the {@link JsonPropertyAccessor.ToStringFriendlyJsonNode} can be a result of the
 * expression for JSON in case of the {@link JsonPropertyAccessor} usage.
 *
 * @author Artem Bilan
 * @since 4.1
 */
class ToStringFriendlyJsonNodeToStringConverter
		implements Converter<JsonPropertyAccessor.ToStringFriendlyJsonNode, String> {

	@Override
	public String convert(JsonPropertyAccessor.ToStringFriendlyJsonNode source) {
		return source.toString();
	}

}
